/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.util;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HapiUtils {
    public static final Comparator<SemanticVersion> SEMANTIC_VERSION_COMPARATOR = Comparator.nullsFirst(Comparator.comparingInt(SemanticVersion::major).thenComparingInt(SemanticVersion::minor).thenComparingInt(SemanticVersion::patch).thenComparingInt(semVer -> HapiUtils.parsedAlphaIntOrMaxValue(semVer.pre())).thenComparingInt(semVer -> HapiUtils.parsedIntOrZero(semVer.build())));
    public static final Comparator<Timestamp> TIMESTAMP_COMPARATOR = Comparator.comparingLong(Timestamp::seconds).thenComparingInt(Timestamp::nanos);
    private static final String ALPHA_PREFIX = "alpha.";
    private static final int ALPHA_PREFIX_LENGTH = "alpha.".length();
    private static final int EVM_ADDRESS_ALIAS_LENGTH = 20;
    public static final Key EMPTY_KEY_LIST = Key.newBuilder().keyList(KeyList.DEFAULT).build();
    public static final long FUNDING_ACCOUNT_EXPIRY = 33197904000L;
    private static final int MAX_VERSION_LENGTH = 100;
    public static final Pattern SEMVER_SPEC_REGEX = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    public static final Comparator<AccountID> ACCOUNT_ID_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1.hasAccountNum() && !o2.hasAccountNum()) {
            return -1;
        }
        if (!o1.hasAccountNum() && o2.hasAccountNum()) {
            return 1;
        }
        if (o1.hasAccountNum()) {
            return Long.compare(o1.accountNumOrThrow(), o2.accountNumOrThrow());
        }
        Bytes alias1 = o1.aliasOrElse(Bytes.EMPTY);
        Bytes alias2 = o2.aliasOrElse(Bytes.EMPTY);
        long diff = alias1.length() - alias2.length();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        for (long i = 0L; i < alias1.length(); ++i) {
            byte b2;
            byte b1 = alias1.getByte(i);
            if (b1 < (b2 = alias2.getByte(i))) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return 0;
    };
    public static final Comparator<ContractID> CONTRACT_ID_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1.hasContractNum() && !o2.hasContractNum()) {
            return -1;
        }
        if (!o1.hasContractNum() && o2.hasContractNum()) {
            return 1;
        }
        if (o1.hasContractNum()) {
            return Long.compare(o1.contractNumOrThrow(), o2.contractNumOrThrow());
        }
        Bytes alias1 = o1.evmAddressOrElse(Bytes.EMPTY);
        Bytes alias2 = o2.evmAddressOrElse(Bytes.EMPTY);
        long diff = alias1.length() - alias2.length();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        for (long i = 0L; i < alias1.length(); ++i) {
            byte b2;
            byte b1 = alias1.getByte(i);
            if (b1 < (b2 = alias2.getByte(i))) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return 0;
    };
    private static final Set<HederaFunctionality> QUERY_FUNCTIONS = EnumSet.of(HederaFunctionality.CONSENSUS_GET_TOPIC_INFO, new HederaFunctionality[]{HederaFunctionality.GET_BY_SOLIDITY_ID, HederaFunctionality.CONTRACT_CALL_LOCAL, HederaFunctionality.CONTRACT_GET_INFO, HederaFunctionality.CONTRACT_GET_BYTECODE, HederaFunctionality.CONTRACT_GET_RECORDS, HederaFunctionality.CRYPTO_GET_ACCOUNT_BALANCE, HederaFunctionality.CRYPTO_GET_ACCOUNT_RECORDS, HederaFunctionality.CRYPTO_GET_INFO, HederaFunctionality.CRYPTO_GET_LIVE_HASH, HederaFunctionality.FILE_GET_CONTENTS, HederaFunctionality.FILE_GET_INFO, HederaFunctionality.TRANSACTION_GET_RECEIPT, HederaFunctionality.TRANSACTION_GET_RECORD, HederaFunctionality.GET_VERSION_INFO, HederaFunctionality.TOKEN_GET_INFO, HederaFunctionality.SCHEDULE_GET_INFO, HederaFunctionality.TOKEN_GET_NFT_INFO, HederaFunctionality.TOKEN_GET_NFT_INFOS, HederaFunctionality.TOKEN_GET_ACCOUNT_NFT_INFOS, HederaFunctionality.NETWORK_GET_EXECUTION_TIME, HederaFunctionality.GET_ACCOUNT_DETAILS});

    private HapiUtils() {
    }

    public static boolean isHollow(@NonNull Account account) {
        Objects.requireNonNull(account);
        return account.accountIdOrThrow().accountNum() > 1000L && account.keyOrElse(EMPTY_KEY_LIST).equals(EMPTY_KEY_LIST) && account.alias() != null && account.alias().length() == 20L;
    }

    public static Timestamp asTimestamp(@NonNull Instant instant) {
        return new Timestamp(instant.getEpochSecond(), instant.getNano());
    }

    public static Instant asInstant(@NonNull Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.seconds(), timestamp.nanos());
    }

    public static Timestamp minus(@NonNull Timestamp ts, long seconds) {
        return Timestamp.newBuilder().seconds(ts.seconds() - seconds).nanos(ts.nanos()).build();
    }

    public static boolean isBefore(@NonNull Timestamp t1, @NonNull Timestamp t2) {
        return TIMESTAMP_COMPARATOR.compare(t1, t2) < 0;
    }

    public static int countOfCryptographicKeys(@NonNull Key key) {
        return switch ((Key.KeyOneOfType)key.key().kind()) {
            default -> throw new MatchException(null, null);
            case Key.KeyOneOfType.ECDSA_384, Key.KeyOneOfType.ED25519, Key.KeyOneOfType.RSA_3072, Key.KeyOneOfType.ECDSA_SECP256K1 -> 1;
            case Key.KeyOneOfType.KEY_LIST -> key.keyListOrThrow().keys().stream().mapToInt(HapiUtils::countOfCryptographicKeys).sum();
            case Key.KeyOneOfType.THRESHOLD_KEY -> key.thresholdKeyOrThrow().keysOrElse(KeyList.DEFAULT).keys().stream().mapToInt(HapiUtils::countOfCryptographicKeys).sum();
            case Key.KeyOneOfType.CONTRACT_ID, Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID, Key.KeyOneOfType.UNSET -> 0;
        };
    }

    public static HederaFunctionality functionOf(TransactionBody txn) throws UnknownHederaFunctionality {
        return switch ((TransactionBody.DataOneOfType)txn.data().kind()) {
            default -> throw new MatchException(null, null);
            case TransactionBody.DataOneOfType.ATOMIC_BATCH -> HederaFunctionality.ATOMIC_BATCH;
            case TransactionBody.DataOneOfType.CONSENSUS_CREATE_TOPIC -> HederaFunctionality.CONSENSUS_CREATE_TOPIC;
            case TransactionBody.DataOneOfType.CONSENSUS_UPDATE_TOPIC -> HederaFunctionality.CONSENSUS_UPDATE_TOPIC;
            case TransactionBody.DataOneOfType.CONSENSUS_DELETE_TOPIC -> HederaFunctionality.CONSENSUS_DELETE_TOPIC;
            case TransactionBody.DataOneOfType.CONSENSUS_SUBMIT_MESSAGE -> HederaFunctionality.CONSENSUS_SUBMIT_MESSAGE;
            case TransactionBody.DataOneOfType.CONTRACT_CALL -> HederaFunctionality.CONTRACT_CALL;
            case TransactionBody.DataOneOfType.CONTRACT_CREATE_INSTANCE -> HederaFunctionality.CONTRACT_CREATE;
            case TransactionBody.DataOneOfType.CONTRACT_UPDATE_INSTANCE -> HederaFunctionality.CONTRACT_UPDATE;
            case TransactionBody.DataOneOfType.CONTRACT_DELETE_INSTANCE -> HederaFunctionality.CONTRACT_DELETE;
            case TransactionBody.DataOneOfType.CRYPTO_ADD_LIVE_HASH -> HederaFunctionality.CRYPTO_ADD_LIVE_HASH;
            case TransactionBody.DataOneOfType.CRYPTO_APPROVE_ALLOWANCE -> HederaFunctionality.CRYPTO_APPROVE_ALLOWANCE;
            case TransactionBody.DataOneOfType.CRYPTO_CREATE_ACCOUNT -> HederaFunctionality.CRYPTO_CREATE;
            case TransactionBody.DataOneOfType.CRYPTO_UPDATE_ACCOUNT -> HederaFunctionality.CRYPTO_UPDATE;
            case TransactionBody.DataOneOfType.CRYPTO_DELETE -> HederaFunctionality.CRYPTO_DELETE;
            case TransactionBody.DataOneOfType.CRYPTO_DELETE_ALLOWANCE -> HederaFunctionality.CRYPTO_DELETE_ALLOWANCE;
            case TransactionBody.DataOneOfType.CRYPTO_DELETE_LIVE_HASH -> HederaFunctionality.CRYPTO_DELETE_LIVE_HASH;
            case TransactionBody.DataOneOfType.CRYPTO_TRANSFER -> HederaFunctionality.CRYPTO_TRANSFER;
            case TransactionBody.DataOneOfType.ETHEREUM_TRANSACTION -> HederaFunctionality.ETHEREUM_TRANSACTION;
            case TransactionBody.DataOneOfType.HOOK_STORE -> HederaFunctionality.HOOK_STORE;
            case TransactionBody.DataOneOfType.HOOK_DISPATCH -> HederaFunctionality.HOOK_DISPATCH;
            case TransactionBody.DataOneOfType.FILE_APPEND -> HederaFunctionality.FILE_APPEND;
            case TransactionBody.DataOneOfType.FILE_CREATE -> HederaFunctionality.FILE_CREATE;
            case TransactionBody.DataOneOfType.FILE_UPDATE -> HederaFunctionality.FILE_UPDATE;
            case TransactionBody.DataOneOfType.FILE_DELETE -> HederaFunctionality.FILE_DELETE;
            case TransactionBody.DataOneOfType.FREEZE -> HederaFunctionality.FREEZE;
            case TransactionBody.DataOneOfType.NODE_CREATE -> HederaFunctionality.NODE_CREATE;
            case TransactionBody.DataOneOfType.NODE_DELETE -> HederaFunctionality.NODE_DELETE;
            case TransactionBody.DataOneOfType.NODE_STAKE_UPDATE -> HederaFunctionality.NODE_STAKE_UPDATE;
            case TransactionBody.DataOneOfType.NODE_UPDATE -> HederaFunctionality.NODE_UPDATE;
            case TransactionBody.DataOneOfType.SCHEDULE_CREATE -> HederaFunctionality.SCHEDULE_CREATE;
            case TransactionBody.DataOneOfType.SCHEDULE_SIGN -> HederaFunctionality.SCHEDULE_SIGN;
            case TransactionBody.DataOneOfType.SCHEDULE_DELETE -> HederaFunctionality.SCHEDULE_DELETE;
            case TransactionBody.DataOneOfType.STATE_SIGNATURE_TRANSACTION -> HederaFunctionality.STATE_SIGNATURE_TRANSACTION;
            case TransactionBody.DataOneOfType.SYSTEM_DELETE -> HederaFunctionality.SYSTEM_DELETE;
            case TransactionBody.DataOneOfType.SYSTEM_UNDELETE -> HederaFunctionality.SYSTEM_UNDELETE;
            case TransactionBody.DataOneOfType.TOKEN_AIRDROP -> HederaFunctionality.TOKEN_AIRDROP;
            case TransactionBody.DataOneOfType.TOKEN_ASSOCIATE -> HederaFunctionality.TOKEN_ASSOCIATE_TO_ACCOUNT;
            case TransactionBody.DataOneOfType.TOKEN_BURN -> HederaFunctionality.TOKEN_BURN;
            case TransactionBody.DataOneOfType.TOKEN_CANCEL_AIRDROP -> HederaFunctionality.TOKEN_CANCEL_AIRDROP;
            case TransactionBody.DataOneOfType.TOKEN_CLAIM_AIRDROP -> HederaFunctionality.TOKEN_CLAIM_AIRDROP;
            case TransactionBody.DataOneOfType.TOKEN_CREATION -> HederaFunctionality.TOKEN_CREATE;
            case TransactionBody.DataOneOfType.TOKEN_DELETION -> HederaFunctionality.TOKEN_DELETE;
            case TransactionBody.DataOneOfType.TOKEN_DISSOCIATE -> HederaFunctionality.TOKEN_DISSOCIATE_FROM_ACCOUNT;
            case TransactionBody.DataOneOfType.TOKEN_FEE_SCHEDULE_UPDATE -> HederaFunctionality.TOKEN_FEE_SCHEDULE_UPDATE;
            case TransactionBody.DataOneOfType.TOKEN_FREEZE -> HederaFunctionality.TOKEN_FREEZE_ACCOUNT;
            case TransactionBody.DataOneOfType.TOKEN_GRANT_KYC -> HederaFunctionality.TOKEN_GRANT_KYC_TO_ACCOUNT;
            case TransactionBody.DataOneOfType.TOKEN_MINT -> HederaFunctionality.TOKEN_MINT;
            case TransactionBody.DataOneOfType.TOKEN_PAUSE -> HederaFunctionality.TOKEN_PAUSE;
            case TransactionBody.DataOneOfType.TOKEN_REJECT -> HederaFunctionality.TOKEN_REJECT;
            case TransactionBody.DataOneOfType.TOKEN_REVOKE_KYC -> HederaFunctionality.TOKEN_REVOKE_KYC_FROM_ACCOUNT;
            case TransactionBody.DataOneOfType.TOKEN_UNFREEZE -> HederaFunctionality.TOKEN_UNFREEZE_ACCOUNT;
            case TransactionBody.DataOneOfType.TOKEN_UNPAUSE -> HederaFunctionality.TOKEN_UNPAUSE;
            case TransactionBody.DataOneOfType.TOKEN_UPDATE -> HederaFunctionality.TOKEN_UPDATE;
            case TransactionBody.DataOneOfType.TOKEN_UPDATE_NFTS -> HederaFunctionality.TOKEN_UPDATE_NFTS;
            case TransactionBody.DataOneOfType.TOKEN_WIPE -> HederaFunctionality.TOKEN_ACCOUNT_WIPE;
            case TransactionBody.DataOneOfType.UNCHECKED_SUBMIT -> HederaFunctionality.UNCHECKED_SUBMIT;
            case TransactionBody.DataOneOfType.UTIL_PRNG -> HederaFunctionality.UTIL_PRNG;
            case TransactionBody.DataOneOfType.HINTS_PREPROCESSING_VOTE -> HederaFunctionality.HINTS_PREPROCESSING_VOTE;
            case TransactionBody.DataOneOfType.HINTS_KEY_PUBLICATION -> HederaFunctionality.HINTS_KEY_PUBLICATION;
            case TransactionBody.DataOneOfType.HINTS_PARTIAL_SIGNATURE -> HederaFunctionality.HINTS_PARTIAL_SIGNATURE;
            case TransactionBody.DataOneOfType.HISTORY_PROOF_SIGNATURE -> HederaFunctionality.HISTORY_ASSEMBLY_SIGNATURE;
            case TransactionBody.DataOneOfType.HISTORY_PROOF_KEY_PUBLICATION -> HederaFunctionality.HISTORY_PROOF_KEY_PUBLICATION;
            case TransactionBody.DataOneOfType.HISTORY_PROOF_VOTE -> HederaFunctionality.HISTORY_PROOF_VOTE;
            case TransactionBody.DataOneOfType.CRS_PUBLICATION -> HederaFunctionality.CRS_PUBLICATION;
            case TransactionBody.DataOneOfType.UNSET -> throw new UnknownHederaFunctionality();
        };
    }

    public static HederaFunctionality functionOf(Query txn) throws UnknownHederaFunctionality {
        return switch ((Query.QueryOneOfType)txn.query().kind()) {
            default -> throw new MatchException(null, null);
            case Query.QueryOneOfType.TOKEN_GET_ACCOUNT_NFT_INFOS -> HederaFunctionality.TOKEN_GET_ACCOUNT_NFT_INFOS;
            case Query.QueryOneOfType.TOKEN_GET_NFT_INFOS -> HederaFunctionality.TOKEN_GET_NFT_INFOS;
            case Query.QueryOneOfType.ACCOUNT_DETAILS -> HederaFunctionality.GET_ACCOUNT_DETAILS;
            case Query.QueryOneOfType.CONSENSUS_GET_TOPIC_INFO -> HederaFunctionality.CONSENSUS_GET_TOPIC_INFO;
            case Query.QueryOneOfType.CONTRACT_CALL_LOCAL -> HederaFunctionality.CONTRACT_CALL_LOCAL;
            case Query.QueryOneOfType.CONTRACT_GET_BYTECODE -> HederaFunctionality.CONTRACT_GET_BYTECODE;
            case Query.QueryOneOfType.CONTRACT_GET_INFO -> HederaFunctionality.CONTRACT_GET_INFO;
            case Query.QueryOneOfType.CONTRACT_GET_RECORDS -> HederaFunctionality.CONTRACT_GET_RECORDS;
            case Query.QueryOneOfType.CRYPTO_GET_ACCOUNT_RECORDS -> HederaFunctionality.CRYPTO_GET_ACCOUNT_RECORDS;
            case Query.QueryOneOfType.CRYPTO_GET_INFO -> HederaFunctionality.CRYPTO_GET_INFO;
            case Query.QueryOneOfType.CRYPTO_GET_LIVE_HASH -> HederaFunctionality.CRYPTO_GET_LIVE_HASH;
            case Query.QueryOneOfType.FILE_GET_CONTENTS -> HederaFunctionality.FILE_GET_CONTENTS;
            case Query.QueryOneOfType.FILE_GET_INFO -> HederaFunctionality.FILE_GET_INFO;
            case Query.QueryOneOfType.CRYPTO_GET_PROXY_STAKERS -> HederaFunctionality.CRYPTO_GET_STAKERS;
            case Query.QueryOneOfType.GET_BY_SOLIDITY_ID -> HederaFunctionality.GET_BY_SOLIDITY_ID;
            case Query.QueryOneOfType.CRYPTOGET_ACCOUNT_BALANCE -> HederaFunctionality.CRYPTO_GET_ACCOUNT_BALANCE;
            case Query.QueryOneOfType.GET_BY_KEY -> HederaFunctionality.GET_BY_KEY;
            case Query.QueryOneOfType.NETWORK_GET_EXECUTION_TIME -> HederaFunctionality.NETWORK_GET_EXECUTION_TIME;
            case Query.QueryOneOfType.SCHEDULE_GET_INFO -> HederaFunctionality.SCHEDULE_GET_INFO;
            case Query.QueryOneOfType.TOKEN_GET_INFO -> HederaFunctionality.TOKEN_GET_INFO;
            case Query.QueryOneOfType.TOKEN_GET_NFT_INFO -> HederaFunctionality.TOKEN_GET_NFT_INFO;
            case Query.QueryOneOfType.NETWORK_GET_VERSION_INFO -> HederaFunctionality.GET_VERSION_INFO;
            case Query.QueryOneOfType.TRANSACTION_GET_RECEIPT -> HederaFunctionality.TRANSACTION_GET_RECEIPT;
            case Query.QueryOneOfType.TRANSACTION_GET_RECORD -> HederaFunctionality.TRANSACTION_GET_RECORD;
            case Query.QueryOneOfType.TRANSACTION_GET_FAST_RECORD -> HederaFunctionality.TRANSACTION_GET_FAST_RECORD;
            case Query.QueryOneOfType.UNSET -> throw new UnknownHederaFunctionality();
        };
    }

    public static String toString(@Nullable SemanticVersion version) {
        if (version == null) {
            return "<NONE>";
        }
        StringBuilder baseVersion = new StringBuilder("v");
        baseVersion.append(version.major()).append(".").append(version.minor()).append(".").append(version.patch());
        if (!version.pre().isBlank()) {
            baseVersion.append("-").append(version.pre());
        }
        if (!version.build().isBlank()) {
            baseVersion.append("+").append(version.build());
        }
        return baseVersion.toString();
    }

    public static SemanticVersion fromString(@NonNull String value) {
        Objects.requireNonNull(value, "value must not be null");
        if (value.length() > 100) {
            throw new IllegalArgumentException("Semantic version '" + value + "' is too long");
        }
        Matcher matcher = SEMVER_SPEC_REGEX.matcher(value);
        if (matcher.matches()) {
            SemanticVersion.Builder builder = SemanticVersion.newBuilder().major(Integer.parseInt(matcher.group(1))).minor(Integer.parseInt(matcher.group(2))).patch(Integer.parseInt(matcher.group(3)));
            if (matcher.group(4) != null) {
                builder.pre(matcher.group(4));
            }
            if (matcher.group(5) != null) {
                builder.build(matcher.group(5));
            }
            return builder.build();
        }
        throw new IllegalArgumentException("'" + value + "' is not a valid semantic version");
    }

    public static AccountID parseAccountFromLegacy(@NonNull String string, long shard, long realm) {
        try {
            String[] parts = string.split("\\.");
            return AccountID.newBuilder().shardNum(shard).realmNum(realm).accountNum(Long.parseLong(parts[2])).build();
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException(String.format("'%s' is not a dot-separated triplet", string));
        }
    }

    public static String toString(@NonNull AccountID id) {
        StringBuilder builder = new StringBuilder().append(id.shardNum()).append(".").append(id.realmNum()).append(".");
        if (id.hasAccountNum()) {
            builder.append(id.accountNum());
        } else if (id.hasAlias()) {
            builder.append(id.alias());
        } else {
            builder.append("-");
        }
        return builder.toString();
    }

    public static String asReadableIp(@NonNull Bytes ipV4Addr) {
        Objects.requireNonNull(ipV4Addr);
        return "%d.%d.%d.%d".formatted(ipV4Addr.getByte(0L) & 0xFF, ipV4Addr.getByte(1L) & 0xFF, ipV4Addr.getByte(2L) & 0xFF, ipV4Addr.getByte(3L) & 0xFF);
    }

    public static String asAccountString(@NonNull AccountID accountID) {
        return String.format("%d.%d.%d", accountID.shardNum(), accountID.realmNum(), accountID.accountNum());
    }

    private static int parsedAlphaIntOrMaxValue(@NonNull String s) {
        if (s.isBlank() || !s.startsWith(ALPHA_PREFIX)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(s.substring(ALPHA_PREFIX_LENGTH));
        }
        catch (NumberFormatException ignore) {
            return Integer.MAX_VALUE;
        }
    }

    private static int parsedIntOrZero(@NonNull String s) {
        if (s.isBlank() || "0".equals(s)) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }
}

