/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.builder;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.metrics.event.EventPipelineTracker;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.component.framework.WiringConfig;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.model.WiringModelBuilder;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.builder.ApplicationCallbacks;
import com.swirlds.platform.builder.ConsensusModuleBuilder;
import com.swirlds.platform.builder.ExecutionLayer;
import com.swirlds.platform.builder.PlatformBuildingBlocks;
import com.swirlds.platform.builder.PlatformComponentBuilder;
import com.swirlds.platform.builder.internal.StaticPlatformBuilder;
import com.swirlds.platform.config.internal.PlatformConfigUtils;
import com.swirlds.platform.gossip.DefaultIntakeEventCounter;
import com.swirlds.platform.gossip.NoOpIntakeEventCounter;
import com.swirlds.platform.gossip.sync.config.SyncConfig;
import com.swirlds.platform.metrics.PlatformMetricsConfig;
import com.swirlds.platform.network.protocol.ReservedSignedStateResult;
import com.swirlds.platform.reconnect.FallenBehindMonitor;
import com.swirlds.platform.scratchpad.Scratchpad;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.iss.IssScratchpad;
import com.swirlds.platform.state.service.PlatformStateUtils;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.status.StatusActionSubmitter;
import com.swirlds.platform.wiring.PlatformComponents;
import com.swirlds.platform.wiring.PlatformWiring;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.StateLifecycleManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.BlockingResourceProvider;
import org.hiero.base.concurrent.ExecutorFactory;
import org.hiero.base.crypto.CryptoUtils;
import org.hiero.base.crypto.Signature;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.event.creator.EventCreatorModule;
import org.hiero.consensus.event.intake.EventIntakeModule;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.EventTransactionSupplier;
import org.hiero.consensus.model.transaction.SignatureTransactionCheck;
import org.hiero.consensus.pces.PcesConfig;
import org.hiero.consensus.pces.PcesFileReader;
import org.hiero.consensus.pces.PcesFileTracker;
import org.hiero.consensus.pces.PcesUtilities;
import org.hiero.consensus.roster.RosterHistory;

public final class PlatformBuilder {
    private static final Logger logger = LogManager.getLogger(PlatformBuilder.class);
    private final String appName;
    private final SemanticVersion softwareVersion;
    private final ReservedSignedState initialState;
    private final ConsensusStateEventHandler<MerkleNodeState> consensusStateEventHandler;
    private final StateLifecycleManager stateLifecycleManager;
    private final NodeId selfId;
    private final String swirldName;
    private Configuration configuration;
    private ExecutorFactory executorFactory;
    private EventCreatorModule eventCreatorModule;
    private EventIntakeModule eventIntakeModule;
    private static final Thread.UncaughtExceptionHandler DEFAULT_UNCAUGHT_EXCEPTION_HANDLER = (t, e) -> logger.error(LogMarker.EXCEPTION.getMarker(), "Uncaught exception on thread {}: {}", (Object)t, (Object)e);
    private RosterHistory rosterHistory;
    private final String consensusEventStreamName;
    private KeysAndCerts keysAndCerts;
    private final Path configPath = FileUtils.getAbsolutePath((String)"config.txt");
    private WiringModel model;
    private Supplier<SecureRandom> secureRandomSupplier;
    private PlatformContext platformContext;
    private Consumer<PlatformEvent> preconsensusEventConsumer;
    private Consumer<ConsensusSnapshot> snapshotOverrideConsumer;
    private Consumer<PlatformEvent> staleEventConsumer;
    private ExecutionLayer execution;
    private boolean used;

    @NonNull
    public static PlatformBuilder create(@NonNull String appName, @NonNull String swirldName, @NonNull SemanticVersion softwareVersion, @NonNull ReservedSignedState initialState, @NonNull ConsensusStateEventHandler consensusStateEventHandler, @NonNull NodeId selfId, @NonNull String consensusEventStreamName, @NonNull RosterHistory rosterHistory, @NonNull StateLifecycleManager stateLifecycleManager) {
        return new PlatformBuilder(appName, swirldName, softwareVersion, initialState, consensusStateEventHandler, selfId, consensusEventStreamName, rosterHistory, stateLifecycleManager);
    }

    private PlatformBuilder(@NonNull String appName, @NonNull String swirldName, @NonNull SemanticVersion softwareVersion, @NonNull ReservedSignedState initialState, @NonNull ConsensusStateEventHandler consensusStateEventHandler, @NonNull NodeId selfId, @NonNull String consensusEventStreamName, @NonNull RosterHistory rosterHistory, @NonNull StateLifecycleManager stateLifecycleManager) {
        this.appName = Objects.requireNonNull(appName);
        this.swirldName = Objects.requireNonNull(swirldName);
        this.softwareVersion = Objects.requireNonNull(softwareVersion);
        this.initialState = Objects.requireNonNull(initialState);
        this.consensusStateEventHandler = Objects.requireNonNull(consensusStateEventHandler);
        this.selfId = Objects.requireNonNull(selfId);
        this.consensusEventStreamName = Objects.requireNonNull(consensusEventStreamName);
        this.rosterHistory = Objects.requireNonNull(rosterHistory);
        this.stateLifecycleManager = Objects.requireNonNull(stateLifecycleManager);
    }

    @NonNull
    public PlatformBuilder withConfiguration(@NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        PlatformConfigUtils.checkConfiguration(configuration);
        return this;
    }

    @NonNull
    public PlatformBuilder withPreconsensusEventCallback(@NonNull Consumer<PlatformEvent> preconsensusEventConsumer) {
        this.throwIfAlreadyUsed();
        this.preconsensusEventConsumer = Objects.requireNonNull(preconsensusEventConsumer);
        return this;
    }

    @NonNull
    public PlatformBuilder withConsensusSnapshotOverrideCallback(@NonNull Consumer<ConsensusSnapshot> snapshotOverrideConsumer) {
        this.throwIfAlreadyUsed();
        this.snapshotOverrideConsumer = Objects.requireNonNull(snapshotOverrideConsumer);
        return this;
    }

    @NonNull
    public PlatformBuilder withStaleEventCallback(@NonNull Consumer<PlatformEvent> staleEventConsumer) {
        this.throwIfAlreadyUsed();
        this.staleEventConsumer = Objects.requireNonNull(staleEventConsumer);
        return this;
    }

    @NonNull
    public PlatformBuilder withExecutionLayer(@NonNull ExecutionLayer execution) {
        this.throwIfAlreadyUsed();
        this.execution = Objects.requireNonNull(execution);
        return this;
    }

    @NonNull
    public PlatformBuilder withKeysAndCerts(@NonNull KeysAndCerts keysAndCerts) {
        Signature signature;
        this.throwIfAlreadyUsed();
        this.keysAndCerts = Objects.requireNonNull(keysAndCerts);
        if (!CryptoUtils.checkCertificate((Certificate)keysAndCerts.sigCert())) {
            throw new IllegalStateException("Starting the platform requires a signing cert.");
        }
        PlatformSigner platformSigner = new PlatformSigner(keysAndCerts);
        String testString = "testString";
        Bytes testBytes = Bytes.wrap((byte[])"testString".getBytes());
        if (!ConsensusCryptoUtils.verifySignature((Bytes)testBytes, (Bytes)(signature = platformSigner.sign(testBytes.toByteArray())).getBytes(), (PublicKey)keysAndCerts.sigCert().getPublicKey())) {
            throw new IllegalStateException("The signing certificate does not match the signing private key.");
        }
        return this;
    }

    public PlatformBuilder withModel(@NonNull WiringModel model) {
        this.throwIfAlreadyUsed();
        this.model = Objects.requireNonNull(model);
        return this;
    }

    @NonNull
    public PlatformBuilder withSecureRandomSupplier(@NonNull Supplier<SecureRandom> secureRandomSupplier) {
        this.throwIfAlreadyUsed();
        this.secureRandomSupplier = Objects.requireNonNull(secureRandomSupplier);
        return this;
    }

    @NonNull
    public PlatformBuilder withPlatformContext(@NonNull PlatformContext platformContext) {
        this.throwIfAlreadyUsed();
        this.platformContext = Objects.requireNonNull(platformContext);
        return this;
    }

    @NonNull
    public PlatformBuilder withEventCreatorModule(@NonNull EventCreatorModule eventCreatorModule) {
        this.throwIfAlreadyUsed();
        this.eventCreatorModule = Objects.requireNonNull(eventCreatorModule);
        return this;
    }

    private void initializeEventCreatorModule() {
        if (this.eventCreatorModule == null) {
            this.eventCreatorModule = ConsensusModuleBuilder.createEventCreatorModule();
        }
        this.eventCreatorModule.initialize(this.model, this.platformContext.getConfiguration(), this.platformContext.getMetrics(), this.platformContext.getTime(), this.secureRandomSupplier.get(), this.keysAndCerts, this.rosterHistory.getCurrentRoster(), this.selfId, (EventTransactionSupplier)this.execution, (SignatureTransactionCheck)this.execution);
    }

    @NonNull
    public PlatformBuilder withEventIntakeModule(@NonNull EventIntakeModule eventIntakeModule) {
        this.throwIfAlreadyUsed();
        this.eventIntakeModule = Objects.requireNonNull(eventIntakeModule);
        return this;
    }

    private void initializeEventIntakeModule(@NonNull IntakeEventCounter intakeEventCounter, @Nullable EventPipelineTracker pipelineTracker) {
        if (this.eventIntakeModule == null) {
            this.eventIntakeModule = ConsensusModuleBuilder.createEventIntakeModule();
        }
        this.eventIntakeModule.initialize(this.model, this.platformContext.getConfiguration(), this.platformContext.getMetrics(), this.platformContext.getTime(), this.rosterHistory, this.selfId, intakeEventCounter, this.execution.getTransactionLimits(), this.platformContext.getRecycleBin(), this.initialState.get().getRound(), pipelineTracker);
    }

    private void throwIfAlreadyUsed() {
        if (this.used) {
            throw new IllegalStateException("PlatformBuilder has already been used");
        }
    }

    @NonNull
    public PlatformComponentBuilder buildComponentBuilder() {
        boolean eventPipelineMetricsEnabled;
        PcesFileTracker initialPcesFiles;
        this.throwIfAlreadyUsed();
        this.used = true;
        if (this.executorFactory == null) {
            this.executorFactory = ExecutorFactory.create((String)"platform", null, (Thread.UncaughtExceptionHandler)DEFAULT_UNCAUGHT_EXCEPTION_HANDLER);
        }
        boolean firstPlatform = StaticPlatformBuilder.doStaticSetup(this.configuration, this.configPath);
        Roster currentRoster = this.rosterHistory.getCurrentRoster();
        SyncConfig syncConfig = (SyncConfig)this.platformContext.getConfiguration().getConfigData(SyncConfig.class);
        Object intakeEventCounter = syncConfig.waitForEventsInIntake() ? new DefaultIntakeEventCounter(currentRoster) : new NoOpIntakeEventCounter();
        PcesConfig preconsensusEventStreamConfig = (PcesConfig)this.platformContext.getConfiguration().getConfigData(PcesConfig.class);
        try {
            Path databaseDirectory = PcesUtilities.getDatabaseDirectory((Configuration)this.platformContext.getConfiguration(), (NodeId)this.selfId);
            initialPcesFiles = PcesFileReader.readFilesFromDisk((Configuration)this.platformContext.getConfiguration(), (RecycleBin)this.platformContext.getRecycleBin(), (Path)databaseDirectory, (long)this.initialState.get().getRound(), (boolean)preconsensusEventStreamConfig.permitGaps());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Scratchpad<IssScratchpad> issScratchpad = Scratchpad.create(this.platformContext.getConfiguration(), this.selfId, IssScratchpad.class, "platform.iss");
        issScratchpad.logContents();
        ApplicationCallbacks callbacks = new ApplicationCallbacks(this.preconsensusEventConsumer, this.snapshotOverrideConsumer, this.staleEventConsumer);
        if (this.model == null) {
            WiringConfig wiringConfig = (WiringConfig)this.platformContext.getConfiguration().getConfigData(WiringConfig.class);
            int coreCount = Runtime.getRuntime().availableProcessors();
            int parallelism = (int)Math.max(1.0, wiringConfig.defaultPoolMultiplier() * (double)coreCount + (double)wiringConfig.defaultPoolConstant());
            ForkJoinPool defaultPool = this.platformContext.getExecutorFactory().createForkJoinPool(parallelism);
            logger.info(LogMarker.STARTUP.getMarker(), "Default platform pool parallelism: {}", (Object)parallelism);
            this.model = WiringModelBuilder.create((Metrics)this.platformContext.getMetrics(), (Time)this.platformContext.getTime()).enableJvmAnchor().withDefaultPool(defaultPool).withWiringConfig(wiringConfig).build();
        }
        if (this.secureRandomSupplier == null) {
            this.secureRandomSupplier = () -> {
                try {
                    return SecureRandom.getInstanceStrong();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        EventPipelineTracker pipelineTracker = (eventPipelineMetricsEnabled = ((PlatformMetricsConfig)this.platformContext.getConfiguration().getConfigData(PlatformMetricsConfig.class)).eventPipelineMetricsEnabled()) ? new EventPipelineTracker(this.platformContext.getMetrics()) : null;
        this.initializeEventCreatorModule();
        this.initializeEventIntakeModule((IntakeEventCounter)intakeEventCounter, pipelineTracker);
        PlatformComponents platformComponentWiring = PlatformComponents.create(this.platformContext, this.model, this.eventCreatorModule, this.eventIntakeModule);
        PlatformWiring.wire(this.platformContext, this.execution, platformComponentWiring, callbacks);
        PlatformWiring.wireMetrics(platformComponentWiring, pipelineTracker);
        PlatformBuildingBlocks buildingBlocks = new PlatformBuildingBlocks(platformComponentWiring, this.platformContext, this.model, this.keysAndCerts, this.selfId, this.appName, this.swirldName, this.softwareVersion, this.initialState, this.rosterHistory, callbacks, this.preconsensusEventConsumer, this.snapshotOverrideConsumer, (IntakeEventCounter)intakeEventCounter, this.secureRandomSupplier, instant -> PlatformStateUtils.isInFreezePeriod(instant, this.stateLifecycleManager.getMutableState()), new AtomicReference<Function<String, ReservedSignedState>>(), initialPcesFiles, this.consensusEventStreamName, issScratchpad, NotificationEngine.buildEngine((ThreadManager)AdHocThreadManager.getStaticThreadManager()), new AtomicReference<StatusActionSubmitter>(), this.stateLifecycleManager, new AtomicReference<Supplier<ReservedSignedState>>(), firstPlatform, this.consensusStateEventHandler, this.execution, new FallenBehindMonitor(this.rosterHistory.getCurrentRoster(), this.configuration, this.platformContext.getMetrics()), (BlockingResourceProvider<ReservedSignedStateResult>)new BlockingResourceProvider());
        return new PlatformComponentBuilder(buildingBlocks);
    }

    @NonNull
    public Platform build() {
        return this.buildComponentBuilder().build();
    }
}

