/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.impl;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.DoubleAccumulator;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import com.swirlds.metrics.impl.AtomicDouble;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;

public class DefaultDoubleAccumulator
extends AbstractMetric
implements DoubleAccumulator {
    @NonNull
    private final AtomicDouble container;
    @NonNull
    private final DoubleBinaryOperator accumulator;
    @NonNull
    private final DoubleSupplier initializer;

    public DefaultDoubleAccumulator(@NonNull DoubleAccumulator.Config config) {
        super((MetricConfig<?, ?>)config);
        double initialValue = config.getInitialValue();
        DoubleSupplier configInitializer = config.getInitializer();
        this.accumulator = config.getAccumulator();
        this.initializer = configInitializer != null ? configInitializer : () -> initialValue;
        this.container = new AtomicDouble(this.initializer.getAsDouble());
    }

    public double getInitialValue() {
        return this.initializer.getAsDouble();
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, (Object)this.container.getAndSet(this.initializer.getAsDouble())));
    }

    public double get() {
        return this.container.get();
    }

    public void update(double other) {
        this.container.accumulateAndGet(other, this.accumulator);
    }

    @Override
    public void reset() {
        this.container.set(this.initializer.getAsDouble());
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.get()).toString();
    }
}

