/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics;

import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.Objects;
import org.hiero.consensus.metrics.PlatformMetricConfig;
import org.hiero.consensus.metrics.PlatformMetricsFactory;

public interface DurationGauge
extends Metric {
    @NonNull
    default public MetricType getMetricType() {
        return MetricType.GAUGE;
    }

    @NonNull
    default public Metric.DataType getDataType() {
        return Metric.DataType.FLOAT;
    }

    @NonNull
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @NonNull
    default public Double get(@NonNull Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType must not be null");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf(valueType));
    }

    public long getNanos();

    public void set(Duration var1);

    public double get();

    public static final class Config
    extends PlatformMetricConfig<DurationGauge, Config> {
        private static final String UNSUPPORTED_TIME_UNIT = "Unsupported time unit: ";
        @NonNull
        private final ChronoUnit timeUnit;

        public Config(@NonNull String category, @NonNull String name, @NonNull ChronoUnit timeUnit) {
            super(category, name, name, Config.getUnit(timeUnit), Config.getFormat(timeUnit));
            this.timeUnit = timeUnit;
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull ChronoUnit timeUnit) {
            super(category, name, description, Config.getUnit(timeUnit), Config.getFormat(timeUnit));
            this.timeUnit = timeUnit;
        }

        @NonNull
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getTimeUnit());
        }

        @NonNull
        public Config withUnit(@NonNull String unit) {
            throw new UnsupportedOperationException("a String unit is not compatible with this class");
        }

        @NonNull
        public ChronoUnit getTimeUnit() {
            return this.timeUnit;
        }

        @NonNull
        public Class<DurationGauge> getResultClass() {
            return DurationGauge.class;
        }

        @Override
        @NonNull
        public DurationGauge create(@NonNull PlatformMetricsFactory factory) {
            return factory.createDurationGauge(this);
        }

        @NonNull
        private static String getFormat(@NonNull ChronoUnit timeUnit) {
            Objects.requireNonNull(timeUnit, "timeUnit must not be null");
            return switch (timeUnit) {
                case ChronoUnit.NANOS, ChronoUnit.MICROS -> "%,.0f";
                case ChronoUnit.MILLIS, ChronoUnit.SECONDS -> "%,.3f";
                default -> throw new IllegalArgumentException(UNSUPPORTED_TIME_UNIT + String.valueOf(timeUnit));
            };
        }

        @NonNull
        private static String getUnit(ChronoUnit timeUnit) {
            Objects.requireNonNull(timeUnit, "timeUnit must not be null");
            return switch (timeUnit) {
                case ChronoUnit.NANOS -> "ns";
                case ChronoUnit.MICROS -> "\u00b5s";
                case ChronoUnit.MILLIS -> "ms";
                case ChronoUnit.SECONDS -> "s";
                default -> throw new IllegalArgumentException(UNSUPPORTED_TIME_UNIT + String.valueOf(timeUnit));
            };
        }
    }
}

