/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.crypto;

import com.google.common.base.MoreObjects;
import com.hedera.node.app.hapi.fees.usage.TxnUsage;
import com.hederahashgraph.api.proto.java.CryptoCreateTransactionBody;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CryptoCreateMeta {
    private final long baseSize;
    private final long lifeTime;
    private final int maxAutomaticAssociations;
    private final long numHooks;

    public CryptoCreateMeta(CryptoCreateTransactionBody cryptoCreateTxnBody) {
        this.baseSize = this.getCryptoCreateTxnBaseSize(cryptoCreateTxnBody);
        this.lifeTime = cryptoCreateTxnBody.getAutoRenewPeriod().getSeconds();
        this.maxAutomaticAssociations = cryptoCreateTxnBody.getMaxAutomaticTokenAssociations();
        this.numHooks = cryptoCreateTxnBody.getHookCreationDetailsCount();
    }

    public CryptoCreateMeta(Builder builder) {
        this.baseSize = builder.baseSize;
        this.lifeTime = builder.lifeTime;
        this.maxAutomaticAssociations = builder.maxAutomaticAssociations;
        this.numHooks = builder.numHooks;
    }

    private long getCryptoCreateTxnBaseSize(CryptoCreateTransactionBody op) {
        long variableBytes = op.getMemoBytes().size();
        variableBytes += TxnUsage.keySizeIfPresent(op, CryptoCreateTransactionBody::hasKey, CryptoCreateTransactionBody::getKey);
        if (op.hasProxyAccountID()) {
            variableBytes += 24L;
        }
        return variableBytes;
    }

    public long getBaseSize() {
        return this.baseSize;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public int getMaxAutomaticAssociations() {
        return this.maxAutomaticAssociations;
    }

    public long getNumHooks() {
        return this.numHooks;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseSize", this.baseSize).add("lifeTime", this.lifeTime).add("maxAutomaticAssociations", this.maxAutomaticAssociations).add("numHooks", this.numHooks).toString();
    }

    public static class Builder {
        private long baseSize;
        private long lifeTime;
        private int maxAutomaticAssociations;
        private long numHooks;

        public Builder baseSize(int baseSize) {
            this.baseSize = baseSize;
            return this;
        }

        public Builder lifeTime(long lifeTime) {
            this.lifeTime = lifeTime;
            return this;
        }

        public Builder maxAutomaticAssociations(int maxAutomaticAssociations) {
            this.maxAutomaticAssociations = maxAutomaticAssociations;
            return this;
        }

        public Builder numHooks(long numHooks) {
            this.numHooks = numHooks;
            return this;
        }

        public CryptoCreateMeta build() {
            return new CryptoCreateMeta(this);
        }
    }
}

