/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.node.internal.network.Network;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.swirlds.base.time.Time;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.io.utility.SimpleRecycleBin;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.LegacyFileConfigSource;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.SavedStateUtils;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.StartupStateUtils;
import com.swirlds.platform.state.snapshot.SavedStateInfo;
import com.swirlds.platform.state.snapshot.SavedStateMetadata;
import com.swirlds.platform.state.snapshot.SignedStateFilePath;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.util.BootstrapUtils;
import com.swirlds.platform.util.HederaUtils;
import com.swirlds.state.StateLifecycleManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.metrics.noop.NoOpMetrics;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.pces.PcesConfig;
import org.hiero.consensus.pcli.AbstractCommand;
import org.hiero.consensus.pcli.Pcli;
import org.hiero.consensus.pcli.SubcommandOf;
import org.hiero.consensus.roster.RosterDiff;
import org.hiero.consensus.roster.RosterUtils;
import picocli.CommandLine;

@CommandLine.Command(name="crystal-transplant", mixinStandardHelpOptions=true, description={"Cast a crystallization spell preparing a node to load a transplanted state"})
@SubcommandOf(value=Pcli.class)
public class CrystalTransplantCommand
extends AbstractCommand {
    private static final int RETURN_CODE_SUCCESS = 0;
    private static final int RETURN_CODE_PROMPT_NO = 1;
    private static final int RETURN_CODE_ERROR = -1;
    private static final String CONFIG_KEY = "hedera.config.version";
    private static final String CONFIG_LOCATION = "data/config";
    private static final String APPLICATION_PROPERTIES_FILE_NAME = "application.properties";
    public static final String OVERRIDE_NETWORK_FILE_NAME = "override-network.json";
    private Path sourceStatePath;
    private NodeId selfId;
    private Path networkOverrideFile;
    @CommandLine.Option(names={"-ac", "--auto-confirm"}, description={"Automatically confirm the operation without prompting"})
    private boolean autoConfirm;
    @CommandLine.Option(names={"-bv", "--bump-version"}, description={"Bump application.properties version up"})
    private boolean bumpVersion = true;
    private PlatformContext platformContext;
    private Roster overrideRoster;
    private Path targetNodePath = Paths.get("", new String[0]);
    private SavedStateMetadata stateMetadata;
    private Path targetStateDir;

    @CommandLine.Option(names={"-s", "--sourceStatePath"}, required=true, description={"The path to the state to load"})
    private void setSourceStatePath(Path sourceStatePath) {
        this.sourceStatePath = this.pathMustExist(sourceStatePath.toAbsolutePath());
    }

    @CommandLine.Option(names={"-t", "--targetNodePath"}, description={"The path to target node directory"})
    private void setTargetNodePath(Path targetNodePath) {
        this.targetNodePath = this.pathMustExist(targetNodePath.toAbsolutePath());
    }

    @CommandLine.Option(names={"-o", "--networkOverride"}, description={"The path to the network override file"})
    private void setNetworkOverrideFile(Path networkOverrideFile) {
        this.networkOverrideFile = this.pathMustExist(networkOverrideFile.toAbsolutePath());
    }

    @CommandLine.Option(names={"-i", "--selfId"}, required=true, description={"The ID of the target node"})
    private void setSelfId(long selfId) {
        this.selfId = NodeId.of((long)selfId);
    }

    @Override
    public Integer call() throws IOException {
        Path settingsTxtFile;
        this.requestConfirmation(String.format("Start migration process for selfId:%s using networkOverride:%s sourceStatePath:%s and targetNodePath:%s bumpVersion:%s", this.selfId, this.networkOverrideFile != null ? this.networkOverrideFile.toAbsolutePath() : "<NONE>", this.sourceStatePath.toAbsolutePath(), this.targetNodePath.toAbsolutePath(), this.bumpVersion));
        Path configtxtFile = this.targetNodePath.resolve("config.txt");
        if (!Files.exists(configtxtFile, new LinkOption[0])) {
            System.err.println("Could not find config file: " + String.valueOf(configtxtFile));
        }
        if (!Files.exists(settingsTxtFile = this.targetNodePath.resolve(CONFIG_LOCATION).resolve("settings.txt"), new LinkOption[0])) {
            System.err.println("Could not find config file: " + String.valueOf(settingsTxtFile));
            System.exit(-1);
        }
        Configuration configuration = ConfigurationBuilder.create().withSource((ConfigSource)new LegacyFileConfigSource(configtxtFile)).withSource((ConfigSource)new LegacyFileConfigSource(settingsTxtFile)).autoDiscoverExtensions().build();
        this.platformContext = PlatformContext.create((Configuration)configuration, (Time)Time.getCurrent(), (Metrics)new NoOpMetrics(), (FileSystemManager)FileSystemManager.create((Configuration)configuration), (RecycleBin)new SimpleRecycleBin());
        PcesConfig pcesConfig = (PcesConfig)configuration.getConfigData(PcesConfig.class);
        StateInformation sourceStateInfo = this.loadSourceState(configuration);
        if (this.networkOverrideFile != null) {
            this.validateOverrideNetworkJson();
            this.printRosterDiffAndGetConfirmation(sourceStateInfo);
            this.copyNetworkOverrideFileToCorrectDirectory();
        }
        this.copyStateFilesToCorrectDirectory(sourceStateInfo.fileInfo().stateDirectory());
        this.truncatePCESFilesIfNotAFreezeState();
        Path sourcePcesDir = this.targetStateDir.resolve(pcesConfig.databaseDirectory());
        Path targetPcesDir = this.targetNodePath.resolve(((StateCommonConfig)configuration.getConfigData(StateCommonConfig.class)).savedStateDirectory()).resolve(pcesConfig.databaseDirectory()).resolve(Long.toString(this.selfId.id()));
        this.copyPCESFilesToCorrectDirectory(sourcePcesDir, targetPcesDir);
        this.performConfigBump();
        return 0;
    }

    private void validateOverrideNetworkJson() {
        Roster roster = CrystalTransplantCommand.loadRosterFrom(this.networkOverrideFile);
        if (roster == null) {
            System.out.printf("Unable to load network override file %s%n", this.networkOverrideFile);
        }
        this.overrideRoster = roster;
    }

    private StateInformation loadSourceState(Configuration configuration) {
        BootstrapUtils.setupConstructableRegistry();
        SwirldMain appMain = HederaUtils.createHederaAppMain((PlatformContext)this.platformContext);
        List savedStateFiles = SignedStateFilePath.getSavedStateFiles((Path)this.sourceStatePath);
        if (savedStateFiles.isEmpty()) {
            System.out.printf("No state files found on %s %n", this.sourceStatePath);
            System.exit(-1);
        }
        try (ReservedSignedState state = StartupStateUtils.loadLatestState((RecycleBin)new SimpleRecycleBin(), (SemanticVersion)appMain.getSemanticVersion(), (List)savedStateFiles, (PlatformContext)this.platformContext, (StateLifecycleManager)appMain.getStateLifecycleManager());){
            Hash newHash = state.get().getState().getHash();
            StateCommonConfig stateConfig = (StateCommonConfig)configuration.getConfigData(StateCommonConfig.class);
            this.targetStateDir = new SignedStateFilePath(new StateCommonConfig(this.targetNodePath.resolve(stateConfig.savedStateDirectory()))).getSignedStateDirectory(configuration.getValue("state.mainClassNameOverride"), this.selfId, "123", state.get().getRound());
            StateInformation stateInformation = new StateInformation(state.get().getRound(), state.get().getRoster(), newHash, (SavedStateInfo)savedStateFiles.getFirst());
            return stateInformation;
        }
    }

    private void printRosterDiffAndGetConfirmation(StateInformation sourceStateInfo) {
        System.out.println(RosterDiff.report((Roster)sourceStateInfo.roster, (Roster)this.overrideRoster).print());
        this.requestConfirmation(String.format("The state trying to migrate is on round: %d and has hash: %s", sourceStateInfo.round, sourceStateInfo.hash));
    }

    private void copyNetworkOverrideFileToCorrectDirectory() {
        Path networkOverrideFile = this.targetNodePath.resolve(CONFIG_LOCATION).resolve(OVERRIDE_NETWORK_FILE_NAME);
        this.requestConfirmation("Copy network override file to location: " + String.valueOf(networkOverrideFile));
        try {
            if (!networkOverrideFile.toFile().exists()) {
                Files.createDirectories(networkOverrideFile, new FileAttribute[0]);
            }
            Files.copy(this.networkOverrideFile, networkOverrideFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            System.err.printf("Unable to copy network override file for self-id %s. %s %n", this.selfId, e);
            System.exit(-1);
        }
    }

    private void copyStateFilesToCorrectDirectory(Path sourceDir) {
        this.requestConfirmation(String.format("Copy state files from source dir: %s to target: %s", sourceDir, this.targetStateDir));
        PcesConfig pcesConfig = (PcesConfig)this.platformContext.getConfiguration().getConfigData(PcesConfig.class);
        try {
            FileUtils.deleteDirectory((Path)this.targetStateDir.getParent());
            FileUtils.copyDirectory((Path)sourceDir, (Path)this.targetStateDir);
            try (Stream<Path> stream = Files.list(this.targetStateDir.resolve(pcesConfig.databaseDirectory()));){
                ArrayList list = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toCollection(ArrayList::new));
                Path any = list.stream().filter(file -> file.getFileName().toFile().getName().equals(this.selfId.toString())).findAny().orElse((Path)list.getFirst());
                list.remove(any);
                list.forEach(f -> {
                    try {
                        FileUtils.deleteDirectory((Path)f);
                    }
                    catch (IOException e) {
                        System.exit(-1);
                    }
                });
                if (!any.getFileName().toFile().getName().equals(this.selfId.toString())) {
                    FileUtils.rename((Path)any, (String)this.selfId.toString());
                }
            }
        }
        catch (IOException e) {
            System.err.printf("Unable to move state files from:%s to:%s. %s %n", sourceDir, this.targetStateDir, e);
            System.exit(-1);
        }
    }

    private void truncatePCESFilesIfNotAFreezeState() throws IOException {
        this.stateMetadata = SavedStateMetadata.parse((Path)this.targetStateDir.resolve("stateMetadata.txt"));
        if (this.stateMetadata.freezeState() == null || !this.stateMetadata.freezeState().booleanValue()) {
            this.requestConfirmation("Truncate PCES files");
            int discardedEventCount = SavedStateUtils.prepareStateForTransplant((Path)this.targetStateDir, (PlatformContext)this.platformContext);
            System.out.printf("PCES file truncation complete. %d events were discarded due to being from a future round.%n", discardedEventCount);
        } else {
            System.out.printf("The state is a freeze state, no truncation is needed.%n", new Object[0]);
        }
    }

    private void copyPCESFilesToCorrectDirectory(Path sourcePcesDir, Path targetPcesDir) {
        this.requestConfirmation("Copy PCES files to correct directory");
        try {
            FileUtils.deleteDirectory((Path)targetPcesDir);
            FileUtils.copyDirectory((Path)sourcePcesDir, (Path)targetPcesDir);
        }
        catch (IOException e) {
            System.err.printf("Unable to move PCES files from:%s to:%s. %s %n", sourcePcesDir, targetPcesDir, e);
            System.exit(1);
        }
    }

    private void performConfigBump() throws IOException {
        if (!this.bumpVersion) {
            return;
        }
        this.requestConfirmation("Perform config bumping");
        Path propertiesPath = this.targetNodePath.resolve(CONFIG_LOCATION).resolve(APPLICATION_PROPERTIES_FILE_NAME);
        if (Files.notExists(propertiesPath, new LinkOption[0])) {
            Files.createFile(propertiesPath, new FileAttribute[0]);
        }
        List<String> lines = Files.readAllLines(propertiesPath, StandardCharsets.UTF_8);
        boolean updated = false;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (CrystalTransplantCommand.isComment(line) || !line.startsWith(CONFIG_KEY)) continue;
            String originalValue = line.replace(CONFIG_KEY, "").replace("=", "").trim();
            long parsed = Long.getLong(originalValue);
            long bumped = parsed + 1L;
            String newLine = "hedera.config.version=" + bumped;
            lines.set(i, newLine);
            updated = true;
            break;
        }
        if (!updated) {
            lines.add(String.format("%s=%s", CONFIG_KEY, 1));
        }
        Files.write(propertiesPath, lines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private void requestConfirmation(String message) {
        System.out.println(message);
        if (!this.autoConfirm) {
            Console console = System.console();
            String keepGoing = "";
            while (Objects.equals(keepGoing, "")) {
                if (console != null) {
                    keepGoing = console.readLine("Continue? [Y/N]:", new Object[0]);
                    continue;
                }
                System.out.println("Continue? [Y/N]:");
                System.out.flush();
                keepGoing = new Scanner(System.in).nextLine();
            }
            if (!keepGoing.equalsIgnoreCase("Y")) {
                System.exit(1);
            }
            System.out.println();
        }
    }

    private static boolean isComment(@NonNull String line) {
        String trimmed = line.stripLeading();
        return trimmed.startsWith("#") || trimmed.startsWith("!");
    }

    public static Roster loadRosterFrom(@NonNull Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            Roster roster;
            block9: {
                InputStream fin = Files.newInputStream(path, new OpenOption[0]);
                try {
                    Network network = (Network)Network.JSON.parse((ReadableSequentialData)new ReadableStreamingData(fin));
                    roster = RosterUtils.rosterFrom((Network)network);
                    if (fin == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        System.err.printf("Failed to load %s network info from %s%n", path.toAbsolutePath(), e);
                    }
                }
                fin.close();
            }
            return roster;
        }
        return null;
    }

    record StateInformation(Long round, Roster roster, Hash hash, SavedStateInfo fileInfo) {
    }
}

