/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.buffers;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.FixedBufferData;

final class BufferUtil {
    static final BufferData EMPTY_BUFFER = new FixedBufferData(0);
    private static final String ZEROES = "00000000";
    private static final String BINARY_LINE = "+--------+----------+\n";
    private static final String BINARY_HEADER = "+--------+----------+\n|  index | 01234567 |\n+--------+----------+\n";
    private static final String HEX_LINE = "+--------+-------------------------------------------------+----------------+\n";
    private static final String HEX_HEADER = "+--------+-------------------------------------------------+----------------+\n|   index|  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |            data|\n+--------+-------------------------------------------------+----------------+\n";

    private BufferUtil() {
    }

    static String toBinaryString(int value) {
        String binary = Integer.toBinaryString(value);
        return ZEROES.substring(binary.length()) + binary;
    }

    static String debugDataBinary(byte[] bytes, int position, int length) {
        StringBuilder stringBuilder = new StringBuilder(BINARY_LINE.length() * length + BINARY_LINE.length() + BINARY_HEADER.length());
        stringBuilder.append(BINARY_HEADER);
        int counter = 0;
        for (int i = position; i < length; ++i) {
            byte toPrint = bytes[i];
            stringBuilder.append("|").append(BufferUtil.toIndexString(counter)).append("| ").append(BufferUtil.toBinaryString(toPrint & 0xFF)).append(" |\n");
            ++counter;
        }
        stringBuilder.append(BINARY_LINE);
        return stringBuilder.toString();
    }

    static String debugDataHex(byte[] bytes, int position, int length) {
        StringBuilder stringBuilder = new StringBuilder(HEX_LINE.length() * (length / 16) + 1 + HEX_LINE.length() + HEX_LINE.length());
        stringBuilder.append(HEX_HEADER);
        StringBuilder line = new StringBuilder(16);
        int counter = 0;
        for (int i = position; i < length; ++i) {
            if (counter % 16 == 0) {
                line.setLength(0);
                stringBuilder.append("|").append(BufferUtil.toIndexString(counter)).append("| ");
            }
            byte toPrint = bytes[i];
            int toPrintInt = toPrint & 0xFF;
            Object hex = Integer.toHexString(toPrintInt);
            hex = ZEROES.substring(((String)hex).length() + 6) + (String)hex;
            stringBuilder.append((String)hex).append(" ");
            BufferUtil.appendChar(line, toPrintInt);
            if (++counter % 16 != 0) continue;
            stringBuilder.append("|");
            stringBuilder.append((CharSequence)line);
            stringBuilder.append("|\n");
        }
        int missing = 16 - counter % 16;
        if (counter != 0 && missing != 16) {
            stringBuilder.append("   ".repeat(missing));
            line.append(" ".repeat(missing));
            stringBuilder.append("|");
            stringBuilder.append((CharSequence)line);
            stringBuilder.append("|\n");
        }
        stringBuilder.append(HEX_LINE);
        return stringBuilder.toString();
    }

    private static String toIndexString(int index) {
        String positionString = Integer.toHexString(index);
        int len = positionString.length();
        if (len >= 8) {
            return positionString;
        }
        return ZEROES.substring(len) + positionString;
    }

    private static void appendChar(StringBuilder line, int codePoint) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
        if (!Character.isISOControl(codePoint) && block != null && block != Character.UnicodeBlock.SPECIALS) {
            line.append((char)codePoint);
        } else {
            line.append('.');
        }
    }
}

