/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.contract.ContractGetBytecodeQuery;
import com.hedera.hapi.node.state.contract.Bytecode;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.spi.fees.QueryFeeCalculator;
import com.hedera.node.app.spi.workflows.QueryContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class ContractGetByteCodeFeeCalculator
implements QueryFeeCalculator {
    public void accumulateNodePayment(@NonNull Query query, @Nullable QueryContext queryContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        Objects.requireNonNull(queryContext);
        ContractStateStore contractStore = (ContractStateStore)queryContext.createStore(ContractStateStore.class);
        ContractGetBytecodeQuery op = query.contractGetBytecodeOrThrow();
        ServiceFeeDefinition serviceDef = Objects.requireNonNull(FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CONTRACT_GET_BYTECODE));
        Bytecode bytecode = contractStore.getBytecode(op.contractIDOrThrow());
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        this.addExtraFee(feeResult, serviceDef, Extra.BYTES, feeSchedule, bytecode.code().length());
    }

    public Query.QueryOneOfType getQueryType() {
        return Query.QueryOneOfType.CONTRACT_GET_BYTECODE;
    }
}

