/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.List;
import org.hiero.consensus.roster.InvalidRosterException;

public final class RosterValidator {
    private RosterValidator() {
    }

    public static void validate(@NonNull Roster roster) {
        if (roster == null) {
            throw new InvalidRosterException("roster is null");
        }
        List rosterEntries = roster.rosterEntries();
        if (rosterEntries.isEmpty()) {
            throw new InvalidRosterException("roster is empty");
        }
        if (rosterEntries.stream().noneMatch(re -> re.weight() > 0L)) {
            throw new InvalidRosterException("roster weight is zero or negative");
        }
        HashSet<Long> seenNodeIds = new HashSet<Long>();
        long lastSeenNodeId = 0L;
        for (RosterEntry re2 : rosterEntries) {
            if (seenNodeIds.contains(re2.nodeId())) {
                throw new InvalidRosterException("duplicate node id: " + re2.nodeId());
            }
            seenNodeIds.add(re2.nodeId());
            if (re2.nodeId() < lastSeenNodeId) {
                throw new InvalidRosterException("RosterEntries sort order is invalid. Found node id: " + re2.nodeId() + " following " + lastSeenNodeId);
            }
            lastSeenNodeId = re2.nodeId();
            if (re2.weight() < 0L) {
                throw new InvalidRosterException("weight is negative for node id: " + re2.nodeId());
            }
            if (re2.gossipCaCertificate().length() == 0L) {
                throw new InvalidRosterException("gossipCaCertificate is empty for NodeId " + re2.nodeId());
            }
            if (re2.gossipEndpoint().isEmpty()) {
                throw new InvalidRosterException("gossipEndpoint is empty for NodeId " + re2.nodeId());
            }
            for (ServiceEndpoint se : re2.gossipEndpoint()) {
                if (se.port() == 0) {
                    throw new InvalidRosterException("gossipPort is zero for NodeId " + re2.nodeId() + " and ServiceEndpoint " + String.valueOf(se));
                }
                if (!(se.domainName().isEmpty() ^ se.ipAddressV4().length() == 0L)) {
                    throw new InvalidRosterException("ServiceEndpoint must specify either a domainName or an ipAddressV4, but not both. For NodeId " + re2.nodeId() + " found ServiceEndpoint " + String.valueOf(se));
                }
                if (se.ipAddressV4().length() == 0L || se.ipAddressV4().length() == 4L) continue;
                throw new InvalidRosterException("ServiceEndpoint ipAddressV4 must have a length of 4 bytes, found " + se.ipAddressV4().length() + " bytes for nodeId " + re2.nodeId());
            }
        }
    }
}

