/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.sources;

import com.swirlds.config.api.source.ConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;

public class PropertyConfigSource
implements ConfigSource {
    private final Properties properties;
    private final int ordinal;

    public PropertyConfigSource(@NonNull Properties properties, int ordinal) {
        Objects.requireNonNull(properties, "properties must not be null");
        this.properties = new Properties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.properties.put(key.toString(), value.toString())));
        this.ordinal = ordinal;
    }

    public PropertyConfigSource(@NonNull String resourceName, int ordinal) {
        this(PropertyConfigSource.loadProperties(resourceName), ordinal);
    }

    public PropertyConfigSource(@NonNull Properties properties) {
        this(properties, 100);
    }

    private static Properties loadProperties(@NonNull String resourceName) {
        Properties properties;
        block9: {
            Objects.requireNonNull(resourceName, "resourceName must not be null");
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            try {
                if (in == null) {
                    throw new UncheckedIOException("Property file " + resourceName + " could not be found", new IOException());
                }
                Properties props = new Properties();
                props.load(in);
                properties = props;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to load resource " + resourceName + " as property file", e);
                }
            }
            in.close();
        }
        return properties;
    }

    @NonNull
    public Set<String> getPropertyNames() {
        return this.properties.stringPropertyNames();
    }

    @Nullable
    public String getValue(@NonNull String key) throws NoSuchElementException {
        Objects.requireNonNull(key, "key must not be null");
        return this.properties.getProperty(key);
    }

    public boolean isListProperty(@NonNull String propertyName) throws NoSuchElementException {
        return false;
    }

    @NonNull
    public List<String> getListValue(@NonNull String propertyName) throws NoSuchElementException {
        return List.of();
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

