/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.platform.prometheus;

import com.sun.net.httpserver.HttpServer;
import com.swirlds.base.utility.AutoCloseableNonThrowing;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.snapshot.Snapshot;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.ThresholdLimitingHandler;
import org.hiero.consensus.metrics.FunctionGauge;
import org.hiero.consensus.metrics.IntegerPairAccumulator;
import org.hiero.consensus.metrics.RunningAverageMetric;
import org.hiero.consensus.metrics.SpeedometerMetric;
import org.hiero.consensus.metrics.StatEntry;
import org.hiero.consensus.metrics.platform.DefaultPlatformMetrics;
import org.hiero.consensus.metrics.platform.MetricsEvent;
import org.hiero.consensus.metrics.platform.SnapshotEvent;
import org.hiero.consensus.metrics.platform.prometheus.BooleanAdapter;
import org.hiero.consensus.metrics.platform.prometheus.CounterAdapter;
import org.hiero.consensus.metrics.platform.prometheus.DistributionAdapter;
import org.hiero.consensus.metrics.platform.prometheus.MetricAdapter;
import org.hiero.consensus.metrics.platform.prometheus.NumberAdapter;
import org.hiero.consensus.metrics.platform.prometheus.StringAdapter;
import org.hiero.consensus.model.node.NodeId;

public class PrometheusEndpoint
implements AutoCloseableNonThrowing {
    private static final Logger logger = LogManager.getLogger(PrometheusEndpoint.class);
    public static final String NODE_LABEL = "node";
    public static final String TYPE_LABEL = "type";
    private static final String TIME_METRIC_KEY = DefaultPlatformMetrics.calculateMetricKey("platform:info", "time");
    private final CollectorRegistry registry;
    private final Map<String, MetricAdapter> adapters = new ConcurrentHashMap<String, MetricAdapter>();
    private final HTTPServer httpServer;
    private final ThresholdLimitingHandler<Throwable> exceptionRateLimiter = new ThresholdLimitingHandler(10L);

    public PrometheusEndpoint(HttpServer httpServer) throws IOException {
        this(httpServer, new CollectorRegistry(false));
    }

    @Deprecated(forRemoval=true)
    public PrometheusEndpoint(HttpServer httpServer, CollectorRegistry registry) throws IOException {
        Objects.requireNonNull(httpServer, "httpServer must not be null");
        this.registry = Objects.requireNonNull(registry, "registry must not be null");
        logger.info(LogMarker.STARTUP.getMarker(), "PrometheusEndpoint: Starting server listing on port: {}", (Object)httpServer.getAddress().getPort());
        this.httpServer = new HTTPServer.Builder().withHttpServer(httpServer).withRegistry(registry).build();
    }

    public void handleMetricsChange(MetricsEvent notification) {
        Objects.requireNonNull(notification, "notification must not be null");
        Metric metric = notification.metric();
        String metricKey = DefaultPlatformMetrics.calculateMetricKey(metric);
        if (TIME_METRIC_KEY.equals(metricKey)) {
            return;
        }
        if (notification.type() == MetricsEvent.Type.ADDED) {
            this.adapters.computeIfAbsent(metricKey, key -> this.doCreate(notification.nodeId(), metric)).incAndGetReferenceCount();
        } else {
            MetricAdapter adapter = this.adapters.get(metricKey);
            if (adapter != null && adapter.decAndGetReferenceCount() == 0) {
                adapter.unregister(this.registry);
                this.adapters.remove(metricKey);
            }
        }
    }

    public void handleSnapshots(SnapshotEvent notification) {
        Objects.requireNonNull(notification, "notification must not be null");
        for (Snapshot snapshot : notification.snapshots()) {
            String metricKey = DefaultPlatformMetrics.calculateMetricKey(snapshot.metric());
            MetricAdapter adapter = this.adapters.get(metricKey);
            if (adapter == null) continue;
            try {
                adapter.update(snapshot, notification.nodeId());
            }
            catch (RuntimeException ex) {
                this.exceptionRateLimiter.handle((Object)ex, error -> logger.error(LogMarker.EXCEPTION.getMarker(), "Exception while trying to update Prometheus endpoint with snapshot {}", (Object)snapshot, (Object)ex));
            }
        }
    }

    private MetricAdapter doCreate(NodeId nodeId, Metric metric) {
        AdapterType adapterType;
        AdapterType adapterType2 = adapterType = nodeId == null ? AdapterType.GLOBAL : AdapterType.PLATFORM;
        if (metric instanceof Counter) {
            return new CounterAdapter(this.registry, metric, adapterType);
        }
        if (metric instanceof RunningAverageMetric || metric instanceof SpeedometerMetric) {
            return new DistributionAdapter(this.registry, metric, adapterType);
        }
        if (metric instanceof IntegerPairAccumulator || metric instanceof FunctionGauge || metric instanceof StatEntry) {
            return switch (metric.getDataType()) {
                case Metric.DataType.STRING -> new StringAdapter(this.registry, metric, adapterType);
                case Metric.DataType.BOOLEAN -> new BooleanAdapter(this.registry, metric, adapterType);
                default -> new NumberAdapter(this.registry, metric, adapterType);
            };
        }
        return new NumberAdapter(this.registry, metric, adapterType);
    }

    public void close() {
        this.httpServer.close();
    }

    public static enum AdapterType {
        GLOBAL,
        PLATFORM;

    }
}

