/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.FractionalFee;
import com.hedera.hapi.node.transaction.RoyaltyFee;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.AccountsConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class CustomFeesValidator {
    public static final TokenID SENTINEL_TOKEN_ID = TokenID.newBuilder().shardNum(0L).realmNum(0L).tokenNum(0L).build();
    private final EntityIdFactory entityIdFactory;
    private final Configuration configuration;

    @Inject
    public CustomFeesValidator(EntityIdFactory entityIdFactory, ConfigProvider configProvider) {
        this.entityIdFactory = entityIdFactory;
        this.configuration = configProvider.getConfiguration();
    }

    public List<CustomFee> validateForCreation(@NonNull Token createdToken, @NonNull ReadableAccountStore accountStore, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull WritableTokenStore tokenStore, @NonNull List<CustomFee> customFees, @NonNull ExpiryValidator expiryValidator) {
        Objects.requireNonNull(createdToken);
        Objects.requireNonNull(accountStore);
        Objects.requireNonNull(tokenRelationStore);
        Objects.requireNonNull(tokenStore);
        Objects.requireNonNull(customFees);
        Objects.requireNonNull(expiryValidator);
        ArrayList<CustomFee> fees = new ArrayList<CustomFee>();
        TokenType tokenType = createdToken.tokenType();
        TokenID createdTokenId = createdToken.tokenId();
        AccountID feeCollectionAccount = this.entityIdFactory.newAccountId(((AccountsConfig)this.configuration.getConfigData(AccountsConfig.class)).feeCollectionAccount());
        block5: for (CustomFee fee : customFees) {
            AccountID collectorId = fee.feeCollectorAccountIdOrElse(AccountID.DEFAULT);
            HandleException.validateTrue((!collectorId.equals((Object)feeCollectionAccount) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR);
            TokenHandlerHelper.getIfUsable(collectorId, accountStore, expiryValidator, ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR, ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR, TokenHandlerHelper.AccountIDType.NOT_ALIASED_ID);
            boolean isSpecified = fee.hasFixedFee() || fee.hasFractionalFee() || fee.hasRoyaltyFee();
            HandleException.validateTrue((boolean)isSpecified, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_NOT_FULLY_SPECIFIED);
            switch ((CustomFee.FeeOneOfType)fee.fee().kind()) {
                case FIXED_FEE: {
                    this.validateFixedFeeForCreation(tokenType, fee, createdTokenId, tokenRelationStore, tokenStore, fees);
                    continue block5;
                }
                case FRACTIONAL_FEE: {
                    this.validateFractionalFeeForCreation(tokenType, fee, fees);
                    continue block5;
                }
                case ROYALTY_FEE: {
                    this.validateRoyaltyFee(tokenType, fee, tokenRelationStore, tokenStore);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unexpected value for custom fee type: " + String.valueOf(fee.fee().kind()));
        }
        return fees;
    }

    public void validateForFeeScheduleUpdate(@NonNull Token token, @NonNull ReadableAccountStore accountStore, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull WritableTokenStore tokenStore, @NonNull List<CustomFee> customFees, @NonNull ExpiryValidator expiryValidator) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(accountStore);
        Objects.requireNonNull(tokenRelationStore);
        Objects.requireNonNull(tokenStore);
        Objects.requireNonNull(customFees);
        TokenType tokenType = token.tokenType();
        AccountID feeCollectionAccount = this.entityIdFactory.newAccountId(((AccountsConfig)this.configuration.getConfigData(AccountsConfig.class)).feeCollectionAccount());
        block5: for (CustomFee fee : customFees) {
            AccountID collectorId = fee.feeCollectorAccountIdOrElse(AccountID.DEFAULT);
            HandleException.validateTrue((!collectorId.equals((Object)feeCollectionAccount) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR);
            TokenHandlerHelper.getIfUsable(collectorId, accountStore, expiryValidator, ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR, ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR, TokenHandlerHelper.AccountIDType.NOT_ALIASED_ID);
            switch ((CustomFee.FeeOneOfType)fee.fee().kind()) {
                case FIXED_FEE: {
                    FixedFee fixedFee = fee.fixedFeeOrThrow();
                    long fixedFeeAmount = fee.fixedFee().amount();
                    HandleException.validateTrue((fixedFeeAmount > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE);
                    if (!fixedFee.hasDenominatingTokenId()) continue block5;
                    this.validateExplicitTokenDenomination(collectorId, fixedFee.denominatingTokenId(), tokenRelationStore, tokenStore);
                    break;
                }
                case FRACTIONAL_FEE: {
                    this.validateFractionalFeeForFeeScheduleUpdate(token, tokenRelationStore, collectorId, fee);
                    break;
                }
                case ROYALTY_FEE: {
                    this.validateRoyaltyFee(tokenType, fee, tokenRelationStore, tokenStore);
                    break;
                }
                default: {
                    throw new HandleException(ResponseCodeEnum.CUSTOM_FEE_NOT_FULLY_SPECIFIED);
                }
            }
        }
    }

    private void validateExplicitTokenDenomination(@NonNull AccountID feeCollectorNum, @NonNull TokenID tokenNum, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull WritableTokenStore tokenStore) {
        Token denomToken = TokenHandlerHelper.getIfUsable(tokenNum, tokenStore, TokenHandlerHelper.TokenValidations.REQUIRE_NOT_PAUSED, ResponseCodeEnum.INVALID_TOKEN_ID_IN_CUSTOM_FEES);
        HandleException.validateTrue((boolean)this.isFungibleCommon(denomToken.tokenType()), (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON);
        HandleException.validateTrue((tokenRelationStore.get(feeCollectorNum, tokenNum) != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR);
    }

    private boolean isFungibleCommon(@NonNull TokenType tokenType) {
        return tokenType.equals((Object)TokenType.FUNGIBLE_COMMON);
    }

    private boolean isNonFungibleUnique(@NonNull TokenType tokenType) {
        return tokenType.equals((Object)TokenType.NON_FUNGIBLE_UNIQUE);
    }

    private void validateFixedFeeForCreation(@NonNull TokenType tokenType, @NonNull CustomFee fee, @NonNull TokenID createdTokenId, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull WritableTokenStore tokenStore, @NonNull List<CustomFee> feesWithCollectorsToAutoAssociate) {
        FixedFee fixedFee = fee.fixedFeeOrThrow();
        HandleException.validateTrue((fixedFee.amount() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE);
        if (fixedFee.hasDenominatingTokenId()) {
            if (fixedFee.denominatingTokenIdOrThrow().equals((Object)SENTINEL_TOKEN_ID)) {
                HandleException.validateTrue((boolean)this.isFungibleCommon(tokenType), (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON);
                CustomFee.Builder copy = fee.copyBuilder();
                FixedFee.Builder fixedFeeCopy = fixedFee.copyBuilder();
                copy.fixedFee(fixedFeeCopy.denominatingTokenId(createdTokenId).build());
                feesWithCollectorsToAutoAssociate.add(copy.build());
            } else {
                this.validateExplicitTokenDenomination(fee.feeCollectorAccountId(), fixedFee.denominatingTokenId(), tokenRelationStore, tokenStore);
            }
        }
    }

    private void validateFractionalFeeForCreation(TokenType tokenType, CustomFee fee, List<CustomFee> fees) {
        HandleException.validateTrue((boolean)this.isFungibleCommon(tokenType), (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON);
        this.validateFractionalFee(fee);
        fees.add(fee);
    }

    private void validateRoyaltyFee(@NonNull TokenType tokenType, @NonNull CustomFee fee, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull WritableTokenStore tokenStore) {
        HandleException.validateTrue((boolean)this.isNonFungibleUnique(tokenType), (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE);
        RoyaltyFee royaltyFee = fee.royaltyFeeOrThrow();
        long numerator = royaltyFee.exchangeValueFraction().numerator();
        long denominator = royaltyFee.exchangeValueFraction().denominator();
        HandleException.validateTrue((denominator != 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FRACTION_DIVIDES_BY_ZERO);
        HandleException.validateTrue((numerator > 0L && denominator > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE);
        HandleException.validateTrue((numerator <= denominator ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ROYALTY_FRACTION_CANNOT_EXCEED_ONE);
        if (royaltyFee.hasFallbackFee()) {
            HandleException.validateTrue((royaltyFee.fallbackFee().amount() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE);
            FixedFee fallbackFee = royaltyFee.fallbackFeeOrThrow();
            if (fallbackFee.hasDenominatingTokenId()) {
                TokenID denominatingTokenId = fallbackFee.denominatingTokenIdOrThrow();
                HandleException.validateTrue((denominatingTokenId.tokenNum() != 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON);
                this.validateExplicitTokenDenomination(fee.feeCollectorAccountId(), denominatingTokenId, tokenRelationStore, tokenStore);
            }
        }
    }

    private void validateFractionalFeeForFeeScheduleUpdate(@NonNull Token token, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull AccountID collectorId, @NonNull CustomFee fee) {
        TokenType tokenType = token.tokenType();
        HandleException.validateTrue((boolean)this.isFungibleCommon(tokenType), (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON);
        TokenID tokenId = token.tokenId();
        TokenRelation relation = tokenRelationStore.get(collectorId, tokenId);
        HandleException.validateTrue((relation != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR);
        this.validateFractionalFee(fee);
    }

    private void validateFractionalFee(@NonNull CustomFee fee) {
        FractionalFee fractionalFee = fee.fractionalFee();
        long numerator = fractionalFee.fractionalAmount().numerator();
        long denominator = fractionalFee.fractionalAmount().denominator();
        long minimumUnitsToCollect = fractionalFee.minimumAmount();
        long nominalMax = fractionalFee.maximumAmount();
        long maximumUnitsToCollect = nominalMax == 0L ? Long.MAX_VALUE : nominalMax;
        HandleException.validateTrue((denominator != 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FRACTION_DIVIDES_BY_ZERO);
        HandleException.validateTrue((numerator > 0L && denominator > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE);
        HandleException.validateTrue((minimumUnitsToCollect >= 0L && maximumUnitsToCollect >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE);
        HandleException.validateTrue((maximumUnitsToCollect >= minimumUnitsToCollect ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT);
    }
}

