/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.node.app.blocks.StreamingTreeHasher;
import com.hedera.node.app.spi.records.BlockRecordInfo;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.platform.system.state.notifications.StateHashedListener;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Function;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.hashgraph.Round;

public interface BlockStreamManager
extends BlockRecordInfo,
StateHashedListener {
    public static final Bytes ZERO_BLOCK_HASH = Bytes.wrap((byte[])new byte[StreamingTreeHasher.HASH_LENGTH]);
    public static final int NUM_SIBLINGS_PER_BLOCK = 3;

    public boolean hasLedgerId();

    public void init(@NonNull State var1, @Nullable Bytes var2);

    public void startRound(@NonNull Round var1, @NonNull MerkleNodeState var2);

    public void confirmPendingWorkFinished();

    @NonNull
    public PendingWork pendingWork();

    public void setLastIntervalProcessTime(@NonNull Instant var1);

    @NonNull
    public Instant lastIntervalProcessTime();

    public void setLastTopLevelTime(@NonNull Instant var1);

    @NonNull
    public Instant lastTopLevelConsensusTime();

    @NonNull
    public Instant lastUsedConsensusTime();

    public boolean endRound(@NonNull MerkleNodeState var1, long var2);

    public void writeItem(@NonNull BlockItem var1);

    public void writeItem(@NonNull Function<Timestamp, BlockItem> var1);

    public void notifyFatalEvent();

    public void awaitFatalShutdown(@NonNull Duration var1);

    public void trackEventHash(@NonNull Hash var1);

    public Optional<Integer> getEventIndex(@NonNull Hash var1);

    public static interface Lifecycle {
        public void onOpenBlock(@NonNull State var1);

        public void onCloseBlock(@NonNull State var1);
    }

    public static enum PendingWork {
        NONE,
        GENESIS_WORK,
        POST_UPGRADE_WORK;

    }
}

