/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.roster.RosterUtils;

public interface ReadableRosterStore {
    @Nullable
    public Roster getCandidateRoster();

    @Nullable
    public Roster getActiveRoster();

    default public boolean candidateIsWeightRotation() {
        Roster candidateRoster = this.getCandidateRoster();
        if (candidateRoster == null) {
            return false;
        }
        return RosterUtils.isWeightRotation(Objects.requireNonNull(this.getActiveRoster()), candidateRoster);
    }

    @Nullable
    public Roster get(@NonNull Bytes var1);

    @NonNull
    public List<RoundRosterPair> getRosterHistory();

    @Nullable
    public Bytes getCurrentRosterHash();

    @Nullable
    public Bytes getPreviousRosterHash();

    @Nullable
    public Bytes getCandidateRosterHash();

    public boolean isTransplantInProgress();
}

