/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.GenericType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.mapper.Mappers;
import io.helidon.common.mapper.MappersConfigBlueprint;
import io.helidon.common.mapper.MappersConfigSupport;
import io.helidon.common.mapper.spi.MapperProvider;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.RegistryBuilderSupport;
import io.helidon.service.registry.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.mapper.MappersConfigBlueprint")
public interface MappersConfig
extends MappersConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MappersConfig instance) {
        return (Builder)MappersConfig.builder().from(instance);
    }

    public static MappersConfig create() {
        return MappersConfig.builder().buildPrototype();
    }

    @Override
    public List<MapperProvider> mapperProviders();

    @Override
    public List<Mapper<?, ?>> mappers();

    @Override
    public boolean useBuiltInMappers();

    public static class Builder
    extends BuilderBase<Builder, MappersConfig>
    implements io.helidon.common.Builder<Builder, Mappers> {
        private Builder() {
        }

        public MappersConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.MappersConfigImpl(this);
        }

        public Mappers build() {
            return Mappers.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends MappersConfig>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<Mapper<?, ?>> mappers = new ArrayList();
        private final List<MapperProvider> mapperProviders = new ArrayList<MapperProvider>();
        private boolean isMapperProvidersMutated;
        private boolean isMappersMutated;
        private boolean mapperProvidersDiscoverServices = true;
        private boolean mappersDiscoverServices = true;
        private boolean useBuiltInMappers = true;
        private ServiceRegistry serviceRegistry;

        protected BuilderBase() {
        }

        public BUILDER from(MappersConfig prototype) {
            if (!this.isMapperProvidersMutated) {
                this.mapperProviders.clear();
            }
            this.addMapperProviders(prototype.mapperProviders());
            this.mapperProvidersDiscoverServices = false;
            if (!this.isMappersMutated) {
                this.mappers.clear();
            }
            this.addMappers(prototype.mappers());
            this.mappersDiscoverServices = false;
            this.useBuiltInMappers(prototype.useBuiltInMappers());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            if (this.isMapperProvidersMutated) {
                if (builder.isMapperProvidersMutated) {
                    this.addMapperProviders(builder.mapperProviders);
                }
            } else {
                this.mapperProviders.clear();
                this.addMapperProviders(builder.mapperProviders);
            }
            this.mapperProvidersDiscoverServices = builder.mapperProvidersDiscoverServices;
            if (this.isMappersMutated) {
                if (builder.isMappersMutated) {
                    this.addMappers(builder.mappers);
                }
            } else {
                this.mappers.clear();
                this.addMappers(builder.mappers);
            }
            this.mappersDiscoverServices = builder.mappersDiscoverServices;
            this.useBuiltInMappers(builder.useBuiltInMappers());
            return (BUILDER)((BuilderBase)this.self());
        }

        public <S, T> BUILDER addMapper(Mapper<S, T> mapper, Class<S> sourceType, Class<T> targetType, String ... qualifiers) {
            MappersConfigSupport.CustomMethods.addMapper(this, mapper, sourceType, targetType, qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public <S, T> BUILDER addMapper(Mapper<S, T> mapper, GenericType<S> sourceType, GenericType<T> targetType, String ... qualifiers) {
            MappersConfigSupport.CustomMethods.addMapper(this, mapper, sourceType, targetType, qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public <S, T> BUILDER addMapper(Mapper<S, T> mapper, Class<S> sourceType, Class<T> targetType, double weight, String ... qualifiers) {
            MappersConfigSupport.CustomMethods.addMapper(this, mapper, sourceType, targetType, weight, qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public <S, T> BUILDER addMapper(Mapper<S, T> mapper, GenericType<S> sourceType, GenericType<T> targetType, double weight, String ... qualifiers) {
            MappersConfigSupport.CustomMethods.addMapper(this, mapper, sourceType, targetType, weight, qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceRegistry(ServiceRegistry registry) {
            Objects.requireNonNull(registry);
            this.serviceRegistry = registry;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mapperProvidersDiscoverServices(boolean discoverServices) {
            this.mapperProvidersDiscoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mapperProviders(List<? extends MapperProvider> mapperProviders) {
            Objects.requireNonNull(mapperProviders);
            this.isMapperProvidersMutated = true;
            this.mapperProviders.clear();
            this.mapperProviders.addAll(mapperProviders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMapperProviders(List<? extends MapperProvider> mapperProviders) {
            Objects.requireNonNull(mapperProviders);
            this.isMapperProvidersMutated = true;
            this.mapperProviders.addAll(mapperProviders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMapperProvider(MapperProvider mapperProvider) {
            Objects.requireNonNull(mapperProvider);
            this.mapperProviders.add(mapperProvider);
            this.isMapperProvidersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mappersDiscoverServices(boolean discoverServices) {
            this.mappersDiscoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mappers(List<Mapper<?, ?>> mappers) {
            Objects.requireNonNull(mappers);
            this.isMappersMutated = true;
            this.mappers.clear();
            this.mappers.addAll(mappers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMappers(List<Mapper<?, ?>> mappers) {
            Objects.requireNonNull(mappers);
            this.isMappersMutated = true;
            this.mappers.addAll(mappers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMapper(Mapper<?, ?> mapper) {
            Objects.requireNonNull(mapper);
            this.mappers.add(mapper);
            this.isMappersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER useBuiltInMappers(boolean useBuiltInMappers) {
            this.useBuiltInMappers = useBuiltInMappers;
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<MapperProvider> mapperProviders() {
            return this.mapperProviders;
        }

        public List<Mapper<?, ?>> mappers() {
            return this.mappers;
        }

        public boolean useBuiltInMappers() {
            return this.useBuiltInMappers;
        }

        public String toString() {
            return "MappersConfigBuilder{mapperProviders=" + String.valueOf(this.mapperProviders) + ",mappers=" + String.valueOf(this.mappers) + ",useBuiltInMappers=" + this.useBuiltInMappers + "}";
        }

        protected void preBuildPrototype() {
            Optional<ServiceRegistry> registry = Optional.ofNullable(this.serviceRegistry);
            Optional mapperProvidersQualifier = Optional.empty();
            this.addMapperProviders(RegistryBuilderSupport.serviceList(registry, (TypeName)TypeName.create((String)"io.helidon.common.mapper.spi.MapperProvider"), (boolean)this.mapperProvidersDiscoverServices, mapperProvidersQualifier));
            Optional mappersQualifier = Optional.empty();
            this.addMappers(RegistryBuilderSupport.serviceList(registry, (TypeName)TypeName.create((String)"io.helidon.common.mapper.Mapper<?, ?>"), (boolean)this.mappersDiscoverServices, mappersQualifier));
            new MappersConfigSupport.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        protected static class MappersConfigImpl
        implements MappersConfig,
        Supplier<Mappers> {
            private final boolean useBuiltInMappers;
            private final List<Mapper<?, ?>> mappers;
            private final List<MapperProvider> mapperProviders;

            protected MappersConfigImpl(BuilderBase<?, ?> builder) {
                this.mapperProviders = List.copyOf(builder.mapperProviders());
                this.mappers = List.copyOf(builder.mappers());
                this.useBuiltInMappers = builder.useBuiltInMappers();
            }

            public Mappers build() {
                return Mappers.create(this);
            }

            @Override
            public Mappers get() {
                return this.build();
            }

            @Override
            public List<MapperProvider> mapperProviders() {
                return this.mapperProviders;
            }

            @Override
            public List<Mapper<?, ?>> mappers() {
                return this.mappers;
            }

            @Override
            public boolean useBuiltInMappers() {
                return this.useBuiltInMappers;
            }

            public String toString() {
                return "MappersConfig{mapperProviders=" + String.valueOf(this.mapperProviders) + ",mappers=" + String.valueOf(this.mappers) + ",useBuiltInMappers=" + this.useBuiltInMappers + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MappersConfig)) {
                    return false;
                }
                MappersConfig other = (MappersConfig)o;
                return Objects.equals(this.mapperProviders, other.mapperProviders()) && Objects.equals(this.mappers, other.mappers()) && this.useBuiltInMappers == other.useBuiltInMappers();
            }

            public int hashCode() {
                return Objects.hash(this.mapperProviders, this.mappers, this.useBuiltInMappers);
            }
        }
    }
}

