/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions.sources;

import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.ConfigMapping;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MappedConfigSource
implements ConfigSource {
    private static final String PROPERTY_NOT_FOUND = "Property '{}' not found in original config source";
    private static final String PROPERTY_ALREADY_DEFINED = "Property '%s' already defined";
    private static final String DUPLICATE_PROPERTY = "Property '{}' already found in original config source";
    private static final String PROPERTY_ALREADY_MAPPED = "Property '%s' has already a mapping defined";
    private static final Logger logger = LogManager.getLogger(MappedConfigSource.class);
    private final ConfigSource wrappedSource;
    private final Queue<ConfigMapping> configMappings;
    private final Map<String, String> properties;
    private final Map<String, List<String>> listProperties;

    public MappedConfigSource(@NonNull ConfigSource wrappedSource) {
        this.wrappedSource = Objects.requireNonNull(wrappedSource, "wrappedSource must not be null");
        this.configMappings = new ConcurrentLinkedQueue<ConfigMapping>();
        this.properties = new HashMap<String, String>();
        this.listProperties = new HashMap<String, List<String>>();
    }

    public void addMapping(@NonNull String mappedName, @NonNull String originalName) {
        this.addMapping(new ConfigMapping(mappedName, originalName));
    }

    public void addMapping(@NonNull ConfigMapping configMapping) {
        Objects.requireNonNull(configMapping, "configMapping must not be null");
        if (this.configMappings.stream().map(ConfigMapping::mappedName).anyMatch(m -> Objects.equals(m, configMapping.mappedName()))) {
            throw new IllegalArgumentException(PROPERTY_ALREADY_DEFINED.formatted(configMapping.mappedName()));
        }
        if (this.configMappings.stream().map(ConfigMapping::originalName).anyMatch(o -> Objects.equals(o, configMapping.originalName()))) {
            throw new IllegalArgumentException(PROPERTY_ALREADY_MAPPED.formatted(configMapping.originalName()));
        }
        this.configMappings.add(configMapping);
        this.properties.clear();
        this.listProperties.clear();
    }

    private void generateMapping() {
        if (!this.properties.isEmpty() || !this.listProperties.isEmpty()) {
            return;
        }
        HashMap internalProperties = new HashMap();
        HashMap internalListProperties = new HashMap();
        this.wrappedSource.getPropertyNames().forEach(propertyName -> {
            if (this.wrappedSource.isListProperty(propertyName)) {
                internalListProperties.put(propertyName, this.wrappedSource.getListValue(propertyName));
            } else {
                internalProperties.put(propertyName, this.wrappedSource.getValue(propertyName));
            }
        });
        HashMap mappedProperties = new HashMap();
        HashMap mappedListProperties = new HashMap();
        this.configMappings.forEach(configMapping -> {
            String mappedName = configMapping.mappedName();
            String originalName = configMapping.originalName();
            if (internalProperties.containsKey(mappedName) || internalListProperties.containsKey(mappedName)) {
                logger.warn(DUPLICATE_PROPERTY, (Object)mappedName);
            } else if (!internalProperties.containsKey(originalName) && !internalListProperties.containsKey(originalName)) {
                logger.warn(PROPERTY_NOT_FOUND, (Object)originalName);
            } else {
                if (this.wrappedSource.isListProperty(originalName)) {
                    mappedListProperties.put(mappedName, (List)internalListProperties.get(originalName));
                } else {
                    mappedProperties.put(mappedName, (String)internalProperties.get(originalName));
                }
                logger.debug("Added config mapping: {}", configMapping);
            }
        });
        this.properties.putAll(internalProperties);
        this.properties.putAll(mappedProperties);
        this.listProperties.putAll(internalListProperties);
        this.listProperties.putAll(mappedListProperties);
    }

    @NonNull
    public Set<String> getPropertyNames() {
        this.generateMapping();
        return Stream.concat(this.properties.keySet().stream(), this.listProperties.keySet().stream()).collect(Collectors.toSet());
    }

    @Nullable
    public String getValue(@NonNull String propertyName) throws NoSuchElementException {
        this.generateMapping();
        Objects.requireNonNull(propertyName, "propertyName must not be null");
        if (this.isListProperty(propertyName)) {
            throw new NoSuchElementException("Property " + propertyName + " is a list property");
        }
        return this.properties.get(propertyName);
    }

    public boolean isListProperty(@NonNull String propertyName) throws NoSuchElementException {
        this.generateMapping();
        Objects.requireNonNull(propertyName, "propertyName must not be null");
        return this.listProperties.containsKey(propertyName);
    }

    @NonNull
    public List<String> getListValue(@NonNull String propertyName) throws NoSuchElementException {
        this.generateMapping();
        Objects.requireNonNull(propertyName, "propertyName must not be null");
        if (!this.isListProperty(propertyName)) {
            throw new NoSuchElementException("Property " + propertyName + " is not a list property");
        }
        return this.listProperties.get(propertyName);
    }

    public int getOrdinal() {
        return this.wrappedSource.getOrdinal();
    }
}

