/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.addressbook.impl.schemas;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.platform.state.StateKey;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.CommonUtils;

public class V053AddressBookSchema
extends Schema<SemanticVersion> {
    private static final Logger log = LogManager.getLogger(V053AddressBookSchema.class);
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("^((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}$");
    private static final long MAX_NODES = 100L;
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(53).patch(0).build();
    public static final String NODES_KEY = "NODES";
    public static final int NODES_STATE_ID = StateKey.KeyOneOfType.ADDRESSBOOKSERVICE_I_NODES.protoOrdinal();
    public static final String NODES_STATE_LABEL = StateMetadata.computeLabel((String)"AddressBookService", (String)"NODES");

    public V053AddressBookSchema() {
        super((Object)VERSION, HapiUtils.SEMANTIC_VERSION_COMPARATOR);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.onDisk((int)NODES_STATE_ID, (String)NODES_KEY, (Codec)EntityNumber.PROTOBUF, (Codec)Node.PROTOBUF, (long)100L));
    }

    public static ServiceEndpoint endpointFor(@NonNull String host, int port) {
        ServiceEndpoint.Builder builder = ServiceEndpoint.newBuilder().port(port);
        if (IPV4_ADDRESS_PATTERN.matcher(host).matches()) {
            String[] octets = host.split("[.]");
            builder.ipAddressV4(Bytes.wrap((byte[])new byte[]{(byte)Integer.parseInt(octets[0]), (byte)Integer.parseInt(octets[1]), (byte)Integer.parseInt(octets[2]), (byte)Integer.parseInt(octets[3])}));
        } else {
            builder.domainName(host);
        }
        return builder.build();
    }

    public static Map<Long, Key> parseEd25519NodeAdminKeysFrom(@NonNull String loc) {
        Path path = Paths.get(loc, new String[0]);
        try {
            String json = Files.readString(path);
            return V053AddressBookSchema.parseEd25519NodeAdminKeys(json);
        }
        catch (IOException ignore) {
            return Collections.emptyMap();
        }
    }

    public static Map<Long, Key> parseEd25519NodeAdminKeys(@NonNull String json) {
        Objects.requireNonNull(json);
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map result = (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<Long, String>>(){});
            return result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Key.newBuilder().ed25519(Bytes.wrap((byte[])CommonUtils.unhex((String)((String)e.getValue())))).build()));
        }
        catch (JsonProcessingException e2) {
            log.warn("Unable to parse override keys", (Throwable)e2);
            return Collections.emptyMap();
        }
    }
}

