/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.context;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.DefaultPlatformContext;
import com.swirlds.common.context.internal.PlatformUncaughtExceptionHandler;
import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.common.io.utility.NoOpRecycleBin;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.base.concurrent.ExecutorFactory;
import org.hiero.consensus.metrics.noop.NoOpMetrics;

public interface PlatformContext {
    @NonNull
    public static PlatformContext create(@NonNull Configuration configuration) {
        NoOpMetrics metrics = new NoOpMetrics();
        FileSystemManager fileSystemManager = FileSystemManager.create(configuration);
        Time time = Time.getCurrent();
        return PlatformContext.create(configuration, time, (Metrics)metrics, fileSystemManager, new NoOpRecycleBin());
    }

    @NonNull
    public static PlatformContext create(@NonNull Configuration configuration, @NonNull Time time, @NonNull Metrics metrics, @NonNull FileSystemManager fileSystemManager, @NonNull RecycleBin recycleBin) {
        PlatformUncaughtExceptionHandler handler = new PlatformUncaughtExceptionHandler();
        ExecutorFactory executorFactory = ExecutorFactory.create((String)"platform", null, (Thread.UncaughtExceptionHandler)handler);
        return new DefaultPlatformContext(configuration, metrics, time, executorFactory, fileSystemManager, recycleBin);
    }

    @NonNull
    public Configuration getConfiguration();

    @NonNull
    public Metrics getMetrics();

    @NonNull
    public Time getTime();

    @NonNull
    public FileSystemManager getFileSystemManager();

    @NonNull
    public ExecutorFactory getExecutorFactory();

    @NonNull
    public RecycleBin getRecycleBin();
}

