/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.tss.codec;

import com.hedera.hapi.node.tss.LedgerIdNodeContribution;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class LedgerIdNodeContributionJsonCodec
implements JsonCodec<LedgerIdNodeContribution> {
    @NonNull
    public LedgerIdNodeContribution parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_node_id = 0L;
            long temp_weight = 0L;
            Bytes temp_history_proof_key = Bytes.EMPTY;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "nodeId": {
                        temp_node_id = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                    case "weight": {
                        temp_weight = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                    case "historyProofKey": {
                        temp_history_proof_key = Bytes.fromBase64((String)JsonTools.checkSize((String)"history_proof_key", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new LedgerIdNodeContribution(temp_node_id, temp_weight, temp_history_proof_key);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull LedgerIdNodeContribution data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.nodeId() != 0L) {
            fieldLines.add(JsonTools.field((String)"nodeId", (long)data.nodeId()));
        }
        if (data.weight() != 0L) {
            fieldLines.add(JsonTools.field((String)"weight", (long)data.weight()));
        }
        if (data.historyProofKey() != Bytes.EMPTY && data.historyProofKey() != null && data.historyProofKey().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"historyProofKey", (Bytes)data.historyProofKey()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

