/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph.internal;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.roster.RosterUtils;

public class RosterMetadata {
    private final Roster roster;
    private final int numMembers;
    private final String[] memberLabels;

    public RosterMetadata(@NonNull Roster roster) {
        int m;
        this.roster = Objects.requireNonNull(roster, "roster must not be null");
        this.numMembers = m = roster.rosterEntries().size();
        this.memberLabels = new String[m];
        for (int i = 0; i < m; ++i) {
            this.memberLabels[i] = "ID:%d W:%d".formatted(((RosterEntry)roster.rosterEntries().get(i)).nodeId(), ((RosterEntry)roster.rosterEntries().get(i)).weight());
        }
    }

    public int getNumMembers() {
        return this.numMembers;
    }

    public int getNumColumns() {
        return this.numMembers;
    }

    public int mems2col(@NonNull EventImpl e) {
        Objects.requireNonNull(e, "e must not be null");
        return RosterUtils.getIndex((Roster)this.roster, (long)e.getCreatorId().id());
    }

    public String getLabel(int i) {
        return this.memberLabels[i];
    }
}

