/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.http.http2.FlowControl;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.http.http2.WindowSize;
import java.util.function.BiConsumer;

class FlowControlNoop
implements FlowControl {
    FlowControlNoop() {
    }

    @Override
    public void decrementWindowSize(int decrement) {
    }

    @Override
    public void resetStreamWindowSize(int size) {
    }

    @Override
    public int getRemainingWindowSize() {
        return Integer.MAX_VALUE;
    }

    static class Outbound
    extends FlowControlNoop
    implements FlowControl.Outbound {
        Outbound() {
        }

        @Override
        public long incrementStreamWindowSize(int increment) {
            return Integer.MAX_VALUE;
        }

        @Override
        public Http2FrameData[] cut(Http2FrameData frame) {
            return new Http2FrameData[]{frame};
        }

        @Override
        public void blockTillUpdate() {
        }

        @Override
        public int maxFrameSize() {
            return 16384;
        }
    }

    static class Inbound
    extends FlowControlNoop
    implements FlowControl.Inbound {
        private final WindowSize.Inbound connectionWindowSize;
        private final WindowSize.Inbound streamWindowSize;

        Inbound(int streamId, WindowSize.Inbound connectionWindowSize, BiConsumer<Integer, Http2WindowUpdate> windowUpdateStreamWriter) {
            this.connectionWindowSize = connectionWindowSize;
            this.streamWindowSize = WindowSize.createInboundNoop(streamId, windowUpdateStreamWriter);
        }

        @Override
        public void incrementWindowSize(int increment) {
            this.streamWindowSize.incrementWindowSize(increment);
            this.connectionWindowSize.incrementWindowSize(increment);
        }
    }
}

