/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.spi.metrics.StoreMetrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.hiero.consensus.metrics.FunctionGauge;

public class StoreMetricsImpl
implements StoreMetrics {
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong capacity = new AtomicLong(1L);

    public StoreMetricsImpl(@NonNull Metrics metrics, @NonNull String name) {
        this(metrics, name, name);
    }

    public StoreMetricsImpl(@NonNull Metrics metrics, @NonNull String name, @NonNull String label) {
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(label, "label must not be null");
        FunctionGauge.Config totalUtilizationConfig = new FunctionGauge.Config("app", name + "Used", Long.class, this.count::get).withDescription(String.format("instantaneous %% used of %s system limit", label)).withFormat("%,d");
        metrics.getOrCreate((MetricConfig)totalUtilizationConfig);
        FunctionGauge.Config relativeUtilizationConfig = new FunctionGauge.Config("app", name + "PercentUsed", Double.class, () -> 100.0 * (double)this.count.get() / (double)Math.max(1L, this.capacity.get())).withDescription(String.format("instantaneous %% used of %s system limit", label)).withFormat("%,13.2f");
        metrics.getOrCreate((MetricConfig)relativeUtilizationConfig);
    }

    public void updateCount(long newValue) {
        this.count.set(newValue);
    }

    void updateCapacity(long newValue) {
        this.capacity.set(newValue);
    }

    @VisibleForTesting
    public AtomicLong getCount() {
        return this.count;
    }
}

