/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.gas;

import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.FunctionalityResourcePrices;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class TinybarValues {
    private final ExchangeRate exchangeRate;
    private final FunctionalityResourcePrices topLevelResourcePrices;
    @Nullable
    private final FunctionalityResourcePrices childTransactionResourcePrices;

    public static TinybarValues forQueryWith(@NonNull ExchangeRate exchangeRate) {
        return new TinybarValues(exchangeRate, FunctionalityResourcePrices.PREPAID_RESOURCE_PRICES, null);
    }

    public static TinybarValues forTransactionWith(@NonNull ExchangeRate exchangeRate, @NonNull FunctionalityResourcePrices topLevelResourcePrices, @Nullable FunctionalityResourcePrices childTransactionResourcePrices) {
        return new TinybarValues(exchangeRate, topLevelResourcePrices, childTransactionResourcePrices);
    }

    private TinybarValues(@NonNull ExchangeRate exchangeRate, @NonNull FunctionalityResourcePrices topLevelResourcePrices, @Nullable FunctionalityResourcePrices childTransactionResourcePrices) {
        this.exchangeRate = Objects.requireNonNull(exchangeRate);
        this.topLevelResourcePrices = Objects.requireNonNull(topLevelResourcePrices);
        this.childTransactionResourcePrices = childTransactionResourcePrices;
    }

    public long asTinybars(long tinycents) {
        return ConversionUtils.fromTinycentsToTinybars(this.exchangeRate, tinycents);
    }

    public long asTinycents(long tinyBars) {
        return ConversionUtils.fromTinybarsToTinycents(this.exchangeRate, tinyBars);
    }

    public long topLevelTinybarGasPrice() {
        return this.asTinybars(this.topLevelResourcePrices.basePrices().servicedataOrThrow().gas() / 1000L * this.topLevelResourcePrices.congestionMultiplier());
    }

    public long topLevelTinybarGasPriceFullPrecision() {
        return this.asTinybars(this.topLevelResourcePrices.basePrices().servicedataOrThrow().gas() * this.topLevelResourcePrices.congestionMultiplier());
    }

    public long topLevelTinycentGasPrice() {
        return this.topLevelResourcePrices.basePrices().servicedataOrThrow().gas() * this.topLevelResourcePrices.congestionMultiplier();
    }

    public long childTransactionTinybarGasPrice() {
        if (this.childTransactionResourcePrices == null) {
            throw new IllegalStateException("Cannot dispatch a child transaction from a query");
        }
        return this.asTinybars(this.childTransactionResourcePrices.basePrices().servicedataOrThrow().gas() / 1000L * this.childTransactionResourcePrices.congestionMultiplier());
    }

    public long childTransactionTinycentGasPrice() {
        if (this.childTransactionResourcePrices == null) {
            throw new IllegalStateException("Cannot dispatch a child transaction from a query");
        }
        return this.childTransactionResourcePrices.basePrices().servicedataOrThrow().gas() * this.childTransactionResourcePrices.congestionMultiplier();
    }

    public long topLevelTinycentRbhPrice() {
        return this.topLevelResourcePrices.basePrices().servicedataOrThrow().rbh() * this.topLevelResourcePrices.congestionMultiplier();
    }
}

