/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.LazyValue;
import io.helidon.common.LruCache;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.service.registry.ActivationRequest;
import io.helidon.service.registry.Activator;
import io.helidon.service.registry.Activators;
import io.helidon.service.registry.Bindings;
import io.helidon.service.registry.InstanceNameServiceManager;
import io.helidon.service.registry.InstanceName__ServiceDescriptor;
import io.helidon.service.registry.Interception;
import io.helidon.service.registry.InterceptionMetadata;
import io.helidon.service.registry.InterceptionMetadataImpl;
import io.helidon.service.registry.InterceptionMetadata__ServiceDescriptor;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.LookupTrace;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.RegistryMetrics;
import io.helidon.service.registry.RegistryMetricsImpl;
import io.helidon.service.registry.Scope;
import io.helidon.service.registry.ScopeNotActiveException;
import io.helidon.service.registry.ScopedRegistry;
import io.helidon.service.registry.ScopedRegistryImpl;
import io.helidon.service.registry.Scopes;
import io.helidon.service.registry.Scopes__ServiceDescriptor;
import io.helidon.service.registry.Service;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceInstance;
import io.helidon.service.registry.ServiceManager;
import io.helidon.service.registry.ServiceProvider;
import io.helidon.service.registry.ServiceRegistry;
import io.helidon.service.registry.ServiceRegistryConfig;
import io.helidon.service.registry.ServiceRegistryException;
import io.helidon.service.registry.ServiceRegistryManager;
import io.helidon.service.registry.ServiceRegistry__ServiceDescriptor;
import io.helidon.service.registry.ServiceSupplies;
import io.helidon.service.registry.VirtualDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class CoreServiceRegistry
implements ServiceRegistry,
Scopes {
    private static final ResolvedType COMMON_CONFIG = ResolvedType.create((String)"io.helidon.common.config.Config");
    private static final ResolvedType CONFIG = ResolvedType.create((String)"io.helidon.config.Config");
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final String id = String.valueOf(COUNTER.incrementAndGet());
    private final RegistryMetricsImpl metrics = new RegistryMetricsImpl();
    private final ReadWriteLock stateLock = new ReentrantReadWriteLock();
    private final Lock stateReadLock = this.stateLock.readLock();
    private final Lock stateWriteLock = this.stateLock.writeLock();
    private final Map<TypeName, ServiceInfo> scopeHandlerServices;
    private final Map<TypeName, ServiceInfo> servicesByType;
    private final Map<ResolvedType, Set<ServiceInfo>> servicesByContract;
    private final Map<TypeName, Set<ServiceInfo>> qualifiedProvidersByQualifier;
    private final Map<ServiceRegistryManager.TypedQualifiedProviderKey, Set<ServiceInfo>> typedQualifiedProviders;
    private final Map<ResolvedType, AtomicBoolean> accessedContracts;
    private final boolean cacheEnabled;
    private final LruCache<Lookup, List<ServiceInfo>> cache;
    private final ReadWriteLock getCacheLock = new ReentrantReadWriteLock();
    private final Map<Class<?>, Object> getCache = new IdentityHashMap();
    private final LazyValue<Scope> singletonScope = LazyValue.create(() -> this.createScope(Service.Singleton.TYPE, Optional::empty, this.id, Map.of()));
    private final LazyValue<Scope> perLookupScope = LazyValue.create(() -> this.createScope(Service.PerLookup.TYPE, Optional::empty, this.id, Map.of()));
    private final Map<TypeName, Service.ScopeHandler> scopeHandlerInstances = new HashMap<TypeName, Service.ScopeHandler>();
    private final Lock scopeHandlerInstancesLock = new ReentrantLock();
    private final boolean interceptionEnabled;
    private final InterceptionMetadata interceptionMetadata;
    private final ServiceManager<String> serviceManagerForInstanceName;
    private final Map<ServiceInfo, ServiceManager<?>> servicesByDescriptor = new IdentityHashMap();
    private final ActivationRequest activationRequest;
    private final Bindings bindings;
    private final boolean allowLateBinding;
    private Map<ServiceInfo, ServiceManager<Interception.Interceptor>> interceptors;

    CoreServiceRegistry(ServiceRegistryConfig config, Set<ServiceDescriptor<?>> descriptors, Map<TypeName, ServiceInfo> scopeHandlers, Map<ServiceInfo, Object> explicitInstances, Map<TypeName, ServiceInfo> servicesByType, Map<ResolvedType, Set<ServiceInfo>> servicesByContract, Map<TypeName, Set<ServiceInfo>> qualifiedProvidersByQualifier, Map<ServiceRegistryManager.TypedQualifiedProviderKey, Set<ServiceInfo>> typedQualifiedProviders, Map<ResolvedType, AtomicBoolean> accessedContracts) {
        this.accessedContracts = Map.copyOf(accessedContracts);
        this.interceptionEnabled = config.interceptionEnabled();
        this.interceptionMetadata = this.interceptionEnabled ? InterceptionMetadataImpl.create(this) : InterceptionMetadataImpl.noop();
        this.bindings = new Bindings(this);
        this.allowLateBinding = config.allowLateBinding();
        explicitInstances.put(Scopes__ServiceDescriptor.INSTANCE, this);
        explicitInstances.put(ServiceRegistry__ServiceDescriptor.INSTANCE, this);
        explicitInstances.put(InterceptionMetadata__ServiceDescriptor.INSTANCE, this.interceptionMetadata);
        this.accessed(Scopes__ServiceDescriptor.INSTANCE);
        this.accessed(ServiceRegistry__ServiceDescriptor.INSTANCE);
        this.accessed(InterceptionMetadata__ServiceDescriptor.INSTANCE);
        this.cacheEnabled = config.lookupCacheEnabled();
        this.cache = this.cacheEnabled ? LruCache.create((int)config.lookupCacheSize()) : null;
        this.scopeHandlerServices = scopeHandlers;
        this.servicesByType = new HashMap<TypeName, ServiceInfo>(servicesByType);
        this.servicesByContract = new HashMap<ResolvedType, Set<ServiceInfo>>(servicesByContract);
        this.qualifiedProvidersByQualifier = qualifiedProvidersByQualifier;
        this.typedQualifiedProviders = typedQualifiedProviders;
        this.activationRequest = ((ActivationRequest.Builder)ActivationRequest.builder().targetPhase(config.limitActivationPhase())).build();
        descriptors.forEach(descriptor -> {
            this.bindings.register((ServiceInfo)descriptor);
            Object instance = explicitInstances.get(descriptor);
            ServiceProvider provider = new ServiceProvider(this, descriptor);
            if (instance != null) {
                Activator activator = Activators.create(provider, instance);
                this.servicesByDescriptor.put((ServiceInfo)descriptor, new ServiceManager(this, this.scopeSupplier((ServiceInfo)descriptor), provider, true, () -> activator));
            } else {
                this.servicesByDescriptor.putIfAbsent((ServiceInfo)descriptor, new ServiceManager(this, this.scopeSupplier((ServiceInfo)descriptor), provider, false, Activators.create(this, provider)));
            }
        });
        this.serviceManagerForInstanceName = new InstanceNameServiceManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> contract) {
        Object instance;
        this.getCacheLock.readLock().lock();
        try {
            instance = this.getCache.get(contract);
        }
        finally {
            this.getCacheLock.readLock().unlock();
        }
        if (instance == null) {
            instance = this.get(TypeName.create(contract));
            List<ServiceManager<T>> serviceManagers = this.lookupManagers(Lookup.create(contract));
            boolean onlySingletons = serviceManagers.stream().map(ServiceManager::descriptor).map(ServiceInfo::scope).allMatch(arg_0 -> ((TypeName)Service.Singleton.TYPE).equals(arg_0));
            if (onlySingletons) {
                this.getCacheLock.writeLock().lock();
                try {
                    this.getCache.put(contract, instance);
                }
                finally {
                    this.getCacheLock.writeLock().unlock();
                }
            }
        }
        return (T)instance;
    }

    @Override
    public <T> T get(TypeName contract) {
        return this.get(Lookup.create(contract));
    }

    @Override
    public <T> T get(Lookup lookup) {
        return this.supply(lookup).get();
    }

    @Override
    public <T> Supplier<T> supply(TypeName contract) {
        return this.supply(Lookup.create(contract));
    }

    @Override
    public <T> Supplier<T> supply(Lookup lookup) {
        List<ServiceManager<T>> managers = this.lookupManagers(lookup);
        if (managers.isEmpty()) {
            throw new ServiceRegistryException("There is no service in registry that matches this lookup: " + String.valueOf(lookup));
        }
        return new ServiceSupplies.ServiceSupply<T>(lookup, managers);
    }

    @Override
    public <T> Optional<T> get(ServiceInfo serviceInfo) {
        ServiceManager<?> serviceManager = this.servicesByDescriptor.get(serviceInfo);
        if (serviceManager == null) {
            return Optional.empty();
        }
        return new ServiceSupplies.ServiceSupplyOptional<T>(Lookup.EMPTY, List.of(this.serviceManager(serviceInfo))).get();
    }

    @Override
    public <T> Optional<T> first(TypeName contract) {
        return this.first(Lookup.create(contract));
    }

    @Override
    public <T> Optional<T> first(Lookup lookup) {
        return this.supplyFirst(lookup).get();
    }

    @Override
    public <T> Supplier<Optional<T>> supplyFirst(TypeName contract) {
        return this.supplyFirst(Lookup.create(contract));
    }

    @Override
    public <T> Supplier<Optional<T>> supplyFirst(Lookup lookup) {
        List<ServiceManager<T>> managers = this.lookupManagers(lookup);
        if (managers.isEmpty()) {
            return Optional::empty;
        }
        return new ServiceSupplies.ServiceSupplyOptional<T>(lookup, managers);
    }

    @Override
    public <T> List<T> all(TypeName contract) {
        return this.all(Lookup.create(contract));
    }

    @Override
    public <T> List<T> all(Lookup lookup) {
        return this.supplyAll(lookup).get();
    }

    @Override
    public <T> Supplier<List<T>> supplyAll(TypeName contract) {
        return this.supplyAll(Lookup.create(contract));
    }

    @Override
    public <T> Supplier<List<T>> supplyAll(Lookup lookup) {
        List<ServiceManager<T>> managers = this.lookupManagers(lookup);
        if (managers.isEmpty()) {
            return List::of;
        }
        return new ServiceSupplies.ServiceSupplyList<T>(lookup, managers);
    }

    @Override
    public List<ServiceInfo> allServices(TypeName contract) {
        return this.lookupServices(Lookup.create(contract));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceInfo> lookupServices(Lookup lookup) {
        try {
            ResolvedType theOnlyContractRequested;
            Set<ServiceInfo> subsetOfMatches;
            ServiceInfo exact;
            this.stateReadLock.lock();
            if (lookup.qualifiers().contains(Qualifier.CREATE_FOR_NAME)) {
                this.checkCreateForName(lookup);
                List<ServiceInfo> list = List.of(InstanceName__ServiceDescriptor.INSTANCE);
                return list;
            }
            this.metrics.lookup();
            LookupTrace.traceLookup(lookup, "start: {0}", lookup);
            if (this.cacheEnabled) {
                List cacheResult = this.cache.get((Object)lookup).orElse(null);
                this.metrics.cacheAccess();
                if (cacheResult != null) {
                    LookupTrace.traceLookup(lookup, "from cache", cacheResult);
                    this.metrics.cacheHit();
                    List list = cacheResult;
                    return list;
                }
            }
            ArrayList<ServiceInfo> result = new ArrayList<ServiceInfo>();
            if (lookup.serviceType().isPresent() && (exact = this.servicesByType.get(lookup.serviceType().get())) != null) {
                LookupTrace.traceLookup(lookup, "by service type", result);
                result.add(exact);
                ArrayList<ServiceInfo> arrayList = result;
                return arrayList;
            }
            if (1 == lookup.contracts().size() && (subsetOfMatches = this.servicesByContract.get(theOnlyContractRequested = lookup.contracts().iterator().next())) != null) {
                subsetOfMatches.stream().filter(lookup::matches).forEach(result::add);
                if (!result.isEmpty()) {
                    LookupTrace.traceLookup(lookup, "by single contract", result);
                    if (this.cacheEnabled) {
                        this.cache.put((Object)lookup, result);
                    }
                    ArrayList<ServiceInfo> arrayList = result;
                    return arrayList;
                }
            }
            this.metrics.fullScan();
            this.servicesByDescriptor.keySet().stream().filter(lookup::matches).sorted(ServiceRegistryManager.SERVICE_INFO_COMPARATOR).forEach(result::add);
            LookupTrace.traceLookup(lookup, "from full table scan", result);
            if (result.isEmpty() && !lookup.qualifiers().isEmpty() && lookup.contracts().size() == 1) {
                ResolvedType contract = lookup.contracts().iterator().next();
                for (Qualifier qualifier : lookup.qualifiers()) {
                    TypeName qualifierType = qualifier.typeName();
                    Set<ServiceInfo> found = this.typedQualifiedProviders.get(new ServiceRegistryManager.TypedQualifiedProviderKey(qualifierType, contract));
                    if (found != null) {
                        LookupTrace.traceLookup(lookup, "from typed qualified providers", found);
                        result.addAll(found);
                    }
                    if ((found = this.qualifiedProvidersByQualifier.get(qualifierType)) == null) continue;
                    LookupTrace.traceLookup(lookup, "from typed qualified providers", found);
                    result.addAll(found);
                }
            }
            if (this.cacheEnabled) {
                this.cache.put((Object)lookup, result);
            }
            LookupTrace.traceLookup(lookup, "full result", result);
            ArrayList<ServiceInfo> arrayList = result;
            return arrayList;
        }
        finally {
            this.stateReadLock.unlock();
        }
    }

    @Override
    public <T> List<ServiceInstance<T>> lookupInstances(Lookup lookup) {
        Lookup instanceLookup = lookup.factoryTypes().isEmpty() && lookup.serviceType().isPresent() ? ((Lookup.Builder)Lookup.builder(lookup).clearServiceType()).build() : lookup;
        return new ServiceSupplies.ServiceInstanceSupplyList<T>(instanceLookup, this.lookupManagers(lookup)).get();
    }

    @Override
    public Scope createScope(TypeName scopeType, String id, Map<ServiceDescriptor<?>, Object> initialBindings) {
        return this.createScope(scopeType, this.scopeHandler(scopeType), id, initialBindings);
    }

    @Override
    public RegistryMetrics metrics() {
        return this.metrics;
    }

    Bindings bindings() {
        return this.bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(ServiceDescriptor descriptor) {
        if (!this.allowLateBinding) {
            throw new ServiceRegistryException("This service registry instance does not support late binding, as it was explicitly disabled through registry configuration: " + this.id);
        }
        this.stateWriteLock.lock();
        try {
            Set<ResolvedType> contracts = descriptor.contracts();
            contracts.forEach(this::checkValidContract);
            ServiceProvider provider = new ServiceProvider(this, descriptor);
            Supplier activator = Activators.create(this, provider);
            this.servicesByDescriptor.put(descriptor, new ServiceManager(this, this.scopeSupplier(descriptor), provider, true, activator));
            for (ResolvedType contract : contracts) {
                ServiceInfo serviceInfo = this.servicesByType.get(contract.type());
                if (serviceInfo != null) {
                    throw new ServiceRegistryException("Cannot add a custom service descriptor for a service implementation: " + String.valueOf(contract.type()));
                }
                TreeSet<ServiceInfo> serviceInfos = new TreeSet<ServiceInfo>(ServiceRegistryManager.SERVICE_INFO_COMPARATOR);
                Set<ServiceInfo> existing = this.servicesByContract.get(contract);
                if (existing != null) {
                    serviceInfos.addAll(existing);
                }
                serviceInfos.add(descriptor);
                this.servicesByContract.put(contract, serviceInfos);
                this.bindings.forgetContract(contract);
            }
        }
        finally {
            this.stateWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void add(Class<T> contract, double weight, T instance) {
        if (!this.allowLateBinding) {
            throw new ServiceRegistryException("This service registry instance does not support late binding, as it was explicitly disabled through registry configuration: " + this.id);
        }
        this.stateWriteLock.lock();
        try {
            TreeSet<ServiceInfo> serviceInfos;
            ResolvedType contractType = ResolvedType.create(contract);
            this.checkValidContract(contractType);
            ServiceInfo serviceInfo = this.servicesByType.get(contractType.type());
            if (serviceInfo == null) {
                serviceInfos = new TreeSet<ServiceInfo>(ServiceRegistryManager.SERVICE_INFO_COMPARATOR);
                Set<ServiceInfo> currentInfos = this.servicesByContract.get(contractType);
                if (currentInfos != null) {
                    serviceInfos.addAll(currentInfos);
                }
            } else {
                throw new ServiceRegistryException("Cannot add a service instance for service implementation: " + contract.getName());
            }
            VirtualDescriptor vt = new VirtualDescriptor(contractType.type(), weight, instance);
            ServiceProvider<Object> provider = new ServiceProvider<Object>(this, vt);
            Activator<Object> activator = Activators.create(provider, instance);
            this.servicesByDescriptor.put(vt, new ServiceManager<Object>(this, this.scopeSupplier(vt), provider, true, () -> activator));
            serviceInfos.add(vt);
            this.servicesByContract.put(contractType, serviceInfos);
            this.bindings.forgetContract(contractType);
        }
        finally {
            this.stateWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void setQualified(Class<T> contract, T instance, Set<Qualifier> qualifiers) {
        if (!this.allowLateBinding) {
            throw new ServiceRegistryException("This service registry instance does not support late binding, as it was explicitly disabled through registry configuration: " + this.id);
        }
        this.stateWriteLock.lock();
        try {
            ResolvedType contractType = ResolvedType.create(contract);
            this.checkValidContract(contractType);
            ServiceInfo serviceInfo = this.servicesByType.get(contractType.type());
            if (serviceInfo != null && !serviceInfo.qualifiers().equals(qualifiers)) {
                throw new IllegalArgumentException("Attempting to create a qualified service instance for a service implementation, with wrong qualifiers: " + contract.getName() + ", qualifiers: " + String.valueOf(qualifiers));
            }
            if (serviceInfo == null) {
                TreeSet<ServiceInfo> serviceInfos = new TreeSet<ServiceInfo>(ServiceRegistryManager.SERVICE_INFO_COMPARATOR);
                VirtualDescriptor vt = new VirtualDescriptor(contractType.type(), 100.0, instance, qualifiers);
                ServiceProvider<Object> provider = new ServiceProvider<Object>(this, vt);
                Activator<Object> activator = Activators.create(provider, instance);
                this.servicesByDescriptor.put(vt, new ServiceManager<Object>(this, this.scopeSupplier(vt), provider, true, () -> activator));
                serviceInfos.add(vt);
                this.servicesByContract.put(contractType, serviceInfos);
            } else {
                ServiceProvider provider = new ServiceProvider(this, (ServiceDescriptor)serviceInfo);
                Activator activator = Activators.create(provider, instance);
                this.servicesByDescriptor.put(serviceInfo, new ServiceManager(this, this.scopeSupplier(serviceInfo), provider, true, () -> activator));
            }
            this.bindings.forgetContract(contractType);
        }
        finally {
            this.stateWriteLock.unlock();
        }
        this.stateWriteLock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void set(Class<T> contract, T[] instances) {
        if (!this.allowLateBinding) {
            throw new ServiceRegistryException("This service registry instance does not support late binding, as it was explicitly disabled through registry configuration: " + this.id);
        }
        this.stateWriteLock.lock();
        try {
            ResolvedType contractType = ResolvedType.create(contract);
            if (contractType.equals((Object)CONFIG)) {
                this.doSet(CONFIG, instances);
                this.doSet(COMMON_CONFIG, instances);
            } else {
                this.doSet(contractType, instances);
            }
        }
        finally {
            this.stateWriteLock.unlock();
        }
    }

    private <T> void doSet(ResolvedType contractType, T[] instances) {
        this.checkValidContract(contractType);
        ServiceInfo serviceInfo = this.servicesByType.get(contractType.type());
        if (serviceInfo == null) {
            TreeSet<ServiceInfo> serviceInfos = new TreeSet<ServiceInfo>(ServiceRegistryManager.SERVICE_INFO_COMPARATOR);
            double currentWeight = 100.0;
            for (T instance : instances) {
                VirtualDescriptor vt = new VirtualDescriptor(contractType.type(), currentWeight, instance);
                ServiceProvider<Object> provider = new ServiceProvider<Object>(this, vt);
                Activator<Object> activator = Activators.create(provider, instance);
                this.servicesByDescriptor.put(vt, new ServiceManager<Object>(this, this.scopeSupplier(vt), provider, true, () -> activator));
                serviceInfos.add(vt);
                currentWeight -= 0.001;
            }
            this.servicesByContract.put(contractType, serviceInfos);
        } else {
            ServiceProvider provider = new ServiceProvider(this, (ServiceDescriptor)serviceInfo);
            if (instances.length != 1) {
                throw new ServiceRegistryException("Attempting to set a service provider with wrong number of instances. A service provider must have exactly one instance.");
            }
            Activator activator = Activators.create(provider, instances[0]);
            this.servicesByDescriptor.put(serviceInfo, new ServiceManager(this, this.scopeSupplier(serviceInfo), provider, true, () -> activator));
        }
        this.bindings.forgetContract(contractType);
    }

    InterceptionMetadata interceptionMetadata() {
        return this.interceptionMetadata;
    }

    ActivationRequest activationRequest() {
        return this.activationRequest;
    }

    List<ServiceInfo> servicesByContract(ResolvedType contract) {
        Set<ServiceInfo> serviceInfos = this.servicesByContract.get(contract);
        if (serviceInfos == null) {
            return List.of();
        }
        return serviceInfos.stream().collect(Collectors.toList());
    }

    <T> ServiceManager<T> serviceManager(ServiceInfo info) {
        if (info == InstanceName__ServiceDescriptor.INSTANCE) {
            return this.serviceManagerForInstanceName;
        }
        ServiceManager<?> result = this.servicesByDescriptor.get(info);
        if (result == null) {
            throw new ServiceRegistryException("Attempt to use service info not managed by this registry: " + String.valueOf(info));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interceptors(ServiceInfo ... serviceInfos) {
        if (!this.interceptionEnabled) {
            return;
        }
        try {
            this.stateWriteLock.lock();
            if (this.interceptors == null) {
                this.interceptors = new LinkedHashMap<ServiceInfo, ServiceManager<Interception.Interceptor>>();
            }
            TreeSet<ServiceInfo> ordered = new TreeSet<ServiceInfo>(ServiceRegistryManager.SERVICE_INFO_COMPARATOR);
            for (ServiceInfo serviceInfo : serviceInfos) {
                ServiceManager serviceManager = this.serviceManager(serviceInfo);
                ordered.add(serviceManager.descriptor());
            }
            for (ServiceInfo serviceInfo : ordered) {
                this.interceptors.computeIfAbsent(serviceInfo, this::serviceManager);
            }
        }
        finally {
            this.stateWriteLock.unlock();
        }
    }

    void shutdown() {
        ((Scope)this.singletonScope.get()).close();
    }

    <T> List<ServiceManager<T>> lookupManagers(Lookup lookup) {
        ArrayList<ServiceManager<T>> result = new ArrayList<ServiceManager<T>>();
        for (ServiceInfo service : this.lookupServices(lookup)) {
            result.add(this.serviceManager(service));
            this.accessed(service);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ServiceManager<Interception.Interceptor>> interceptors() {
        try {
            this.stateReadLock.lock();
            if (this.interceptors != null) {
                List<ServiceManager<Interception.Interceptor>> list = List.copyOf(this.interceptors.values());
                return list;
            }
        }
        finally {
            this.stateReadLock.unlock();
        }
        try {
            this.stateWriteLock.lock();
            if (this.interceptors == null) {
                this.interceptors = new LinkedHashMap<ServiceInfo, ServiceManager<Interception.Interceptor>>();
                List serviceManagers = this.lookupManagers(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(Interception.Interceptor.class)).addQualifier(Qualifier.WILDCARD_NAMED)).build());
                for (ServiceManager serviceManager : serviceManagers) {
                    this.interceptors.put(serviceManager.descriptor(), serviceManager);
                }
            }
            List<ServiceManager<Interception.Interceptor>> list = List.copyOf(this.interceptors.values());
            return list;
        }
        finally {
            this.stateWriteLock.unlock();
        }
    }

    void ensureInjectionPlans() {
        this.servicesByDescriptor.values().forEach(ServiceManager::ensureBindingPlan);
    }

    private void accessed(ServiceInfo service) {
        this.stateReadLock.lock();
        try {
            this.accessed(ResolvedType.create((TypeName)service.serviceType()));
            service.contracts().forEach(this::accessed);
        }
        finally {
            this.stateReadLock.unlock();
        }
    }

    private void accessed(ResolvedType type) {
        AtomicBoolean atomicBoolean = this.accessedContracts.get(type);
        if (atomicBoolean == null) {
            return;
        }
        atomicBoolean.set(true);
    }

    private void checkValidContract(ResolvedType contract) {
        AtomicBoolean accessed = this.accessedContracts.get(contract);
        if (this.bindings.isValidContract(contract) && accessed == null) {
            return;
        }
        if (accessed == null) {
            throw new ServiceRegistryException("Contract " + contract.resolvedName() + " is not provided by any service in the registry, so it cannot have instances configured, as no services can use it.");
        }
        if (accessed.get()) {
            throw new ServiceRegistryException("Contract " + contract.resolvedName() + " has already been set, or accessed by a service, its instances cannot be re-configured, as that would end up in inconsistent state of the service registry.");
        }
    }

    private void checkCreateForName(Lookup lookup) {
        if (lookup.qualifiers().size() != 1) {
            throw new ServiceRegistryException("Invalid injection lookup. @" + Service.InstanceName.class.getName() + " must be the only qualifier used.");
        }
        if (!lookup.contracts().contains(ResolvedType.create((TypeName)TypeNames.STRING))) {
            throw new ServiceRegistryException("Invalid injection lookup. @" + Service.InstanceName.class.getName() + " must use String contract.");
        }
        if (lookup.contracts().size() != 1) {
            throw new ServiceRegistryException("Invalid injection lookup. @" + Service.InstanceName.class.getName() + " must use String as the only contract.");
        }
    }

    private Supplier<Scope> scopeSupplier(ServiceInfo descriptor) {
        TypeName scope = descriptor.scope();
        if (Service.Singleton.TYPE.equals((Object)scope)) {
            return this.singletonScope;
        }
        if (Service.PerLookup.TYPE.equals((Object)scope)) {
            return this.perLookupScope;
        }
        LazyValue scopeHandler = LazyValue.create(() -> this.scopeHandler(scope));
        return () -> ((Service.ScopeHandler)scopeHandler.get()).currentScope().orElseThrow(() -> new ScopeNotActiveException("Scope not active for service: " + descriptor.serviceType().fqName(), scope));
    }

    private Scope createScope(TypeName scopeType, Service.ScopeHandler scopeHandler, String id, Map<ServiceDescriptor<?>, Object> initialBindings) {
        ScopedRegistryImpl registry = new ScopedRegistryImpl(this, scopeType, id, initialBindings);
        ScopeImpl scope = new ScopeImpl(scopeType, scopeHandler, registry);
        scopeHandler.activate(scope);
        return scope;
    }

    private Service.ScopeHandler scopeHandler(TypeName scope) {
        this.scopeHandlerInstancesLock.lock();
        try {
            Service.ScopeHandler scopeHandler = this.scopeHandlerInstances.computeIfAbsent(scope, it -> {
                ServiceInfo serviceInfo = this.scopeHandlerServices.get(scope);
                if (serviceInfo == null) {
                    throw new ServiceRegistryException("There is no scope handler service registered for scope: " + scope.fqName());
                }
                ServiceManager<?> serviceManager = this.servicesByDescriptor.get(serviceInfo);
                return (Service.ScopeHandler)serviceManager.activator().instances(Lookup.EMPTY).orElseThrow(() -> new ServiceRegistryException("Scope handler service did not return any instance for: " + scope.fqName())).getFirst().get();
            });
            return scopeHandler;
        }
        finally {
            this.scopeHandlerInstancesLock.unlock();
        }
    }

    private record ScopeImpl(TypeName scopeType, Service.ScopeHandler handler, ScopedRegistry registry) implements Scope
    {
        @Override
        public void close() {
            this.handler.deactivate(this);
        }

        @Override
        public String toString() {
            return "Scope for " + this.scopeType.fqName();
        }
    }
}

