/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.identityconnectors.framework.impl.api.BufferedResultsProxy;
import org.identityconnectors.framework.impl.api.MethodTimeoutProxy;
import org.identityconnectors.framework.impl.api.StreamHandlerUtil;

public class DelegatingTimeoutProxy
implements InvocationHandler {
    private final Object _target;
    private final long _timeoutMillis;
    private final int _bufferSize;

    public DelegatingTimeoutProxy(Object target, long timeoutMillis, int bufferSize) {
        this._target = target;
        this._timeoutMillis = timeoutMillis;
        this._bufferSize = bufferSize;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this._target, args);
        }
        InvocationHandler handler = null;
        if (this.isStreamHandlerMethod(method)) {
            if (this._timeoutMillis != -1L || this._bufferSize != 0) {
                handler = new BufferedResultsProxy(this._target, this._bufferSize, this._timeoutMillis);
            }
        } else if (this._timeoutMillis != -1L) {
            handler = new MethodTimeoutProxy(this._target, this._timeoutMillis);
        }
        if (handler != null) {
            return handler.invoke(proxy, method, args);
        }
        try {
            return method.invoke(this._target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private boolean isStreamHandlerMethod(Method method) {
        for (Class<?> paramType : method.getParameterTypes()) {
            if (!StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType)) continue;
            return true;
        }
        return false;
    }
}

