/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.collections.undo;

import com.google.common.collect.Table;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.hyperledger.besu.collections.undo.Undoable;

public class UndoTable<R, C, V>
implements Table<R, C, V>,
Undoable {
    Table<R, C, V> delegate;
    List<UndoEntry<R, C, V>> undoLog;

    public static <R, C, V> UndoTable<R, C, V> of(Table<R, C, V> table) {
        return new UndoTable<R, C, V>(table);
    }

    protected UndoTable(Table<R, C, V> delegate) {
        this.delegate = delegate;
        this.undoLog = new ArrayList<UndoEntry<R, C, V>>();
    }

    @Override
    public void undo(long mark) {
        for (int pos = this.undoLog.size() - 1; pos >= 0 && this.undoLog.get((int)pos).level > mark; --pos) {
            UndoEntry<R, C, V> entry = this.undoLog.get(pos);
            this.undoLog.remove(pos);
            if (entry.value() == null) {
                this.delegate.remove(entry.row(), entry.column());
                continue;
            }
            this.delegate.put(entry.row(), entry.column(), entry.value());
        }
    }

    @Override
    public long lastUpdate() {
        return this.undoLog.isEmpty() ? 0L : this.undoLog.get((int)(this.undoLog.size() - 1)).level;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(Object rowKey, Object columnKey) {
        return this.delegate.contains(rowKey, columnKey);
    }

    public boolean containsRow(Object rowKey) {
        return this.delegate.containsRow(rowKey);
    }

    public boolean containsColumn(Object columnKey) {
        return this.delegate.containsColumn(columnKey);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @CheckForNull
    public V get(Object rowKey, Object columnKey) {
        return (V)this.delegate.get(rowKey, columnKey);
    }

    public void clear() {
        this.delegate.clear();
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public V put(R rowKey, C columnKey, V value) {
        Object oldV = this.delegate.put(rowKey, columnKey, value);
        this.undoLog.add(new UndoEntry<R, C, Object>(rowKey, columnKey, oldV));
        return (V)oldV;
    }

    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        for (Table.Cell cell : table.cellSet()) {
            Object newV = cell.getValue();
            Object oldV = this.delegate.put(cell.getRowKey(), cell.getColumnKey(), newV);
            if (Objects.equals(oldV, newV)) continue;
            this.undoLog.add(new UndoEntry<Object, Object, Object>(cell.getRowKey(), cell.getColumnKey(), oldV));
        }
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public V remove(Object rowKey, Object columnKey) {
        Object oldV = this.delegate.remove(rowKey, columnKey);
        this.undoLog.add(new UndoEntry<Object, Object, Object>(rowKey, columnKey, oldV));
        return (V)oldV;
    }

    public Map<C, V> row(R rowKey) {
        return Collections.unmodifiableMap(this.delegate.row(rowKey));
    }

    public Map<R, V> column(C columnKey) {
        return Collections.unmodifiableMap(this.delegate.column(columnKey));
    }

    public Set<Table.Cell<R, C, V>> cellSet() {
        return Collections.unmodifiableSet(this.delegate.cellSet());
    }

    public Set<R> rowKeySet() {
        return Collections.unmodifiableSet(this.delegate.rowKeySet());
    }

    public Set<C> columnKeySet() {
        return Collections.unmodifiableSet(this.delegate.columnKeySet());
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    public Map<R, Map<C, V>> rowMap() {
        return Collections.unmodifiableMap(this.delegate.rowMap());
    }

    public Map<C, Map<R, V>> columnMap() {
        return Collections.unmodifiableMap(this.delegate.columnMap());
    }

    public boolean equals(Object o) {
        return o instanceof UndoTable && this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode() ^ 0xDE1E647E;
    }

    record UndoEntry<R, C, V>(R row, C column, V value, long level) {
        UndoEntry(R row, C column, V value) {
            this(row, column, value, Undoable.incrementMarkStatic());
        }
    }
}

