/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public final class ConfigNumberUtils {
    private ConfigNumberUtils() {
    }

    public static <T extends Number> int compare(@NonNull T value, @NonNull Class<T> valueType, @NonNull Number number) {
        Objects.requireNonNull(value, "value must not be null");
        Objects.requireNonNull(valueType, "valueType must not be null");
        Objects.requireNonNull(number, "number must not be null");
        if (Objects.equals(valueType, Integer.class) || Objects.equals(valueType, Integer.TYPE)) {
            return Integer.compare(value.intValue(), number.intValue());
        }
        if (Objects.equals(valueType, Long.class) || Objects.equals(valueType, Long.TYPE)) {
            return Long.compare(value.longValue(), number.longValue());
        }
        if (Objects.equals(valueType, Double.class) || Objects.equals(valueType, Double.TYPE)) {
            return Double.compare(value.doubleValue(), number.doubleValue());
        }
        if (Objects.equals(valueType, Float.class) || Objects.equals(valueType, Float.TYPE)) {
            return Float.compare(value.floatValue(), number.floatValue());
        }
        if (Objects.equals(valueType, Short.class) || Objects.equals(valueType, Short.TYPE)) {
            return Short.compare(value.shortValue(), number.shortValue());
        }
        if (Objects.equals(valueType, Byte.class) || Objects.equals(valueType, Byte.TYPE)) {
            return Byte.compare(value.byteValue(), number.byteValue());
        }
        return 0;
    }

    public static long getLongValue(@NonNull Object value) {
        Objects.requireNonNull(value, "value must not be null");
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        throw new IllegalArgumentException("Not a valid number: " + String.valueOf(value));
    }

    public static boolean isNumber(@NonNull Class<?> cls) {
        Objects.requireNonNull(cls, "cls must not be null");
        if (Number.class.isAssignableFrom(cls)) {
            return true;
        }
        if (cls == Integer.TYPE) {
            return true;
        }
        if (cls == Long.TYPE) {
            return true;
        }
        if (cls == Double.TYPE) {
            return true;
        }
        if (cls == Float.TYPE) {
            return true;
        }
        if (cls == Short.TYPE) {
            return true;
        }
        return cls == Byte.TYPE;
    }
}

