/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.IntReference;

public final class CandidateWitness {
    private static final Logger logger = LogManager.getLogger(CandidateWitness.class);
    private final EventImpl witness;
    private final IntReference numUnknownFame;
    private final int electionIndex;
    private boolean decided;
    private boolean famous;

    public CandidateWitness(@NonNull EventImpl witness, @NonNull IntReference numUnknownFame, int electionIndex) {
        this.witness = Objects.requireNonNull(witness);
        this.numUnknownFame = Objects.requireNonNull(numUnknownFame);
        this.electionIndex = electionIndex;
        this.decided = false;
        this.famous = false;
    }

    @NonNull
    public EventImpl getWitness() {
        return this.witness;
    }

    public int getElectionIndex() {
        return this.electionIndex;
    }

    public boolean isDecided() {
        return this.decided;
    }

    public boolean isNotDecided() {
        return !this.decided;
    }

    public boolean isFamous() {
        return this.famous;
    }

    public void fameDecided(boolean isFamous) {
        this.witness.setFamous(isFamous);
        this.witness.setFameDecided(true);
        this.numUnknownFame.decrement();
        this.decided = true;
        this.famous = isFamous;
        if (logger.isDebugEnabled(LogMarker.CONSENSUS_VOTING.getMarker())) {
            logger.debug(LogMarker.CONSENSUS_VOTING.getMarker(), "Fame decided for {}, election round {} unknown fame: {} ", (Object)this.witness, (Object)this.witness.getRoundCreated(), (Object)this.numUnknownFame.get());
            if (this.numUnknownFame.equalsInt(0)) {
                logger.debug(LogMarker.CONSENSUS_VOTING.getMarker(), "Fame decided for round {}", (Object)this.witness.getRoundCreated());
            }
        }
    }
}

