/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.security.EncryptorFactory;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.serializer.AbstractObjectSerializationHandler;
import org.identityconnectors.framework.impl.serializer.ObjectDecoder;
import org.identityconnectors.framework.impl.serializer.ObjectEncoder;
import org.identityconnectors.framework.impl.serializer.ObjectTypeMapper;

class Primitives {
    public static final List<ObjectTypeMapper> HANDLERS = new ArrayList<ObjectTypeMapper>();

    Primitives() {
    }

    static {
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Boolean.class, "Boolean"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                boolean val = decoder.readBooleanContents();
                return val;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                boolean val = (Boolean)object;
                encoder.writeBooleanContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Boolean.TYPE, "boolean"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                boolean val = decoder.readBooleanContents();
                return val;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                boolean val = (Boolean)object;
                encoder.writeBooleanContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Character.class, "Character"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String val = decoder.readStringContents();
                return Character.valueOf(val.charAt(0));
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                Character val = (Character)object;
                encoder.writeStringContents(String.valueOf(val));
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Character.TYPE, "char"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String val = decoder.readStringContents();
                return Character.valueOf(val.charAt(0));
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                Character val = (Character)object;
                encoder.writeStringContents(String.valueOf(val));
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Integer.class, "Integer"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                int val = decoder.readIntContents();
                return val;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                int val = (Integer)object;
                encoder.writeIntContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Integer.TYPE, "int"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                int val = decoder.readIntContents();
                return val;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                int val = (Integer)object;
                encoder.writeIntContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Long.class, "Long"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                long val = decoder.readLongContents();
                return val;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                long val = (Long)object;
                encoder.writeLongContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Long.TYPE, "long"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                long val = decoder.readLongContents();
                return val;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                long val = (Long)object;
                encoder.writeLongContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Float.class, "Float"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                float val = decoder.readFloatContents();
                return Float.valueOf(val);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                float val = ((Float)object).floatValue();
                encoder.writeFloatContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Float.TYPE, "float"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                float val = decoder.readFloatContents();
                return Float.valueOf(val);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                float val = ((Float)object).floatValue();
                encoder.writeFloatContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Double.class, "Double"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                double val = decoder.readDoubleContents();
                return val;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                double val = (Double)object;
                encoder.writeDoubleContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Double.TYPE, "double"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                double val = decoder.readDoubleContents();
                return val;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                double val = (Double)object;
                encoder.writeDoubleContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)String.class, "String"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String val = decoder.readStringContents();
                return val;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                String val = (String)object;
                encoder.writeStringContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)URI.class, "URI"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String val = decoder.readStringContents();
                try {
                    return new URI(val);
                }
                catch (URISyntaxException e) {
                    throw ConnectorException.wrap((Throwable)e);
                }
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                URI val = (URI)object;
                encoder.writeStringContents(val.toString());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)File.class, "File"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String val = decoder.readStringContents();
                return new File(val);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                File val = (File)object;
                encoder.writeStringContents(val.getPath());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)BigDecimal.class, "BigDecimal"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                BigInteger unscaled = new BigInteger(decoder.readStringField("unscaled", null));
                int scale = decoder.readIntField("scale", 0);
                return new BigDecimal(unscaled, scale);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                BigDecimal val = (BigDecimal)object;
                encoder.writeStringField("unscaled", val.unscaledValue().toString());
                encoder.writeIntField("scale", val.scale());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)BigInteger.class, "BigInteger"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String val = decoder.readStringContents();
                return new BigInteger(val);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                BigInteger val = (BigInteger)object;
                encoder.writeStringContents(val.toString());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)byte[].class, "ByteArray"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                return decoder.readByteArrayContents();
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                byte[] val = (byte[])object;
                encoder.writeByteArrayContents(val);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Class.class, "Class"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                return decoder.readClassContents();
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                Class val = (Class)object;
                encoder.writeClassContents(val);
            }
        });
        class MapEntry {
            private Object key;
            private Object value;

            public MapEntry(Object key, Object value) {
                this.key = key;
                this.value = value;
            }
        }
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)MapEntry.class, "MapEntry"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                Object key = decoder.readObjectContents(0);
                Object value = decoder.readObjectContents(1);
                return new MapEntry(key, value);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                MapEntry entry = (MapEntry)object;
                encoder.writeObjectContents(entry.key);
                encoder.writeObjectContents(entry.value);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Map.class, "Map"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                boolean caseInsensitive = decoder.readBooleanField("caseInsensitive", false);
                if (caseInsensitive) {
                    SortedMap rv = CollectionUtil.newCaseInsensitiveMap();
                    int count = decoder.getNumSubObjects();
                    for (int i = 0; i < count; ++i) {
                        MapEntry entry = (MapEntry)decoder.readObjectContents(i);
                        rv.put(String.valueOf(entry.key), entry.value);
                    }
                    return rv;
                }
                HashMap<Object, Object> rv = new HashMap<Object, Object>();
                int count = decoder.getNumSubObjects();
                for (int i = 0; i < count; ++i) {
                    MapEntry entry = (MapEntry)decoder.readObjectContents(i);
                    rv.put(entry.key, entry.value);
                }
                return rv;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                Map map = (Map)object;
                if (CollectionUtil.isCaseInsensitiveMap((Map)map)) {
                    encoder.writeBooleanField("caseInsensitive", true);
                } else if (map instanceof SortedMap) {
                    throw new IllegalArgumentException("Serialization of SortedMap not supported");
                }
                for (Map.Entry entry : map.entrySet()) {
                    MapEntry myEntry = new MapEntry(entry.getKey(), entry.getValue());
                    encoder.writeObjectContents(myEntry);
                }
            }

            @Override
            public boolean getMatchSubclasses() {
                return true;
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)List.class, "List"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                ArrayList<Object> rv = new ArrayList<Object>();
                int count = decoder.getNumSubObjects();
                for (int i = 0; i < count; ++i) {
                    Object obj = decoder.readObjectContents(i);
                    rv.add(obj);
                }
                return rv;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                List list = (List)object;
                for (Object obj : list) {
                    encoder.writeObjectContents(obj);
                }
            }

            @Override
            public boolean getMatchSubclasses() {
                return true;
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Set.class, "Set"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                boolean caseInsensitive = decoder.readBooleanField("caseInsensitive", false);
                if (caseInsensitive) {
                    SortedSet rv = CollectionUtil.newCaseInsensitiveSet();
                    int count = decoder.getNumSubObjects();
                    for (int i = 0; i < count; ++i) {
                        String str = String.valueOf(decoder.readObjectContents(i));
                        rv.add(str);
                    }
                    return rv;
                }
                HashSet<Object> rv = new HashSet<Object>();
                int count = decoder.getNumSubObjects();
                for (int i = 0; i < count; ++i) {
                    Object obj = decoder.readObjectContents(i);
                    rv.add(obj);
                }
                return rv;
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                Set set = (Set)object;
                if (CollectionUtil.isCaseInsensitiveSet((Set)set)) {
                    encoder.writeBooleanField("caseInsensitive", true);
                } else if (set instanceof SortedSet) {
                    throw new IllegalArgumentException("Serialization of SortedSet not supported");
                }
                for (Object obj : set) {
                    encoder.writeObjectContents(obj);
                }
            }

            @Override
            public boolean getMatchSubclasses() {
                return true;
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)Locale.class, "Locale"){

            @Override
            public Object deserialize(ObjectDecoder decoder) {
                String language = decoder.readStringField("language", "");
                String country = decoder.readStringField("country", "");
                String variant = decoder.readStringField("variant", "");
                return new Locale(language, country, variant);
            }

            @Override
            public void serialize(Object object, ObjectEncoder encoder) {
                Locale locale = (Locale)object;
                encoder.writeStringField("language", locale.getLanguage());
                encoder.writeStringField("country", locale.getCountry());
                encoder.writeStringField("variant", locale.getVariant());
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)GuardedString.class, "GuardedString"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object deserialize(ObjectDecoder decoder) {
                GuardedString guardedString;
                byte[] encryptedBytes = null;
                byte[] clearBytes = null;
                char[] clearChars = null;
                try {
                    encryptedBytes = decoder.readByteArrayContents();
                    clearBytes = EncryptorFactory.getInstance().getDefaultEncryptor().decrypt(encryptedBytes);
                    clearChars = SecurityUtil.bytesToChars((byte[])clearBytes);
                    guardedString = new GuardedString(clearChars);
                }
                catch (Throwable throwable) {
                    SecurityUtil.clear((byte[])encryptedBytes);
                    SecurityUtil.clear(clearBytes);
                    SecurityUtil.clear(clearChars);
                    throw throwable;
                }
                SecurityUtil.clear((byte[])encryptedBytes);
                SecurityUtil.clear((byte[])clearBytes);
                SecurityUtil.clear((char[])clearChars);
                return guardedString;
            }

            @Override
            public void serialize(Object object, final ObjectEncoder encoder) {
                GuardedString val = (GuardedString)object;
                val.access(new GuardedString.Accessor(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void access(char[] clearChars) {
                        byte[] encryptedBytes = null;
                        byte[] clearBytes = null;
                        try {
                            clearBytes = SecurityUtil.charsToBytes((char[])clearChars);
                            encryptedBytes = EncryptorFactory.getInstance().getDefaultEncryptor().encrypt(clearBytes);
                            encoder.writeByteArrayContents(encryptedBytes);
                        }
                        catch (Throwable throwable) {
                            SecurityUtil.clear(encryptedBytes);
                            SecurityUtil.clear((byte[])clearBytes);
                            throw throwable;
                        }
                        SecurityUtil.clear((byte[])encryptedBytes);
                        SecurityUtil.clear((byte[])clearBytes);
                    }
                });
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)GuardedByteArray.class, "GuardedByteArray"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object deserialize(ObjectDecoder decoder) {
                GuardedByteArray guardedByteArray;
                byte[] encryptedBytes = null;
                byte[] clearBytes = null;
                try {
                    encryptedBytes = decoder.readByteArrayContents();
                    clearBytes = EncryptorFactory.getInstance().getDefaultEncryptor().decrypt(encryptedBytes);
                    guardedByteArray = new GuardedByteArray(clearBytes);
                }
                catch (Throwable throwable) {
                    SecurityUtil.clear((byte[])encryptedBytes);
                    SecurityUtil.clear(clearBytes);
                    throw throwable;
                }
                SecurityUtil.clear((byte[])encryptedBytes);
                SecurityUtil.clear((byte[])clearBytes);
                return guardedByteArray;
            }

            @Override
            public void serialize(Object object, final ObjectEncoder encoder) {
                GuardedByteArray val = (GuardedByteArray)object;
                val.access(new GuardedByteArray.Accessor(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void access(byte[] clearBytes) {
                        byte[] encryptedBytes = null;
                        try {
                            encryptedBytes = EncryptorFactory.getInstance().getDefaultEncryptor().encrypt(clearBytes);
                            encoder.writeByteArrayContents(encryptedBytes);
                        }
                        catch (Throwable throwable) {
                            SecurityUtil.clear(encryptedBytes);
                            throw throwable;
                        }
                        SecurityUtil.clear((byte[])encryptedBytes);
                    }
                });
            }
        });
    }
}

