/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.codec.TokenJsonCodec;
import com.hedera.hapi.node.state.token.codec.TokenProtoCodec;
import com.hedera.hapi.node.state.token.schema.TokenSchema;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class Token {
    public static final Codec<Token> PROTOBUF = new TokenProtoCodec();
    public static final JsonCodec<Token> JSON = new TokenJsonCodec();
    public static final Token DEFAULT = Token.newBuilder().build();
    @Nullable
    private final TokenID tokenId;
    @NonNull
    private final String name;
    @NonNull
    private final String symbol;
    private final int decimals;
    private final long totalSupply;
    @Nullable
    private final AccountID treasuryAccountId;
    @Nullable
    private final Key adminKey;
    @Nullable
    private final Key kycKey;
    @Nullable
    private final Key freezeKey;
    @Nullable
    private final Key wipeKey;
    @Nullable
    private final Key supplyKey;
    @Nullable
    private final Key feeScheduleKey;
    @Nullable
    private final Key pauseKey;
    private final long lastUsedSerialNumber;
    private final boolean deleted;
    private final TokenType tokenType;
    private final TokenSupplyType supplyType;
    @Nullable
    private final AccountID autoRenewAccountId;
    private final long autoRenewSeconds;
    private final long expirationSecond;
    @NonNull
    private final String memo;
    private final long maxSupply;
    private final boolean paused;
    private final boolean accountsFrozenByDefault;
    private final boolean accountsKycGrantedByDefault;
    @NonNull
    private final List<CustomFee> customFees;
    @NonNull
    private final Bytes metadata;
    @Nullable
    private final Key metadataKey;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public Token(TokenID tokenId, String name, String symbol, int decimals, long totalSupply, AccountID treasuryAccountId, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, Key feeScheduleKey, Key pauseKey, long lastUsedSerialNumber, boolean deleted, TokenType tokenType, TokenSupplyType supplyType, AccountID autoRenewAccountId, long autoRenewSeconds, long expirationSecond, String memo, long maxSupply, boolean paused, boolean accountsFrozenByDefault, boolean accountsKycGrantedByDefault, List<CustomFee> customFees, Bytes metadata, Key metadataKey) {
        this.$unknownFields = null;
        this.tokenId = tokenId;
        this.name = name != null ? name : "";
        this.symbol = symbol != null ? symbol : "";
        this.decimals = decimals;
        this.totalSupply = totalSupply;
        this.treasuryAccountId = treasuryAccountId;
        this.adminKey = adminKey;
        this.kycKey = kycKey;
        this.freezeKey = freezeKey;
        this.wipeKey = wipeKey;
        this.supplyKey = supplyKey;
        this.feeScheduleKey = feeScheduleKey;
        this.pauseKey = pauseKey;
        this.lastUsedSerialNumber = lastUsedSerialNumber;
        this.deleted = deleted;
        this.tokenType = tokenType;
        this.supplyType = supplyType;
        this.autoRenewAccountId = autoRenewAccountId;
        this.autoRenewSeconds = autoRenewSeconds;
        this.expirationSecond = expirationSecond;
        this.memo = memo != null ? memo : "";
        this.maxSupply = maxSupply;
        this.paused = paused;
        this.accountsFrozenByDefault = accountsFrozenByDefault;
        this.accountsKycGrantedByDefault = accountsKycGrantedByDefault;
        this.customFees = customFees == null ? Collections.emptyList() : customFees;
        this.metadata = metadata != null ? metadata : Bytes.EMPTY;
        this.metadataKey = metadataKey;
    }

    public Token(TokenID tokenId, String name, String symbol, int decimals, long totalSupply, AccountID treasuryAccountId, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, Key feeScheduleKey, Key pauseKey, long lastUsedSerialNumber, boolean deleted, TokenType tokenType, TokenSupplyType supplyType, AccountID autoRenewAccountId, long autoRenewSeconds, long expirationSecond, String memo, long maxSupply, boolean paused, boolean accountsFrozenByDefault, boolean accountsKycGrantedByDefault, List<CustomFee> customFees, Bytes metadata, Key metadataKey, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.tokenId = tokenId;
        this.name = name != null ? name : "";
        this.symbol = symbol != null ? symbol : "";
        this.decimals = decimals;
        this.totalSupply = totalSupply;
        this.treasuryAccountId = treasuryAccountId;
        this.adminKey = adminKey;
        this.kycKey = kycKey;
        this.freezeKey = freezeKey;
        this.wipeKey = wipeKey;
        this.supplyKey = supplyKey;
        this.feeScheduleKey = feeScheduleKey;
        this.pauseKey = pauseKey;
        this.lastUsedSerialNumber = lastUsedSerialNumber;
        this.deleted = deleted;
        this.tokenType = tokenType;
        this.supplyType = supplyType;
        this.autoRenewAccountId = autoRenewAccountId;
        this.autoRenewSeconds = autoRenewSeconds;
        this.expirationSecond = expirationSecond;
        this.memo = memo != null ? memo : "";
        this.maxSupply = maxSupply;
        this.paused = paused;
        this.accountsFrozenByDefault = accountsFrozenByDefault;
        this.accountsKycGrantedByDefault = accountsKycGrantedByDefault;
        this.customFees = customFees == null ? Collections.emptyList() : customFees;
        this.metadata = metadata != null ? metadata : Bytes.EMPTY;
        this.metadataKey = metadataKey;
    }

    public TokenID tokenId() {
        return this.tokenId;
    }

    public String name() {
        return this.name;
    }

    public String symbol() {
        return this.symbol;
    }

    public int decimals() {
        return this.decimals;
    }

    public long totalSupply() {
        return this.totalSupply;
    }

    public AccountID treasuryAccountId() {
        return this.treasuryAccountId;
    }

    public Key adminKey() {
        return this.adminKey;
    }

    public Key kycKey() {
        return this.kycKey;
    }

    public Key freezeKey() {
        return this.freezeKey;
    }

    public Key wipeKey() {
        return this.wipeKey;
    }

    public Key supplyKey() {
        return this.supplyKey;
    }

    public Key feeScheduleKey() {
        return this.feeScheduleKey;
    }

    public Key pauseKey() {
        return this.pauseKey;
    }

    public long lastUsedSerialNumber() {
        return this.lastUsedSerialNumber;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public TokenType tokenType() {
        return this.tokenType;
    }

    public TokenSupplyType supplyType() {
        return this.supplyType;
    }

    public AccountID autoRenewAccountId() {
        return this.autoRenewAccountId;
    }

    public long autoRenewSeconds() {
        return this.autoRenewSeconds;
    }

    public long expirationSecond() {
        return this.expirationSecond;
    }

    public String memo() {
        return this.memo;
    }

    public long maxSupply() {
        return this.maxSupply;
    }

    public boolean paused() {
        return this.paused;
    }

    public boolean accountsFrozenByDefault() {
        return this.accountsFrozenByDefault;
    }

    public boolean accountsKycGrantedByDefault() {
        return this.accountsKycGrantedByDefault;
    }

    public List<CustomFee> customFees() {
        return this.customFees;
    }

    public Bytes metadata() {
        return this.metadata;
    }

    public Key metadataKey() {
        return this.metadataKey;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.TOKEN_ID, (Object)this.tokenId, TokenID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenSchema.NAME, (String)this.name, (boolean)true);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenSchema.SYMBOL, (String)this.symbol, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)TokenSchema.DECIMALS, (int)this.decimals, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenSchema.TOTAL_SUPPLY, (long)this.totalSupply, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.TREASURY_ACCOUNT_ID, (Object)this.treasuryAccountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.ADMIN_KEY, (Object)this.adminKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.KYC_KEY, (Object)this.kycKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.FREEZE_KEY, (Object)this.freezeKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.WIPE_KEY, (Object)this.wipeKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.SUPPLY_KEY, (Object)this.supplyKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.FEE_SCHEDULE_KEY, (Object)this.feeScheduleKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.PAUSE_KEY, (Object)this.pauseKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenSchema.LAST_USED_SERIAL_NUMBER, (long)this.lastUsedSerialNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TokenSchema.DELETED, (boolean)this.deleted, (boolean)true);
            _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenSchema.TOKEN_TYPE, (EnumWithProtoMetadata)this.tokenType);
            _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenSchema.SUPPLY_TYPE, (EnumWithProtoMetadata)this.supplyType);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.AUTO_RENEW_ACCOUNT_ID, (Object)this.autoRenewAccountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenSchema.AUTO_RENEW_SECONDS, (long)this.autoRenewSeconds, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenSchema.EXPIRATION_SECOND, (long)this.expirationSecond, (boolean)true);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenSchema.MEMO, (String)this.memo, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenSchema.MAX_SUPPLY, (long)this.maxSupply, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TokenSchema.PAUSED, (boolean)this.paused, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TokenSchema.ACCOUNTS_FROZEN_BY_DEFAULT, (boolean)this.accountsFrozenByDefault, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TokenSchema.ACCOUNTS_KYC_GRANTED_BY_DEFAULT, (boolean)this.accountsKycGrantedByDefault, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TokenSchema.CUSTOM_FEES, this.customFees, CustomFee.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TokenSchema.METADATA, (RandomAccessData)this.metadata, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.METADATA_KEY, (Object)this.metadataKey, Key.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            List<CustomFee> list$customFees;
            int result = 1;
            if (this.tokenId != null && !this.tokenId.equals(Token.DEFAULT.tokenId)) {
                result = 31 * result + this.tokenId.hashCode();
            }
            if (this.name != null && !this.name.equals(Token.DEFAULT.name)) {
                result = 31 * result + this.name.hashCode();
            }
            if (this.symbol != null && !this.symbol.equals(Token.DEFAULT.symbol)) {
                result = 31 * result + this.symbol.hashCode();
            }
            if (this.decimals != Token.DEFAULT.decimals) {
                result = 31 * result + Integer.hashCode(this.decimals);
            }
            if (this.totalSupply != Token.DEFAULT.totalSupply) {
                result = 31 * result + Long.hashCode(this.totalSupply);
            }
            if (this.treasuryAccountId != null && !this.treasuryAccountId.equals(Token.DEFAULT.treasuryAccountId)) {
                result = 31 * result + this.treasuryAccountId.hashCode();
            }
            if (this.adminKey != null && !this.adminKey.equals(Token.DEFAULT.adminKey)) {
                result = 31 * result + this.adminKey.hashCode();
            }
            if (this.kycKey != null && !this.kycKey.equals(Token.DEFAULT.kycKey)) {
                result = 31 * result + this.kycKey.hashCode();
            }
            if (this.freezeKey != null && !this.freezeKey.equals(Token.DEFAULT.freezeKey)) {
                result = 31 * result + this.freezeKey.hashCode();
            }
            if (this.wipeKey != null && !this.wipeKey.equals(Token.DEFAULT.wipeKey)) {
                result = 31 * result + this.wipeKey.hashCode();
            }
            if (this.supplyKey != null && !this.supplyKey.equals(Token.DEFAULT.supplyKey)) {
                result = 31 * result + this.supplyKey.hashCode();
            }
            if (this.feeScheduleKey != null && !this.feeScheduleKey.equals(Token.DEFAULT.feeScheduleKey)) {
                result = 31 * result + this.feeScheduleKey.hashCode();
            }
            if (this.pauseKey != null && !this.pauseKey.equals(Token.DEFAULT.pauseKey)) {
                result = 31 * result + this.pauseKey.hashCode();
            }
            if (this.lastUsedSerialNumber != Token.DEFAULT.lastUsedSerialNumber) {
                result = 31 * result + Long.hashCode(this.lastUsedSerialNumber);
            }
            if (this.deleted != Token.DEFAULT.deleted) {
                result = 31 * result + Boolean.hashCode(this.deleted);
            }
            if (this.tokenType != null && !this.tokenType.equals((Object)Token.DEFAULT.tokenType)) {
                result = 31 * result + Integer.hashCode(this.tokenType.protoOrdinal());
            }
            if (this.supplyType != null && !this.supplyType.equals((Object)Token.DEFAULT.supplyType)) {
                result = 31 * result + Integer.hashCode(this.supplyType.protoOrdinal());
            }
            if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(Token.DEFAULT.autoRenewAccountId)) {
                result = 31 * result + this.autoRenewAccountId.hashCode();
            }
            if (this.autoRenewSeconds != Token.DEFAULT.autoRenewSeconds) {
                result = 31 * result + Long.hashCode(this.autoRenewSeconds);
            }
            if (this.expirationSecond != Token.DEFAULT.expirationSecond) {
                result = 31 * result + Long.hashCode(this.expirationSecond);
            }
            if (this.memo != null && !this.memo.equals(Token.DEFAULT.memo)) {
                result = 31 * result + this.memo.hashCode();
            }
            if (this.maxSupply != Token.DEFAULT.maxSupply) {
                result = 31 * result + Long.hashCode(this.maxSupply);
            }
            if (this.paused != Token.DEFAULT.paused) {
                result = 31 * result + Boolean.hashCode(this.paused);
            }
            if (this.accountsFrozenByDefault != Token.DEFAULT.accountsFrozenByDefault) {
                result = 31 * result + Boolean.hashCode(this.accountsFrozenByDefault);
            }
            if (this.accountsKycGrantedByDefault != Token.DEFAULT.accountsKycGrantedByDefault) {
                result = 31 * result + Boolean.hashCode(this.accountsKycGrantedByDefault);
            }
            if ((list$customFees = this.customFees) != null) {
                for (CustomFee o : list$customFees) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.metadata != null && !this.metadata.equals((Object)Token.DEFAULT.metadata)) {
                result = 31 * result + this.metadata.hashCode();
            }
            if (this.metadataKey != null && !this.metadataKey.equals(Token.DEFAULT.metadataKey)) {
                result = 31 * result + this.metadataKey.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Token thatObj = (Token)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        if (this.name == null && thatObj.name != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(thatObj.name)) {
            return false;
        }
        if (this.symbol == null && thatObj.symbol != null) {
            return false;
        }
        if (this.symbol != null && !this.symbol.equals(thatObj.symbol)) {
            return false;
        }
        if (this.decimals != thatObj.decimals) {
            return false;
        }
        if (this.totalSupply != thatObj.totalSupply) {
            return false;
        }
        if (this.treasuryAccountId == null && thatObj.treasuryAccountId != null) {
            return false;
        }
        if (this.treasuryAccountId != null && !this.treasuryAccountId.equals(thatObj.treasuryAccountId)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.kycKey == null && thatObj.kycKey != null) {
            return false;
        }
        if (this.kycKey != null && !this.kycKey.equals(thatObj.kycKey)) {
            return false;
        }
        if (this.freezeKey == null && thatObj.freezeKey != null) {
            return false;
        }
        if (this.freezeKey != null && !this.freezeKey.equals(thatObj.freezeKey)) {
            return false;
        }
        if (this.wipeKey == null && thatObj.wipeKey != null) {
            return false;
        }
        if (this.wipeKey != null && !this.wipeKey.equals(thatObj.wipeKey)) {
            return false;
        }
        if (this.supplyKey == null && thatObj.supplyKey != null) {
            return false;
        }
        if (this.supplyKey != null && !this.supplyKey.equals(thatObj.supplyKey)) {
            return false;
        }
        if (this.feeScheduleKey == null && thatObj.feeScheduleKey != null) {
            return false;
        }
        if (this.feeScheduleKey != null && !this.feeScheduleKey.equals(thatObj.feeScheduleKey)) {
            return false;
        }
        if (this.pauseKey == null && thatObj.pauseKey != null) {
            return false;
        }
        if (this.pauseKey != null && !this.pauseKey.equals(thatObj.pauseKey)) {
            return false;
        }
        if (this.lastUsedSerialNumber != thatObj.lastUsedSerialNumber) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.tokenType == null && thatObj.tokenType != null) {
            return false;
        }
        if (this.tokenType != null && !this.tokenType.equals((Object)thatObj.tokenType)) {
            return false;
        }
        if (this.supplyType == null && thatObj.supplyType != null) {
            return false;
        }
        if (this.supplyType != null && !this.supplyType.equals((Object)thatObj.supplyType)) {
            return false;
        }
        if (this.autoRenewAccountId == null && thatObj.autoRenewAccountId != null) {
            return false;
        }
        if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(thatObj.autoRenewAccountId)) {
            return false;
        }
        if (this.autoRenewSeconds != thatObj.autoRenewSeconds) {
            return false;
        }
        if (this.expirationSecond != thatObj.expirationSecond) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.maxSupply != thatObj.maxSupply) {
            return false;
        }
        if (this.paused != thatObj.paused) {
            return false;
        }
        if (this.accountsFrozenByDefault != thatObj.accountsFrozenByDefault) {
            return false;
        }
        if (this.accountsKycGrantedByDefault != thatObj.accountsKycGrantedByDefault) {
            return false;
        }
        if (this.customFees == null && thatObj.customFees != null) {
            return false;
        }
        if (this.customFees != null && !this.customFees.equals(thatObj.customFees)) {
            return false;
        }
        if (this.metadata == null && thatObj.metadata != null) {
            return false;
        }
        if (this.metadata != null && !this.metadata.equals((Object)thatObj.metadata)) {
            return false;
        }
        if (this.metadataKey == null && thatObj.metadataKey != null) {
            return false;
        }
        if (this.metadataKey != null && !this.metadataKey.equals(thatObj.metadataKey)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "Token[tokenId=" + String.valueOf(this.tokenId) + ", name=" + this.name + ", symbol=" + this.symbol + ", decimals=" + this.decimals + ", totalSupply=" + this.totalSupply + ", treasuryAccountId=" + String.valueOf(this.treasuryAccountId) + ", adminKey=" + String.valueOf(this.adminKey) + ", kycKey=" + String.valueOf(this.kycKey) + ", freezeKey=" + String.valueOf(this.freezeKey) + ", wipeKey=" + String.valueOf(this.wipeKey) + ", supplyKey=" + String.valueOf(this.supplyKey) + ", feeScheduleKey=" + String.valueOf(this.feeScheduleKey) + ", pauseKey=" + String.valueOf(this.pauseKey) + ", lastUsedSerialNumber=" + this.lastUsedSerialNumber + ", deleted=" + this.deleted + ", tokenType=" + String.valueOf((Object)this.tokenType) + ", supplyType=" + String.valueOf((Object)this.supplyType) + ", autoRenewAccountId=" + String.valueOf(this.autoRenewAccountId) + ", autoRenewSeconds=" + this.autoRenewSeconds + ", expirationSecond=" + this.expirationSecond + ", memo=" + this.memo + ", maxSupply=" + this.maxSupply + ", paused=" + this.paused + ", accountsFrozenByDefault=" + this.accountsFrozenByDefault + ", accountsKycGrantedByDefault=" + this.accountsKycGrantedByDefault + ", customFees=" + String.valueOf(this.customFees) + ", metadata=" + String.valueOf(this.metadata) + ", metadataKey=" + String.valueOf(this.metadataKey) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasTreasuryAccountId() {
        return this.treasuryAccountId != null;
    }

    public AccountID treasuryAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasTreasuryAccountId() ? this.treasuryAccountId : defaultValue;
    }

    @NonNull
    public AccountID treasuryAccountIdOrThrow() {
        return Objects.requireNonNull(this.treasuryAccountId, "Field treasuryAccountId is null");
    }

    public void ifTreasuryAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasTreasuryAccountId()) {
            ifPresent.accept(this.treasuryAccountId);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasKycKey() {
        return this.kycKey != null;
    }

    public Key kycKeyOrElse(@NonNull Key defaultValue) {
        return this.hasKycKey() ? this.kycKey : defaultValue;
    }

    @NonNull
    public Key kycKeyOrThrow() {
        return Objects.requireNonNull(this.kycKey, "Field kycKey is null");
    }

    public void ifKycKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasKycKey()) {
            ifPresent.accept(this.kycKey);
        }
    }

    public boolean hasFreezeKey() {
        return this.freezeKey != null;
    }

    public Key freezeKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFreezeKey() ? this.freezeKey : defaultValue;
    }

    @NonNull
    public Key freezeKeyOrThrow() {
        return Objects.requireNonNull(this.freezeKey, "Field freezeKey is null");
    }

    public void ifFreezeKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFreezeKey()) {
            ifPresent.accept(this.freezeKey);
        }
    }

    public boolean hasWipeKey() {
        return this.wipeKey != null;
    }

    public Key wipeKeyOrElse(@NonNull Key defaultValue) {
        return this.hasWipeKey() ? this.wipeKey : defaultValue;
    }

    @NonNull
    public Key wipeKeyOrThrow() {
        return Objects.requireNonNull(this.wipeKey, "Field wipeKey is null");
    }

    public void ifWipeKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasWipeKey()) {
            ifPresent.accept(this.wipeKey);
        }
    }

    public boolean hasSupplyKey() {
        return this.supplyKey != null;
    }

    public Key supplyKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSupplyKey() ? this.supplyKey : defaultValue;
    }

    @NonNull
    public Key supplyKeyOrThrow() {
        return Objects.requireNonNull(this.supplyKey, "Field supplyKey is null");
    }

    public void ifSupplyKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSupplyKey()) {
            ifPresent.accept(this.supplyKey);
        }
    }

    public boolean hasFeeScheduleKey() {
        return this.feeScheduleKey != null;
    }

    public Key feeScheduleKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFeeScheduleKey() ? this.feeScheduleKey : defaultValue;
    }

    @NonNull
    public Key feeScheduleKeyOrThrow() {
        return Objects.requireNonNull(this.feeScheduleKey, "Field feeScheduleKey is null");
    }

    public void ifFeeScheduleKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFeeScheduleKey()) {
            ifPresent.accept(this.feeScheduleKey);
        }
    }

    public boolean hasPauseKey() {
        return this.pauseKey != null;
    }

    public Key pauseKeyOrElse(@NonNull Key defaultValue) {
        return this.hasPauseKey() ? this.pauseKey : defaultValue;
    }

    @NonNull
    public Key pauseKeyOrThrow() {
        return Objects.requireNonNull(this.pauseKey, "Field pauseKey is null");
    }

    public void ifPauseKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasPauseKey()) {
            ifPresent.accept(this.pauseKey);
        }
    }

    public boolean hasAutoRenewAccountId() {
        return this.autoRenewAccountId != null;
    }

    public AccountID autoRenewAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccountId() ? this.autoRenewAccountId : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountIdOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccountId, "Field autoRenewAccountId is null");
    }

    public void ifAutoRenewAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccountId()) {
            ifPresent.accept(this.autoRenewAccountId);
        }
    }

    public boolean hasMetadataKey() {
        return this.metadataKey != null;
    }

    public Key metadataKeyOrElse(@NonNull Key defaultValue) {
        return this.hasMetadataKey() ? this.metadataKey : defaultValue;
    }

    @NonNull
    public Key metadataKeyOrThrow() {
        return Objects.requireNonNull(this.metadataKey, "Field metadataKey is null");
    }

    public void ifMetadataKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasMetadataKey()) {
            ifPresent.accept(this.metadataKey);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.name, this.symbol, this.decimals, this.totalSupply, this.treasuryAccountId, this.adminKey, this.kycKey, this.freezeKey, this.wipeKey, this.supplyKey, this.feeScheduleKey, this.pauseKey, this.lastUsedSerialNumber, this.deleted, this.tokenType, this.supplyType, this.autoRenewAccountId, this.autoRenewSeconds, this.expirationSecond, this.memo, this.maxSupply, this.paused, this.accountsFrozenByDefault, this.accountsKycGrantedByDefault, this.customFees, this.metadata, this.metadataKey, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TokenID tokenId = null;
        @NonNull
        private String name = "";
        @NonNull
        private String symbol = "";
        private int decimals = 0;
        private long totalSupply = 0L;
        @Nullable
        private AccountID treasuryAccountId = null;
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Key kycKey = null;
        @Nullable
        private Key freezeKey = null;
        @Nullable
        private Key wipeKey = null;
        @Nullable
        private Key supplyKey = null;
        @Nullable
        private Key feeScheduleKey = null;
        @Nullable
        private Key pauseKey = null;
        private long lastUsedSerialNumber = 0L;
        private boolean deleted = false;
        private TokenType tokenType = TokenType.fromProtobufOrdinal(0);
        private TokenSupplyType supplyType = TokenSupplyType.fromProtobufOrdinal(0);
        @Nullable
        private AccountID autoRenewAccountId = null;
        private long autoRenewSeconds = 0L;
        private long expirationSecond = 0L;
        @NonNull
        private String memo = "";
        private long maxSupply = 0L;
        private boolean paused = false;
        private boolean accountsFrozenByDefault = false;
        private boolean accountsKycGrantedByDefault = false;
        @NonNull
        private List<CustomFee> customFees = Collections.emptyList();
        @NonNull
        private Bytes metadata = Bytes.EMPTY;
        @Nullable
        private Key metadataKey = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(TokenID tokenId, String name, String symbol, int decimals, long totalSupply, AccountID treasuryAccountId, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, Key feeScheduleKey, Key pauseKey, long lastUsedSerialNumber, boolean deleted, TokenType tokenType, TokenSupplyType supplyType, AccountID autoRenewAccountId, long autoRenewSeconds, long expirationSecond, String memo, long maxSupply, boolean paused, boolean accountsFrozenByDefault, boolean accountsKycGrantedByDefault, List<CustomFee> customFees, Bytes metadata, Key metadataKey) {
            this.$unknownFields = null;
            this.tokenId = tokenId;
            this.name = name != null ? name : "";
            this.symbol = symbol != null ? symbol : "";
            this.decimals = decimals;
            this.totalSupply = totalSupply;
            this.treasuryAccountId = treasuryAccountId;
            this.adminKey = adminKey;
            this.kycKey = kycKey;
            this.freezeKey = freezeKey;
            this.wipeKey = wipeKey;
            this.supplyKey = supplyKey;
            this.feeScheduleKey = feeScheduleKey;
            this.pauseKey = pauseKey;
            this.lastUsedSerialNumber = lastUsedSerialNumber;
            this.deleted = deleted;
            this.tokenType = tokenType;
            this.supplyType = supplyType;
            this.autoRenewAccountId = autoRenewAccountId;
            this.autoRenewSeconds = autoRenewSeconds;
            this.expirationSecond = expirationSecond;
            this.memo = memo != null ? memo : "";
            this.maxSupply = maxSupply;
            this.paused = paused;
            this.accountsFrozenByDefault = accountsFrozenByDefault;
            this.accountsKycGrantedByDefault = accountsKycGrantedByDefault;
            this.customFees = customFees == null ? Collections.emptyList() : customFees;
            this.metadata = metadata != null ? metadata : Bytes.EMPTY;
            this.metadataKey = metadataKey;
        }

        public Builder(TokenID tokenId, String name, String symbol, int decimals, long totalSupply, AccountID treasuryAccountId, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, Key feeScheduleKey, Key pauseKey, long lastUsedSerialNumber, boolean deleted, TokenType tokenType, TokenSupplyType supplyType, AccountID autoRenewAccountId, long autoRenewSeconds, long expirationSecond, String memo, long maxSupply, boolean paused, boolean accountsFrozenByDefault, boolean accountsKycGrantedByDefault, List<CustomFee> customFees, Bytes metadata, Key metadataKey, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.tokenId = tokenId;
            this.name = name != null ? name : "";
            this.symbol = symbol != null ? symbol : "";
            this.decimals = decimals;
            this.totalSupply = totalSupply;
            this.treasuryAccountId = treasuryAccountId;
            this.adminKey = adminKey;
            this.kycKey = kycKey;
            this.freezeKey = freezeKey;
            this.wipeKey = wipeKey;
            this.supplyKey = supplyKey;
            this.feeScheduleKey = feeScheduleKey;
            this.pauseKey = pauseKey;
            this.lastUsedSerialNumber = lastUsedSerialNumber;
            this.deleted = deleted;
            this.tokenType = tokenType;
            this.supplyType = supplyType;
            this.autoRenewAccountId = autoRenewAccountId;
            this.autoRenewSeconds = autoRenewSeconds;
            this.expirationSecond = expirationSecond;
            this.memo = memo != null ? memo : "";
            this.maxSupply = maxSupply;
            this.paused = paused;
            this.accountsFrozenByDefault = accountsFrozenByDefault;
            this.accountsKycGrantedByDefault = accountsKycGrantedByDefault;
            this.customFees = customFees == null ? Collections.emptyList() : customFees;
            this.metadata = metadata != null ? metadata : Bytes.EMPTY;
            this.metadataKey = metadataKey;
        }

        public Token build() {
            return new Token(this.tokenId, this.name, this.symbol, this.decimals, this.totalSupply, this.treasuryAccountId, this.adminKey, this.kycKey, this.freezeKey, this.wipeKey, this.supplyKey, this.feeScheduleKey, this.pauseKey, this.lastUsedSerialNumber, this.deleted, this.tokenType, this.supplyType, this.autoRenewAccountId, this.autoRenewSeconds, this.expirationSecond, this.memo, this.maxSupply, this.paused, this.accountsFrozenByDefault, this.accountsKycGrantedByDefault, this.customFees, this.metadata, this.metadataKey);
        }

        public Builder tokenId(@Nullable TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder name(@NonNull String name) {
            this.name = name != null ? name : "";
            return this;
        }

        public Builder symbol(@NonNull String symbol) {
            this.symbol = symbol != null ? symbol : "";
            return this;
        }

        public Builder decimals(int decimals) {
            this.decimals = decimals;
            return this;
        }

        public Builder totalSupply(long totalSupply) {
            this.totalSupply = totalSupply;
            return this;
        }

        public Builder treasuryAccountId(@Nullable AccountID treasuryAccountId) {
            this.treasuryAccountId = treasuryAccountId;
            return this;
        }

        public Builder treasuryAccountId(AccountID.Builder builder) {
            this.treasuryAccountId = builder.build();
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder kycKey(@Nullable Key kycKey) {
            this.kycKey = kycKey;
            return this;
        }

        public Builder kycKey(Key.Builder builder) {
            this.kycKey = builder.build();
            return this;
        }

        public Builder freezeKey(@Nullable Key freezeKey) {
            this.freezeKey = freezeKey;
            return this;
        }

        public Builder freezeKey(Key.Builder builder) {
            this.freezeKey = builder.build();
            return this;
        }

        public Builder wipeKey(@Nullable Key wipeKey) {
            this.wipeKey = wipeKey;
            return this;
        }

        public Builder wipeKey(Key.Builder builder) {
            this.wipeKey = builder.build();
            return this;
        }

        public Builder supplyKey(@Nullable Key supplyKey) {
            this.supplyKey = supplyKey;
            return this;
        }

        public Builder supplyKey(Key.Builder builder) {
            this.supplyKey = builder.build();
            return this;
        }

        public Builder feeScheduleKey(@Nullable Key feeScheduleKey) {
            this.feeScheduleKey = feeScheduleKey;
            return this;
        }

        public Builder feeScheduleKey(Key.Builder builder) {
            this.feeScheduleKey = builder.build();
            return this;
        }

        public Builder pauseKey(@Nullable Key pauseKey) {
            this.pauseKey = pauseKey;
            return this;
        }

        public Builder pauseKey(Key.Builder builder) {
            this.pauseKey = builder.build();
            return this;
        }

        public Builder lastUsedSerialNumber(long lastUsedSerialNumber) {
            this.lastUsedSerialNumber = lastUsedSerialNumber;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder tokenType(TokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder supplyType(TokenSupplyType supplyType) {
            this.supplyType = supplyType;
            return this;
        }

        public Builder autoRenewAccountId(@Nullable AccountID autoRenewAccountId) {
            this.autoRenewAccountId = autoRenewAccountId;
            return this;
        }

        public Builder autoRenewAccountId(AccountID.Builder builder) {
            this.autoRenewAccountId = builder.build();
            return this;
        }

        public Builder autoRenewSeconds(long autoRenewSeconds) {
            this.autoRenewSeconds = autoRenewSeconds;
            return this;
        }

        public Builder expirationSecond(long expirationSecond) {
            this.expirationSecond = expirationSecond;
            return this;
        }

        public Builder memo(@NonNull String memo) {
            this.memo = memo != null ? memo : "";
            return this;
        }

        public Builder maxSupply(long maxSupply) {
            this.maxSupply = maxSupply;
            return this;
        }

        public Builder paused(boolean paused) {
            this.paused = paused;
            return this;
        }

        public Builder accountsFrozenByDefault(boolean accountsFrozenByDefault) {
            this.accountsFrozenByDefault = accountsFrozenByDefault;
            return this;
        }

        public Builder accountsKycGrantedByDefault(boolean accountsKycGrantedByDefault) {
            this.accountsKycGrantedByDefault = accountsKycGrantedByDefault;
            return this;
        }

        public Builder customFees(@NonNull List<CustomFee> customFees) {
            this.customFees = customFees != null ? customFees : Collections.emptyList();
            return this;
        }

        public Builder customFees(CustomFee ... values) {
            this.customFees = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder metadata(@NonNull Bytes metadata) {
            this.metadata = metadata != null ? metadata : Bytes.EMPTY;
            return this;
        }

        public Builder metadataKey(@Nullable Key metadataKey) {
            this.metadataKey = metadataKey;
            return this;
        }

        public Builder metadataKey(Key.Builder builder) {
            this.metadataKey = builder.build();
            return this;
        }

        public TokenID tokenId() {
            return this.tokenId;
        }

        public String name() {
            return this.name;
        }

        public String symbol() {
            return this.symbol;
        }

        public int decimals() {
            return this.decimals;
        }

        public long totalSupply() {
            return this.totalSupply;
        }

        public AccountID treasuryAccountId() {
            return this.treasuryAccountId;
        }

        public Key adminKey() {
            return this.adminKey;
        }

        public Key kycKey() {
            return this.kycKey;
        }

        public Key freezeKey() {
            return this.freezeKey;
        }

        public Key wipeKey() {
            return this.wipeKey;
        }

        public Key supplyKey() {
            return this.supplyKey;
        }

        public Key feeScheduleKey() {
            return this.feeScheduleKey;
        }

        public Key pauseKey() {
            return this.pauseKey;
        }

        public long lastUsedSerialNumber() {
            return this.lastUsedSerialNumber;
        }

        public boolean deleted() {
            return this.deleted;
        }

        public TokenType tokenType() {
            return this.tokenType;
        }

        public TokenSupplyType supplyType() {
            return this.supplyType;
        }

        public AccountID autoRenewAccountId() {
            return this.autoRenewAccountId;
        }

        public long autoRenewSeconds() {
            return this.autoRenewSeconds;
        }

        public long expirationSecond() {
            return this.expirationSecond;
        }

        public String memo() {
            return this.memo;
        }

        public long maxSupply() {
            return this.maxSupply;
        }

        public boolean paused() {
            return this.paused;
        }

        public boolean accountsFrozenByDefault() {
            return this.accountsFrozenByDefault;
        }

        public boolean accountsKycGrantedByDefault() {
            return this.accountsKycGrantedByDefault;
        }

        public List<CustomFee> customFees() {
            return this.customFees;
        }

        public Bytes metadata() {
            return this.metadata;
        }

        public Key metadataKey() {
            return this.metadataKey;
        }
    }
}

