/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Weigher;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.internal.CodeScale;
import org.hyperledger.besu.evm.internal.EvmConfiguration;

public class CodeCache {
    private final Cache<Hash, Code> cache;
    private final long weightLimit;

    public CodeCache(EvmConfiguration config) {
        this(config.getJumpDestCacheWeightBytes());
    }

    private CodeCache(long maxWeightBytes) {
        this.weightLimit = maxWeightBytes;
        this.cache = Caffeine.newBuilder().maximumWeight(maxWeightBytes).weigher((Weigher)new CodeScale()).build();
    }

    public void invalidate(Hash key) {
        this.cache.invalidate((Object)key);
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }

    public Code getIfPresent(Hash codeHash) {
        return (Code)this.cache.getIfPresent((Object)codeHash);
    }

    public void put(Hash key, Code value) {
        this.cache.put((Object)key, (Object)value);
    }

    public long size() {
        this.cache.cleanUp();
        return this.cache.estimatedSize();
    }

    public long getWeightLimit() {
        return this.weightLimit;
    }
}

