/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import com.sun.jna.ptr.IntByReference;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;
import org.hyperledger.besu.nativelib.gnark.LibGnarkEIP2537;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBLS12PrecompiledContract
implements PrecompiledContract {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBLS12PrecompiledContract.class);
    static final int[] G1_DISCOUNT_TABLE = new int[]{-1, 1000, 949, 848, 797, 764, 750, 738, 728, 719, 712, 705, 698, 692, 687, 682, 677, 673, 669, 665, 661, 658, 654, 651, 648, 645, 642, 640, 637, 635, 632, 630, 627, 625, 623, 621, 619, 617, 615, 613, 611, 609, 608, 606, 604, 603, 601, 599, 598, 596, 595, 593, 592, 591, 589, 588, 586, 585, 584, 582, 581, 580, 579, 577, 576, 575, 574, 573, 572, 570, 569, 568, 567, 566, 565, 564, 563, 562, 561, 560, 559, 558, 557, 556, 555, 554, 553, 552, 551, 550, 549, 548, 547, 547, 546, 545, 544, 543, 542, 541, 540, 540, 539, 538, 537, 536, 536, 535, 534, 533, 532, 532, 531, 530, 529, 528, 528, 527, 526, 525, 525, 524, 523, 522, 522, 521, 520, 520, 519};
    static final int[] G2_DISCOUNT_TABLE = new int[]{-1, 1000, 1000, 923, 884, 855, 832, 812, 796, 782, 770, 759, 749, 740, 732, 724, 717, 711, 704, 699, 693, 688, 683, 679, 674, 670, 666, 663, 659, 655, 652, 649, 646, 643, 640, 637, 634, 632, 629, 627, 624, 622, 620, 618, 615, 613, 611, 609, 607, 606, 604, 602, 600, 598, 597, 595, 593, 592, 590, 589, 587, 586, 584, 583, 582, 580, 579, 578, 576, 575, 574, 573, 571, 570, 569, 568, 567, 566, 565, 563, 562, 561, 560, 559, 558, 557, 556, 555, 554, 553, 552, 552, 551, 550, 549, 548, 547, 546, 545, 545, 544, 543, 542, 541, 541, 540, 539, 538, 537, 537, 536, 535, 535, 534, 533, 532, 532, 531, 530, 530, 529, 528, 528, 527, 526, 526, 525, 524, 524};
    static final int G1_MAX_DISCOUNT = 519;
    static final int G2_MAX_DISCOUNT = 524;
    private final String name;
    private final byte operationId;
    private final int inputLimit;

    AbstractBLS12PrecompiledContract(String name, byte operationId, int inputLen) {
        this.name = name;
        this.operationId = operationId;
        this.inputLimit = inputLen + 1;
    }

    public static boolean isAvailable() {
        try {
            return LibGnarkEIP2537.ENABLED;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError ule) {
            LOG.info("bls12-381 native precompile not available: {}", (Object)ule.getMessage());
            return false;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        byte[] result = new byte[256];
        byte[] error = new byte[256];
        IntByReference o_len = new IntByReference(256);
        IntByReference err_len = new IntByReference(256);
        int inputSize = Math.min(this.inputLimit, input.size());
        int errorNo = LibGnarkEIP2537.eip2537_perform_operation((byte)this.operationId, (byte[])input.slice(0, inputSize).toArrayUnsafe(), (int)inputSize, (byte[])result, (IntByReference)o_len, (byte[])error, (IntByReference)err_len);
        if (errorNo == 0) {
            return PrecompiledContract.PrecompileContractResult.success(Bytes.wrap((byte[])result, (int)0, (int)o_len.getValue()));
        }
        String errorMessage = new String(error, 0, err_len.getValue(), StandardCharsets.UTF_8);
        messageFrame.setRevertReason(Bytes.wrap((byte[])error, (int)0, (int)err_len.getValue()));
        LOG.trace("Error executing precompiled contract {}: '{}'", (Object)this.name, (Object)errorMessage);
        return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
    }

    protected int getG1Discount(int k) {
        if (k >= G1_DISCOUNT_TABLE.length) {
            return 519;
        }
        return G1_DISCOUNT_TABLE[k];
    }

    protected int getG2Discount(int k) {
        if (k >= G2_DISCOUNT_TABLE.length) {
            return 524;
        }
        return G2_DISCOUNT_TABLE[k];
    }
}

