/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PermissionedAccountsRange {
    private static final Pattern DEGENERATE = Pattern.compile("\\d+");
    private static final Pattern NON_DEGENERATE = Pattern.compile("(\\d+)-(\\d+)");
    private static final Pattern NON_DEGENERATE_WILDCARD = Pattern.compile("(\\d+)-[*]");
    private static final Pattern INCLUSION_LIST = Pattern.compile("(\\d+(?:-\\d+|-\\*)?(?:,\\d+(?:-\\d+|-\\*)?)*)");
    final List<Range> allowedRanges;

    public static PermissionedAccountsRange from(String description) {
        Matcher nonDegenWildMatch;
        Matcher degenMatch;
        if (StringUtils.isEmpty((CharSequence)description)) {
            return null;
        }
        Matcher inclusionListOfRanges = INCLUSION_LIST.matcher(description);
        if (inclusionListOfRanges.matches()) {
            String[] parts;
            ArrayList<Range> allowedRanges = new ArrayList<Range>();
            for (String part : parts = description.split(",")) {
                if ((part = part.trim()).contains("-")) {
                    if (part.endsWith("-*")) {
                        try {
                            long from = Long.parseLong(part.substring(0, part.length() - 2).trim());
                            allowedRanges.add(new Range(from, Long.MAX_VALUE));
                        }
                        catch (NumberFormatException from) {}
                        continue;
                    }
                    String[] rangeParts = part.split("-");
                    if (rangeParts.length != 2) continue;
                    try {
                        Long from = Long.parseLong(rangeParts[0].trim());
                        Long to = Long.parseLong(rangeParts[1].trim());
                        if (from < to) {
                            allowedRanges.add(new Range(from, to));
                            continue;
                        }
                        if (!from.equals(to)) continue;
                        allowedRanges.add(new Range(from));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                try {
                    allowedRanges.add(new Range(Long.parseLong(part.trim())));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!allowedRanges.isEmpty()) {
                return new PermissionedAccountsRange(allowedRanges);
            }
        }
        if ((degenMatch = DEGENERATE.matcher(description)).matches()) {
            List<Range> allowedRanges = List.of(new Range(Long.parseLong(description)));
            return new PermissionedAccountsRange(allowedRanges);
        }
        Matcher nonDegenMatch = NON_DEGENERATE.matcher(description);
        if (nonDegenMatch.matches()) {
            Long supposedFrom = Long.valueOf(nonDegenMatch.group(1));
            Long supposedTo = Long.valueOf(nonDegenMatch.group(2));
            if (supposedFrom < supposedTo) {
                return new PermissionedAccountsRange(List.of(new Range(supposedFrom, supposedTo)));
            }
            if (supposedFrom.equals(supposedTo)) {
                return new PermissionedAccountsRange(List.of(new Range(supposedFrom)));
            }
        }
        if ((nonDegenWildMatch = NON_DEGENERATE_WILDCARD.matcher(description)).matches()) {
            return new PermissionedAccountsRange(List.of(new Range(Long.parseLong(nonDegenWildMatch.group(1)), Long.MAX_VALUE)));
        }
        return null;
    }

    public PermissionedAccountsRange(List<Range> allowedRanges) {
        this.allowedRanges = List.copyOf(allowedRanges);
    }

    public Long from() {
        return this.allowedRanges.getFirst().from();
    }

    public Long inclusiveTo() {
        return this.allowedRanges.getLast().inclusiveTo();
    }

    public boolean contains(long num) {
        for (Range range : this.allowedRanges) {
            if (!range.contains(num)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.allowedRanges.stream().map(Range::toString).reduce((a, b) -> a + "," + b).orElse("");
    }

    public static class Range {
        final Long from;
        final Long inclusiveTo;

        public Range(long from, long to) {
            this.from = from;
            this.inclusiveTo = to;
        }

        public Range(Long from) {
            this.from = from;
            this.inclusiveTo = null;
        }

        private Long from() {
            return this.from;
        }

        private Long inclusiveTo() {
            return this.inclusiveTo;
        }

        private boolean contains(long num) {
            if (this.inclusiveTo == null) {
                return num == this.from;
            }
            return this.from <= num && num <= this.inclusiveTo;
        }

        public String toString() {
            return Objects.equals(this.from, this.inclusiveTo) ? String.valueOf(this.from) : this.from + "-" + this.inclusiveTo;
        }
    }
}

