/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.hashing;

import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.UncheckedIOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Objects;

public class WritableMessageDigest
implements WritableSequentialData {
    private final MessageDigest digest;
    private long position = 0L;

    public WritableMessageDigest(@NonNull MessageDigest digest) {
        this.digest = Objects.requireNonNull(digest);
    }

    public void reset() {
        this.position = 0L;
        this.digest.reset();
    }

    public byte[] digest() {
        this.position = 0L;
        return this.digest.digest();
    }

    @Override
    public void writeByte(byte b) throws BufferOverflowException, UncheckedIOException {
        this.digest.update(b);
        ++this.position;
    }

    @Override
    public void writeBytes(@NonNull byte[] src) throws BufferOverflowException, UncheckedIOException {
        this.digest.update(src);
        this.position += (long)src.length;
    }

    @Override
    public void writeBytes(@NonNull byte[] src, int offset, int length) throws BufferOverflowException, UncheckedIOException {
        this.digest.update(src, offset, length);
        this.position += (long)length;
    }

    @Override
    public void writeBytes(@NonNull ByteBuffer src) throws BufferOverflowException, UncheckedIOException {
        this.position += (long)src.remaining();
        this.digest.update(src);
    }

    @Override
    public void writeBytes(@NonNull BufferedData src) throws BufferOverflowException, UncheckedIOException {
        this.position += src.remaining();
        src.writeTo(this.digest);
    }

    @Override
    public void writeBytes(@NonNull RandomAccessData src) throws BufferOverflowException, UncheckedIOException {
        this.position += src.length();
        src.writeTo(this.digest);
    }

    @Override
    public long capacity() {
        return Long.MAX_VALUE;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long limit() {
        return Long.MAX_VALUE;
    }

    @Override
    public void limit(long limit) {
    }

    @Override
    public void skip(long count) throws UncheckedIOException {
        this.position += count;
    }
}

