/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto.altbn128;

import com.google.common.base.MoreObjects;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.crypto.altbn128.FieldElement;

public class Fq
implements FieldElement<Fq> {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final BigInteger n;

    public static Fq zero() {
        return Fq.create(0L);
    }

    public static Fq one() {
        return Fq.create(1L);
    }

    public static Fq create(BigInteger n) {
        return new Fq(n);
    }

    static Fq create(long n) {
        return Fq.create(BigInteger.valueOf(n));
    }

    private Fq(BigInteger n) {
        this.n = n;
    }

    public Bytes toBytes() {
        return Bytes.wrap((byte[])this.n.toByteArray()).trimLeadingZeros();
    }

    @Override
    public boolean isZero() {
        return this.n.compareTo(BigInteger.ZERO) == 0;
    }

    @Override
    public boolean isValid() {
        return this.n.compareTo(FIELD_MODULUS) < 0;
    }

    @Override
    public Fq add(Fq other) {
        BigInteger result = this.n.add(other.n).mod(FIELD_MODULUS);
        return new Fq(result);
    }

    @Override
    public Fq subtract(Fq other) {
        BigInteger result = this.n.subtract(other.n).mod(FIELD_MODULUS);
        return new Fq(result);
    }

    @Override
    public Fq multiply(int val) {
        return this.multiply(new Fq(BigInteger.valueOf(val)));
    }

    @Override
    public Fq multiply(Fq other) {
        BigInteger result = this.n.multiply(other.n).mod(FIELD_MODULUS);
        return new Fq(result);
    }

    @Override
    public Fq divide(Fq other) {
        BigInteger inverse = this.inverse(other.n, FIELD_MODULUS);
        BigInteger result = this.n.multiply(inverse).mod(FIELD_MODULUS);
        return new Fq(result);
    }

    private BigInteger inverse(BigInteger a, BigInteger n) {
        if (a.compareTo(BigInteger.ZERO) == 0) {
            return BigInteger.ZERO;
        }
        BigInteger lm = BigInteger.ONE;
        BigInteger hm = BigInteger.ZERO;
        BigInteger low = a.mod(n);
        BigInteger high = n;
        while (low.compareTo(BigInteger.ONE) > 0) {
            BigInteger r = high.divide(low);
            BigInteger nm = hm.subtract(lm.multiply(r));
            BigInteger neww = high.subtract(low.multiply(r));
            high = low;
            hm = lm;
            low = neww;
            lm = nm;
        }
        return lm.mod(n);
    }

    @Override
    public Fq negate() {
        return new Fq(this.n.negate());
    }

    @Override
    public Fq power(int n) {
        if (n == 0) {
            return Fq.one();
        }
        if (n == 1) {
            return this;
        }
        if (n % 2 == 0) {
            return this.multiply(this).power(n / 2);
        }
        return this.multiply(this).power(n / 2).multiply(this);
    }

    @Override
    public Fq power(BigInteger n) {
        if (n.compareTo(BigInteger.ZERO) == 0) {
            return Fq.one();
        }
        if (n.compareTo(BigInteger.ONE) == 0) {
            return this;
        }
        if (n.mod(TWO).compareTo(BigInteger.ZERO) == 0) {
            return this.multiply(this).power(n.divide(TWO));
        }
        return this.multiply(this).power(n.divide(TWO)).multiply(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(Fq.class).add("n", (Object)this.n).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.n);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fq)) {
            return false;
        }
        Fq other = (Fq)obj;
        return this.n.compareTo(other.n) == 0;
    }
}

