/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream;

import com.hedera.hapi.block.stream.SiblingNode;
import com.hedera.hapi.block.stream.codec.MerklePathJsonCodec;
import com.hedera.hapi.block.stream.codec.MerklePathProtoCodec;
import com.hedera.hapi.block.stream.schema.MerklePathSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class MerklePath {
    public static final Codec<MerklePath> PROTOBUF = new MerklePathProtoCodec();
    public static final JsonCodec<MerklePath> JSON = new MerklePathJsonCodec();
    public static final MerklePath DEFAULT = MerklePath.newBuilder().build();
    @NonNull
    private final List<SiblingNode> siblings;
    private final int nextPathIndex;
    private final OneOf<ContentOneOfType> content;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public MerklePath(List<SiblingNode> siblings, int nextPathIndex, OneOf<ContentOneOfType> content) {
        this.$unknownFields = null;
        this.siblings = siblings == null ? Collections.emptyList() : siblings;
        this.nextPathIndex = nextPathIndex;
        if (content == null) {
            throw new NullPointerException("Parameter 'content' must be supplied and can not be null");
        }
        this.content = content;
    }

    public MerklePath(List<SiblingNode> siblings, int nextPathIndex, OneOf<ContentOneOfType> content, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.siblings = siblings == null ? Collections.emptyList() : siblings;
        this.nextPathIndex = nextPathIndex;
        if (content == null) {
            throw new NullPointerException("Parameter 'content' must be supplied and can not be null");
        }
        this.content = content;
    }

    public List<SiblingNode> siblings() {
        return this.siblings;
    }

    public int nextPathIndex() {
        return this.nextPathIndex;
    }

    public OneOf<ContentOneOfType> content() {
        return this.content;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)MerklePathSchema.SIBLINGS, this.siblings, SiblingNode.PROTOBUF);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)MerklePathSchema.NEXT_PATH_INDEX, (int)this.nextPathIndex, (boolean)true);
            if (this.content.kind() == ContentOneOfType.HASH) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)MerklePathSchema.HASH, (RandomAccessData)((RandomAccessData)this.content.as()), (boolean)true);
            }
            if (this.content.kind() == ContentOneOfType.STATE_ITEM_LEAF) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)MerklePathSchema.STATE_ITEM_LEAF, (RandomAccessData)((RandomAccessData)this.content.as()), (boolean)true);
            }
            if (this.content.kind() == ContentOneOfType.BLOCK_ITEM_LEAF) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)MerklePathSchema.BLOCK_ITEM_LEAF, (RandomAccessData)((RandomAccessData)this.content.as()), (boolean)true);
            }
            if (this.content.kind() == ContentOneOfType.TIMESTAMP_LEAF) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)MerklePathSchema.TIMESTAMP_LEAF, (RandomAccessData)((RandomAccessData)this.content.as()), (boolean)true);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            List<SiblingNode> list$siblings = this.siblings;
            if (list$siblings != null) {
                for (SiblingNode o : list$siblings) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.nextPathIndex != MerklePath.DEFAULT.nextPathIndex) {
                result = 31 * result + Integer.hashCode(this.nextPathIndex);
            }
            if (this.content != null && !this.content.equals(MerklePath.DEFAULT.content)) {
                result = 31 * result + this.content.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        MerklePath thatObj = (MerklePath)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.siblings == null && thatObj.siblings != null) {
            return false;
        }
        if (this.siblings != null && !this.siblings.equals(thatObj.siblings)) {
            return false;
        }
        if (this.nextPathIndex != thatObj.nextPathIndex) {
            return false;
        }
        if (this.content == null && thatObj.content != null) {
            return false;
        }
        if (this.content != null && !this.content.equals(thatObj.content)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "MerklePath[siblings=" + String.valueOf(this.siblings) + ", nextPathIndex=" + this.nextPathIndex + ", content=" + String.valueOf(this.content) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public Bytes hash() {
        return this.content.kind() == ContentOneOfType.HASH ? (Bytes)this.content.value() : null;
    }

    public boolean hasHash() {
        return this.content.kind() == ContentOneOfType.HASH;
    }

    public Bytes hashOrElse(@NonNull Bytes defaultValue) {
        return this.hasHash() ? this.hash() : defaultValue;
    }

    @NonNull
    public Bytes hashOrThrow() {
        return Objects.requireNonNull(this.hash(), "Field hash is null");
    }

    @Nullable
    public Bytes stateItemLeaf() {
        return this.content.kind() == ContentOneOfType.STATE_ITEM_LEAF ? (Bytes)this.content.value() : null;
    }

    public boolean hasStateItemLeaf() {
        return this.content.kind() == ContentOneOfType.STATE_ITEM_LEAF;
    }

    public Bytes stateItemLeafOrElse(@NonNull Bytes defaultValue) {
        return this.hasStateItemLeaf() ? this.stateItemLeaf() : defaultValue;
    }

    @NonNull
    public Bytes stateItemLeafOrThrow() {
        return Objects.requireNonNull(this.stateItemLeaf(), "Field stateItemLeaf is null");
    }

    @Nullable
    public Bytes blockItemLeaf() {
        return this.content.kind() == ContentOneOfType.BLOCK_ITEM_LEAF ? (Bytes)this.content.value() : null;
    }

    public boolean hasBlockItemLeaf() {
        return this.content.kind() == ContentOneOfType.BLOCK_ITEM_LEAF;
    }

    public Bytes blockItemLeafOrElse(@NonNull Bytes defaultValue) {
        return this.hasBlockItemLeaf() ? this.blockItemLeaf() : defaultValue;
    }

    @NonNull
    public Bytes blockItemLeafOrThrow() {
        return Objects.requireNonNull(this.blockItemLeaf(), "Field blockItemLeaf is null");
    }

    @Nullable
    public Bytes timestampLeaf() {
        return this.content.kind() == ContentOneOfType.TIMESTAMP_LEAF ? (Bytes)this.content.value() : null;
    }

    public boolean hasTimestampLeaf() {
        return this.content.kind() == ContentOneOfType.TIMESTAMP_LEAF;
    }

    public Bytes timestampLeafOrElse(@NonNull Bytes defaultValue) {
        return this.hasTimestampLeaf() ? this.timestampLeaf() : defaultValue;
    }

    @NonNull
    public Bytes timestampLeafOrThrow() {
        return Objects.requireNonNull(this.timestampLeaf(), "Field timestampLeaf is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.siblings, this.nextPathIndex, this.content, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum ContentOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        HASH(3, "hash"),
        STATE_ITEM_LEAF(4, "state_item_leaf"),
        BLOCK_ITEM_LEAF(5, "block_item_leaf"),
        TIMESTAMP_LEAF(6, "timestamp_leaf");

        private final int protoOrdinal;
        private final String protoName;

        private ContentOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static ContentOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 3 -> HASH;
                case 4 -> STATE_ITEM_LEAF;
                case 5 -> BLOCK_ITEM_LEAF;
                case 6 -> TIMESTAMP_LEAF;
                default -> UNSET;
            };
        }

        public static ContentOneOfType fromString(String name) {
            return switch (name) {
                case "hash", "HASH" -> HASH;
                case "state_item_leaf", "STATE_ITEM_LEAF" -> STATE_ITEM_LEAF;
                case "block_item_leaf", "BLOCK_ITEM_LEAF" -> BLOCK_ITEM_LEAF;
                case "timestamp_leaf", "TIMESTAMP_LEAF" -> TIMESTAMP_LEAF;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }

        public static ContentOneOfType fromObject(Object obj) {
            if (obj == null) {
                return ContentOneOfType.fromProtobufOrdinal(0);
            }
            if (obj instanceof ContentOneOfType) {
                ContentOneOfType pbjEnum = (ContentOneOfType)((Object)obj);
                return pbjEnum;
            }
            return UNSET;
        }

        public static List<ContentOneOfType> fromObjects(List<?> list) {
            return list.stream().map(ContentOneOfType::fromObject).toList();
        }

        public static int toProtoOrdinal(Object obj) {
            if (obj instanceof ContentOneOfType) {
                ContentOneOfType pbjEnum = (ContentOneOfType)((Object)obj);
                return pbjEnum.protoOrdinal();
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return i;
            }
            throw new IllegalArgumentException("Neither ContentOneOfType, nor Integer, but: " + obj.getClass().getName());
        }

        public static List<Integer> toProtoOrdinals(List<?> list) {
            return list.stream().map(ContentOneOfType::toProtoOrdinal).toList();
        }

        public static int compare(Object o1, Object o2) {
            int i2;
            int i1;
            if (o1 instanceof ContentOneOfType) {
                ContentOneOfType e1 = (ContentOneOfType)((Object)o1);
                if (o2 instanceof ContentOneOfType) {
                    ContentOneOfType e2 = (ContentOneOfType)((Object)o2);
                    return e1.compareTo(e2);
                }
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof ContentOneOfType) {
                ContentOneOfType e1 = (ContentOneOfType)((Object)o1);
                i1 = e1.protoOrdinal();
            } else if (o1 instanceof Integer) {
                Integer ii1 = (Integer)o1;
                i1 = ii1;
            } else {
                throw new IllegalArgumentException("o1 is neither ContentOneOfType, nor Integer. It's: " + o1.getClass().getName());
            }
            if (o2 instanceof ContentOneOfType) {
                ContentOneOfType e2 = (ContentOneOfType)((Object)o2);
                i2 = e2.protoOrdinal();
            } else if (o2 instanceof Integer) {
                Integer ii2 = (Integer)o2;
                i2 = ii2;
            } else {
                throw new IllegalArgumentException("o2 is neither ContentOneOfType, nor Integer. It's: " + o2.getClass().getName());
            }
            return Integer.compare(i1, i2);
        }
    }

    public static final class Builder {
        @NonNull
        private List<SiblingNode> siblings = Collections.emptyList();
        private int nextPathIndex = 0;
        private OneOf<ContentOneOfType> content = MerklePathProtoCodec.CONTENT_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(List<SiblingNode> siblings, int nextPathIndex, OneOf<ContentOneOfType> content) {
            this.$unknownFields = null;
            this.siblings = siblings == null ? Collections.emptyList() : siblings;
            this.nextPathIndex = nextPathIndex;
            this.content = content;
        }

        public Builder(List<SiblingNode> siblings, int nextPathIndex, OneOf<ContentOneOfType> content, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.siblings = siblings == null ? Collections.emptyList() : siblings;
            this.nextPathIndex = nextPathIndex;
            this.content = content;
        }

        public MerklePath build() {
            return new MerklePath(this.siblings, this.nextPathIndex, this.content);
        }

        public Builder siblings(@NonNull List<SiblingNode> siblings) {
            this.siblings = siblings != null ? siblings : Collections.emptyList();
            return this;
        }

        public Builder siblings(SiblingNode ... values) {
            this.siblings = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder nextPathIndex(int nextPathIndex) {
            this.nextPathIndex = nextPathIndex;
            return this;
        }

        public void clearContent() {
            this.content = MerklePathProtoCodec.CONTENT_UNSET;
        }

        public Builder hash(@NonNull Bytes hash) {
            this.content = new OneOf((Enum)ContentOneOfType.HASH, (Object)hash);
            return this;
        }

        public Builder stateItemLeaf(@NonNull Bytes stateItemLeaf) {
            this.content = new OneOf((Enum)ContentOneOfType.STATE_ITEM_LEAF, (Object)stateItemLeaf);
            return this;
        }

        public Builder blockItemLeaf(@NonNull Bytes blockItemLeaf) {
            this.content = new OneOf((Enum)ContentOneOfType.BLOCK_ITEM_LEAF, (Object)blockItemLeaf);
            return this;
        }

        public Builder timestampLeaf(@NonNull Bytes timestampLeaf) {
            this.content = new OneOf((Enum)ContentOneOfType.TIMESTAMP_LEAF, (Object)timestampLeaf);
            return this;
        }

        public List<SiblingNode> siblings() {
            return this.siblings;
        }

        public int nextPathIndex() {
            return this.nextPathIndex;
        }

        public OneOf<ContentOneOfType> content() {
            return this.content;
        }
    }
}

