/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import java.util.List;

public enum CallOperationType implements EnumWithProtoMetadata
{
    OP_UNKNOWN(0, "OP_UNKNOWN"),
    OP_CALL(1, "OP_CALL"),
    OP_CALLCODE(2, "OP_CALLCODE"),
    OP_DELEGATECALL(3, "OP_DELEGATECALL"),
    OP_STATICCALL(4, "OP_STATICCALL"),
    OP_CREATE(5, "OP_CREATE"),
    OP_CREATE2(6, "OP_CREATE2"),
    UNRECOGNIZED(-1, "UNRECOGNIZED");

    private final int protoOrdinal;
    private final String protoName;

    private CallOperationType(int protoOrdinal, String protoName) {
        this.protoOrdinal = protoOrdinal;
        this.protoName = protoName;
    }

    public int protoOrdinal() {
        return this.protoOrdinal;
    }

    public String protoName() {
        return this.protoName;
    }

    public static CallOperationType fromProtobufOrdinal(int ordinal) {
        return switch (ordinal) {
            case 0 -> OP_UNKNOWN;
            case 1 -> OP_CALL;
            case 2 -> OP_CALLCODE;
            case 3 -> OP_DELEGATECALL;
            case 4 -> OP_STATICCALL;
            case 5 -> OP_CREATE;
            case 6 -> OP_CREATE2;
            default -> UNRECOGNIZED;
        };
    }

    public static CallOperationType fromString(String name) {
        return switch (name) {
            case "OP_UNKNOWN" -> OP_UNKNOWN;
            case "OP_CALL" -> OP_CALL;
            case "OP_CALLCODE" -> OP_CALLCODE;
            case "OP_DELEGATECALL" -> OP_DELEGATECALL;
            case "OP_STATICCALL" -> OP_STATICCALL;
            case "OP_CREATE" -> OP_CREATE;
            case "OP_CREATE2" -> OP_CREATE2;
            default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
        };
    }

    public static CallOperationType fromObject(Object obj) {
        if (obj == null) {
            return CallOperationType.fromProtobufOrdinal(0);
        }
        if (obj instanceof CallOperationType) {
            CallOperationType pbjEnum = (CallOperationType)((Object)obj);
            return pbjEnum;
        }
        return UNRECOGNIZED;
    }

    public static List<CallOperationType> fromObjects(List<?> list) {
        return list.stream().map(CallOperationType::fromObject).toList();
    }

    public static int toProtoOrdinal(Object obj) {
        if (obj instanceof CallOperationType) {
            CallOperationType pbjEnum = (CallOperationType)((Object)obj);
            return pbjEnum.protoOrdinal();
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return i;
        }
        throw new IllegalArgumentException("Neither CallOperationType, nor Integer, but: " + obj.getClass().getName());
    }

    public static List<Integer> toProtoOrdinals(List<?> list) {
        return list.stream().map(CallOperationType::toProtoOrdinal).toList();
    }

    public static int compare(Object o1, Object o2) {
        int i2;
        int i1;
        if (o1 instanceof CallOperationType) {
            CallOperationType e1 = (CallOperationType)((Object)o1);
            if (o2 instanceof CallOperationType) {
                CallOperationType e2 = (CallOperationType)((Object)o2);
                return e1.compareTo(e2);
            }
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 instanceof CallOperationType) {
            CallOperationType e1 = (CallOperationType)((Object)o1);
            i1 = e1.protoOrdinal();
        } else if (o1 instanceof Integer) {
            Integer ii1 = (Integer)o1;
            i1 = ii1;
        } else {
            throw new IllegalArgumentException("o1 is neither CallOperationType, nor Integer. It's: " + o1.getClass().getName());
        }
        if (o2 instanceof CallOperationType) {
            CallOperationType e2 = (CallOperationType)((Object)o2);
            i2 = e2.protoOrdinal();
        } else if (o2 instanceof Integer) {
            Integer ii2 = (Integer)o2;
            i2 = ii2;
        } else {
            throw new IllegalArgumentException("o2 is neither CallOperationType, nor Integer. It's: " + o2.getClass().getName());
        }
        return Integer.compare(i1, i2);
    }
}

