/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.connectivity;

import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.net.Socket;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.interrupt.InterruptableConsumer;
import org.hiero.consensus.concurrent.utility.throttle.RateLimitedLogger;
import org.hiero.consensus.gossip.config.SocketConfig;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncInputStream;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncOutputStream;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.gossip.impl.network.ConnectionTracker;
import org.hiero.consensus.gossip.impl.network.NetworkPeerIdentifier;
import org.hiero.consensus.gossip.impl.network.NetworkUtils;
import org.hiero.consensus.gossip.impl.network.PeerInfo;
import org.hiero.consensus.gossip.impl.network.SocketConnection;
import org.hiero.consensus.model.node.NodeId;

public class InboundConnectionHandler {
    private static final Logger logger = LogManager.getLogger(InboundConnectionHandler.class);
    private final ConnectionTracker connectionTracker;
    private final NodeId selfId;
    private final InterruptableConsumer<Connection> newConnectionConsumer;
    private final SocketConfig socketConfig;
    private final RateLimitedLogger socketExceptionLogger;
    private final Configuration configuration;
    private final NetworkPeerIdentifier networkPeerIdentifier;
    private final Time time;

    public InboundConnectionHandler(@NonNull Configuration configuration, @NonNull Time time, @NonNull ConnectionTracker connectionTracker, @NonNull List<PeerInfo> peers, @NonNull NodeId selfId, @NonNull InterruptableConsumer<Connection> newConnectionConsumer) {
        this.configuration = Objects.requireNonNull(configuration);
        this.connectionTracker = Objects.requireNonNull(connectionTracker);
        this.selfId = Objects.requireNonNull(selfId);
        this.newConnectionConsumer = Objects.requireNonNull(newConnectionConsumer);
        this.time = Objects.requireNonNull(time);
        this.socketExceptionLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
        this.socketConfig = (SocketConfig)configuration.getConfigData(SocketConfig.class);
        this.networkPeerIdentifier = new NetworkPeerIdentifier(time, Objects.requireNonNull(peers));
    }

    public void handle(@NonNull Socket clientSocket) {
        long acceptTime = this.time.currentTimeMillis();
        Objects.requireNonNull(clientSocket);
        String remoteIp = "unknown";
        try {
            remoteIp = clientSocket.getInetAddress().toString();
            clientSocket.setTcpNoDelay(this.socketConfig.tcpNoDelay());
            clientSocket.setSoTimeout(this.socketConfig.timeoutSyncClientSocket());
            SSLSocket sslSocket = (SSLSocket)clientSocket;
            PeerInfo connectedPeer = this.networkPeerIdentifier.identifyTlsPeer(sslSocket.getSession().getPeerCertificates());
            if (connectedPeer == null) {
                clientSocket.close();
                return;
            }
            NodeId otherId = connectedPeer.nodeId();
            SyncInputStream sis = SyncInputStream.createSyncInputStream(this.configuration, clientSocket.getInputStream(), this.socketConfig.bufferSize());
            SyncOutputStream sos = SyncOutputStream.createSyncOutputStream(this.configuration, clientSocket.getOutputStream(), this.socketConfig.bufferSize());
            SocketConnection sc = SocketConnection.create(this.selfId, otherId, this.connectionTracker, false, clientSocket, sis, sos, this.configuration);
            this.newConnectionConsumer.accept((Object)sc);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String formattedException = NetworkUtils.formatException(e);
            logger.warn(LogMarker.SOCKET_EXCEPTIONS.getMarker(), "Inbound connection from {} to {} was interrupted: {}", (Object)remoteIp, (Object)this.selfId, (Object)formattedException);
            NetworkUtils.close(clientSocket);
        }
        catch (IOException e) {
            String formattedException = NetworkUtils.formatException(e);
            this.socketExceptionLogger.warn(LogMarker.SOCKET_EXCEPTIONS.getMarker(), "Inbound connection from {} to {} had IOException: {}", new Object[]{remoteIp, this.selfId, formattedException});
            NetworkUtils.close(clientSocket);
        }
        catch (RuntimeException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Inbound connection error, remote IP: {}\nTime from accept to exception: {} ms", (Object)(clientSocket.getInetAddress() != null ? clientSocket.getInetAddress().toString() : "null IP"), acceptTime == 0L ? "N/A" : Long.valueOf(System.currentTimeMillis() - acceptTime), (Object)e);
            NetworkUtils.close(clientSocket);
        }
    }

    public InboundConnectionHandler withNewPeers(@NonNull List<PeerInfo> newPeers) {
        return new InboundConnectionHandler(this.configuration, this.time, this.connectionTracker, newPeers, this.selfId, this.newConnectionConsumer);
    }
}

