/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.connectivity;

import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.KeystorePasswordPolicy;
import org.hiero.base.crypto.config.CryptoConfig;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;
import org.hiero.consensus.exceptions.PlatformConstructionException;
import org.hiero.consensus.gossip.config.GossipConfig;
import org.hiero.consensus.gossip.config.SocketConfig;
import org.hiero.consensus.gossip.impl.gossip.Utilities;
import org.hiero.consensus.gossip.impl.network.PeerInfo;
import org.hiero.consensus.gossip.impl.network.connectivity.SocketFactory;
import org.hiero.consensus.model.node.NodeId;

public class TlsFactory
implements SocketFactory {
    private static final Logger logger = LogManager.getLogger(TlsFactory.class);
    private SSLServerSocketFactory sslServerSocketFactory;
    private SSLSocketFactory sslSocketFactory;
    private final Configuration configuration;
    private final NodeId selfId;
    private final SSLContext sslContext;
    private final SecureRandom nonDetRandom;
    private final KeyManagerFactory keyManagerFactory;
    private final TrustManagerFactory trustManagerFactory;

    public TlsFactory(@NonNull Certificate agrCert, @NonNull PrivateKey agrKey, @NonNull List<PeerInfo> peers, @NonNull NodeId selfId, @NonNull Configuration configuration) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        Objects.requireNonNull(agrCert);
        Objects.requireNonNull(agrKey);
        Objects.requireNonNull(peers);
        this.selfId = Objects.requireNonNull(selfId);
        this.configuration = Objects.requireNonNull(configuration);
        CryptoConfig configData = (CryptoConfig)configuration.getConfigData(CryptoConfig.class);
        String passphrase = configData.keystorePassword();
        if (passphrase == null || passphrase.isBlank()) {
            throw new IllegalArgumentException("crypto.keystorePassword must not be null or blank");
        }
        KeystorePasswordPolicy.warnIfNonCompliant((String)"crypto.keystorePassword", (String)passphrase);
        char[] password = passphrase.toCharArray();
        this.nonDetRandom = ConsensusCryptoUtils.getNonDetRandom();
        KeyStore agrKeyStore = KeyStore.getInstance("pkcs12");
        agrKeyStore.load(null, null);
        agrKeyStore.setKeyEntry("key", agrKey, password, new Certificate[]{agrCert});
        this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.keyManagerFactory.init(agrKeyStore, password);
        this.trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        this.sslContext = SSLContext.getInstance("TLSv1.2");
        this.reload(peers);
    }

    @Override
    @NonNull
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket serverSocket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket();
        serverSocket.setEnabledCipherSuites(new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"});
        serverSocket.setWantClientAuth(true);
        serverSocket.setNeedClientAuth(true);
        SocketConfig socketConfig = (SocketConfig)this.configuration.getConfigData(SocketConfig.class);
        GossipConfig gossipConfig = (GossipConfig)this.configuration.getConfigData(GossipConfig.class);
        SocketFactory.configureAndBind(this.selfId, serverSocket, socketConfig, gossipConfig, port);
        return serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Socket createClientSocket(@NonNull String hostname, int port) throws IOException {
        Objects.requireNonNull(hostname);
        TlsFactory tlsFactory = this;
        synchronized (tlsFactory) {
            SSLSocket clientSocket = (SSLSocket)this.sslSocketFactory.createSocket();
            clientSocket.setEnabledCipherSuites(new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"});
            clientSocket.setWantClientAuth(true);
            clientSocket.setNeedClientAuth(true);
            SocketConfig socketConfig = (SocketConfig)this.configuration.getConfigData(SocketConfig.class);
            SocketFactory.configureAndConnect(clientSocket, socketConfig, hostname, port);
            clientSocket.startHandshake();
            return clientSocket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(@NonNull Collection<PeerInfo> peers) {
        try {
            TlsFactory tlsFactory = this;
            synchronized (tlsFactory) {
                KeyStore signingTrustStore = Utilities.createPublicKeyStore(Objects.requireNonNull(peers));
                this.trustManagerFactory.init(signingTrustStore);
                this.sslContext.init(this.keyManagerFactory.getKeyManagers(), this.trustManagerFactory.getTrustManagers(), this.nonDetRandom);
                this.sslServerSocketFactory = this.sslContext.getServerSocketFactory();
                this.sslSocketFactory = this.sslContext.getSocketFactory();
            }
        }
        catch (KeyManagementException | KeyStoreException e) {
            throw new PlatformConstructionException("A problem occurred while initializing the SocketFactory", (Throwable)e);
        }
    }
}

