/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.blocks.impl.BlockImplUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.List;

public class IncrementalStreamingHasher {
    private final MessageDigest digest;
    private final LinkedList<byte[]> hashList = new LinkedList();
    private long leafCount;

    public IncrementalStreamingHasher(MessageDigest digest, List<byte[]> intermediateHashingState, long leafCount) {
        if (digest == null) {
            throw new IllegalArgumentException("digest must not be null");
        }
        this.digest = digest;
        this.hashList.addAll(intermediateHashingState);
        this.leafCount = leafCount;
    }

    public void addLeaf(byte[] data) {
        this.addNodeByHash(BlockImplUtils.hashLeaf(this.digest, data));
    }

    public void addNodeByHash(byte[] hash) {
        this.hashList.add(hash);
        long n = this.leafCount;
        while ((n & 1L) == 1L) {
            byte[] y = this.hashList.removeLast();
            byte[] x = this.hashList.removeLast();
            this.hashList.add(this.hashInternalNode(x, y));
            n >>= 1;
        }
        ++this.leafCount;
    }

    public byte[] computeRootHash() {
        if (this.hashList.isEmpty()) {
            return BlockStreamManager.HASH_OF_ZERO_BYTES;
        }
        if (this.hashList.size() == 1) {
            return this.hashList.getFirst();
        }
        byte[] merkleRootHash = this.hashList.getLast();
        for (int i = this.hashList.size() - 2; i >= 0; --i) {
            merkleRootHash = this.hashInternalNode(this.hashList.get(i), merkleRootHash);
        }
        return merkleRootHash;
    }

    public List<Bytes> intermediateHashingState() {
        return this.hashList.stream().map(Bytes::wrap).toList();
    }

    public long leafCount() {
        return this.leafCount;
    }

    public void save(Path filePath) throws Exception {
        try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));){
            out.writeLong(this.leafCount);
            out.writeInt(this.hashList.size());
            for (byte[] hash : this.hashList) {
                out.write(hash);
            }
        }
    }

    public void load(Path filePath) throws Exception {
        try (DataInputStream din = new DataInputStream(Files.newInputStream(filePath, new OpenOption[0]));){
            this.leafCount = din.readLong();
            int hashCount = din.readInt();
            this.hashList.clear();
            for (int i = 0; i < hashCount; ++i) {
                byte[] hash = new byte[48];
                din.readFully(hash);
                this.hashList.add(hash);
            }
        }
    }

    private byte[] hashInternalNode(byte[] firstChild, byte[] secondChild) {
        return BlockImplUtils.hashInternalNode(this.digest, firstChild, secondChild);
    }
}

