/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees.congestion;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.fees.congestion.ThrottleMultiplier;
import com.hedera.node.app.fees.congestion.UtilizationScaledThrottleMultiplier;
import com.hedera.node.app.spi.store.ReadableStoreFactory;
import com.hedera.node.app.throttle.annotations.GasThrottleMultiplier;
import com.hedera.node.app.workflows.TransactionInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CongestionMultipliers {
    private final UtilizationScaledThrottleMultiplier utilizationScaledThrottleMultiplier;
    private final ThrottleMultiplier gasThrottleMultiplier;

    @Inject
    public CongestionMultipliers(@NonNull UtilizationScaledThrottleMultiplier utilizationScaledThrottleMultiplier, @GasThrottleMultiplier @NonNull ThrottleMultiplier gasThrottleMultiplier) {
        this.utilizationScaledThrottleMultiplier = Objects.requireNonNull(utilizationScaledThrottleMultiplier, "entityUtilizationMultiplier must not be null");
        this.gasThrottleMultiplier = Objects.requireNonNull(gasThrottleMultiplier, "throttleMultiplier must not be null");
    }

    public void updateMultiplier(@NonNull Instant consensusTime) {
        this.gasThrottleMultiplier.updateMultiplier(consensusTime);
        this.utilizationScaledThrottleMultiplier.updateMultiplier(consensusTime);
    }

    public long maxCurrentMultiplier(@NonNull TransactionInfo txnInfo, @NonNull ReadableStoreFactory storeFactory) {
        return this.maxCurrentMultiplier(txnInfo.txBody(), txnInfo.functionality(), storeFactory);
    }

    public long maxCurrentMultiplier(@NonNull TransactionBody body, @NonNull HederaFunctionality functionality, @NonNull ReadableStoreFactory storeFactory) {
        return Math.max(this.gasThrottleMultiplier.currentMultiplier(), this.utilizationScaledThrottleMultiplier.currentMultiplier(body, functionality, storeFactory));
    }

    @NonNull
    public Instant[] entityUtilizationCongestionStarts() {
        return this.utilizationScaledThrottleMultiplier.congestionLevelStarts();
    }

    @NonNull
    public Instant[] gasThrottleMultiplierCongestionStarts() {
        return this.gasThrottleMultiplier.congestionLevelStarts();
    }

    public void resetUtilizationScaledThrottleMultiplierStarts(@NonNull Instant[] startTimes) {
        this.utilizationScaledThrottleMultiplier.resetCongestionLevelStarts(startTimes);
    }

    public void resetGasThrottleMultiplierStarts(@NonNull Instant[] startTimes) {
        this.gasThrottleMultiplier.resetCongestionLevelStarts(startTimes);
    }

    public void resetExpectations() {
        this.gasThrottleMultiplier.resetExpectations();
        this.utilizationScaledThrottleMultiplier.resetExpectations();
    }
}

