/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.platform;

import com.hedera.node.app.annotations.CommonExecutor;
import com.hedera.node.app.config.BootstrapConfigProviderImpl;
import com.hedera.node.app.quiescence.QuiescenceController;
import com.hedera.node.app.quiescence.TxPipelineTracker;
import com.hedera.node.app.state.listeners.FatalIssListenerImpl;
import com.hedera.node.app.state.listeners.ReconnectListener;
import com.hedera.node.app.state.listeners.WriteStateToDiskListener;
import com.hedera.node.config.data.QuiescenceConfig;
import com.swirlds.platform.listeners.ReconnectCompleteListener;
import com.swirlds.platform.listeners.StateWriteToDiskCompleteListener;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.state.notifications.AsyncFatalIssListener;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.charset.Charset;
import java.time.InstantSource;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.hiero.base.crypto.Signer;

@Module
public interface PlatformModule {
    @Provides
    @Singleton
    public static Signer signer(@NonNull Platform platform) {
        return arg_0 -> ((Platform)platform).sign(arg_0);
    }

    @Provides
    @Singleton
    @CommonExecutor
    public static ExecutorService provideCommonExecutor() {
        return ForkJoinPool.commonPool();
    }

    @Provides
    @Singleton
    public static Supplier<Charset> provideNativeCharset() {
        return Charset::defaultCharset;
    }

    @Provides
    @Singleton
    public static QuiescenceController provideQuiescenceController(@NonNull BootstrapConfigProviderImpl configProvider, @NonNull TxPipelineTracker txPipelineTracker, @NonNull InstantSource instantSource) {
        return new QuiescenceController((QuiescenceConfig)configProvider.configuration().getConfigData(QuiescenceConfig.class), instantSource, txPipelineTracker::estimateTxPipelineCount);
    }

    @Binds
    @Singleton
    public ReconnectCompleteListener bindReconnectListener(ReconnectListener var1);

    @Binds
    @Singleton
    public StateWriteToDiskCompleteListener bindStateWrittenToDiskListener(WriteStateToDiskListener var1);

    @Binds
    @Singleton
    public AsyncFatalIssListener bindFatalIssListener(FatalIssListenerImpl var1);
}

