/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.hedera.node.app.fees.congestion.CongestionMultipliers;
import com.hedera.node.app.spi.store.ReadableStoreFactory;
import com.hedera.node.app.workflows.TransactionInfo;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CongestionMetrics {
    private final CongestionMultipliers congestionMultipliers;
    private final LongGauge congestionMultiplierGauge;

    @Inject
    public CongestionMetrics(@NonNull Metrics metrics, @NonNull CongestionMultipliers congestionMultipliers) {
        Objects.requireNonNull(metrics);
        this.congestionMultipliers = Objects.requireNonNull(congestionMultipliers);
        LongGauge.Config config = new LongGauge.Config("app", "congestionMultiplier").withDescription("Current congestion multiplier");
        this.congestionMultiplierGauge = (LongGauge)metrics.getOrCreate((MetricConfig)config);
    }

    public void updateMultiplier(@NonNull TransactionInfo txnInfo, @NonNull ReadableStoreFactory storeFactory) {
        this.congestionMultiplierGauge.set(this.congestionMultipliers.maxCurrentMultiplier(txnInfo, storeFactory));
    }
}

