/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage;

import com.hedera.node.app.hapi.fees.usage.EstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hederahashgraph.api.proto.java.FeeComponents;

public class UsageEstimate {
    static EstimatorUtils estimatorUtils = SingletonEstimatorUtils.ESTIMATOR_UTILS;
    private long rbs;
    private long sbs;
    private final FeeComponents.Builder base;

    public UsageEstimate(FeeComponents.Builder base) {
        this.base = base;
    }

    public void addRbs(long amount) {
        this.rbs += amount;
    }

    public void addSbs(long amount) {
        this.sbs += amount;
    }

    public FeeComponents.Builder base() {
        return this.base;
    }

    public FeeComponents build() {
        return this.base.setSbh(estimatorUtils.nonDegenerateDiv(this.sbs, 3600)).setRbh(estimatorUtils.nonDegenerateDiv(this.rbs, 3600)).build();
    }

    public long getRbs() {
        return this.rbs;
    }
}

