/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.rejecttokens;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.TokenReference;
import com.hedera.hapi.node.token.TokenRejectTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.rejecttokens.RejectTokensTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.LedgerConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RejectTokensDecoder {
    private static final int OWNER_ADDRESS_INDEX = 0;
    private static final int FUNGIBLE_ADDRESS_INDEX = 1;
    private static final int NFT_IDS_INDEX = 2;
    private static final int NFT_ID_ADDRESS_INDEX = 0;
    private static final int NFT_ID_SERIAL_INDEX = 1;
    private static final int HRC_NFT_SERIAL_INDEX = 0;

    @Inject
    public RejectTokensDecoder() {
    }

    public TransactionBody decodeTokenRejects(@NonNull HtsCallAttempt attempt) {
        Tuple[] nftIds;
        Tuple call = RejectTokensTranslator.TOKEN_REJECT.decodeCall(attempt.inputBytes());
        int maxRejections = ((LedgerConfig)attempt.configuration().getConfigData(LedgerConfig.class)).tokenRejectsMaxLen();
        Address[] ftAddresses = (Address[])call.get(1);
        HandleException.validateFalse((ftAddresses.length + (nftIds = (Tuple[])call.get(2)).length > maxRejections ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_REFERENCE_LIST_SIZE_LIMIT_EXCEEDED);
        Address owner = (Address)call.get(0);
        AccountID ownerId = attempt.addressIdConverter().convert(owner);
        ArrayList<TokenReference> referenceList = new ArrayList<TokenReference>();
        for (Address address : ftAddresses) {
            TokenReference tokenReference = TokenReference.newBuilder().fungibleToken(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), address)).build();
            referenceList.add(tokenReference);
        }
        for (Address address : nftIds) {
            Address nftIdAddress = (Address)address.get(0);
            long nftIdSerial = (Long)address.get(1);
            TokenReference nftReference = TokenReference.newBuilder().nft(NftID.newBuilder().tokenId(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), nftIdAddress)).serialNumber(nftIdSerial).build()).build();
            referenceList.add(nftReference);
        }
        return TransactionBody.newBuilder().tokenReject(TokenRejectTransactionBody.newBuilder().owner(ownerId).rejections(referenceList)).build();
    }

    public TransactionBody decodeHrcTokenRejectFT(@NonNull HtsCallAttempt attempt) {
        TokenID token = attempt.redirectTokenId();
        AccountID sender = attempt.senderId();
        TokenReference tokenReference = TokenReference.newBuilder().fungibleToken(token).build();
        return TransactionBody.newBuilder().tokenReject(TokenRejectTransactionBody.newBuilder().owner(sender).rejections(new TokenReference[]{tokenReference})).build();
    }

    public TransactionBody decodeHrcTokenRejectNFT(@NonNull HtsCallAttempt attempt) {
        int maxRejections = ((LedgerConfig)attempt.configuration().getConfigData(LedgerConfig.class)).tokenRejectsMaxLen();
        Tuple call = RejectTokensTranslator.HRC_TOKEN_REJECT_NFT.decodeCall(attempt.inputBytes());
        long[] serials = (long[])call.get(0);
        HandleException.validateFalse((serials.length > maxRejections ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_REFERENCE_LIST_SIZE_LIMIT_EXCEEDED);
        TokenID token = attempt.redirectTokenId();
        AccountID sender = attempt.senderId();
        ArrayList<TokenReference> referenceList = new ArrayList<TokenReference>();
        for (long serial : serials) {
            TokenReference tokenReference = TokenReference.newBuilder().nft(NftID.newBuilder().tokenId(token).serialNumber(serial).build()).build();
            referenceList.add(tokenReference);
        }
        return TransactionBody.newBuilder().tokenReject(TokenRejectTransactionBody.newBuilder().owner(sender).rejections(referenceList)).build();
    }
}

