/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.TransferAuditTest;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.config.data.AccountsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class CallStatusStandardizer {
    public static final CallStatusStandardizer CALL_STATUS_STANDARDIZER = new CallStatusStandardizer();

    private CallStatusStandardizer() {
    }

    public ResponseCodeEnum codeForFailure(@NonNull ResponseCodeEnum status, @NonNull MessageFrame frame, @NonNull CryptoTransferTransactionBody op) {
        Objects.requireNonNull(op);
        Objects.requireNonNull(status);
        Objects.requireNonNull(frame);
        if (status == ResponseCodeEnum.INVALID_ACCOUNT_ID) {
            return TransferAuditTest.isAuditFlagRaised(op, this.immutableAccountDebitAuditFor(frame)) ? ResponseCodeEnum.INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE : status;
        }
        return ReturnTypes.standardized(status);
    }

    private TransferAuditTest immutableAccountDebitAuditFor(@NonNull MessageFrame frame) {
        AccountsConfig accountsConfig = (AccountsConfig)FrameUtils.configOf(frame).getConfigData(AccountsConfig.class);
        final Set<Long> immutableAccounts = Set.of(Long.valueOf(accountsConfig.stakingRewardAccount()), Long.valueOf(accountsConfig.nodeRewardAccount()));
        return new TransferAuditTest(){

            @Override
            public boolean flagsAdjustment(@NonNull AccountAmount adjust) {
                return adjust.amount() < 0L && immutableAccounts.contains(adjust.accountIDOrElse(AccountID.DEFAULT).accountNumOrElse(Long.valueOf(0L)));
            }

            @Override
            public boolean flagsNftTransfer(@NonNull NftTransfer nftTransfer) {
                return immutableAccounts.contains(nftTransfer.senderAccountIDOrElse(AccountID.DEFAULT).accountNumOrElse(Long.valueOf(0L)));
            }
        };
    }
}

