/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.nativelibverification;

import com.hedera.node.config.data.ContractsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hyperledger.besu.crypto.Blake2bfMessageDigest;
import org.hyperledger.besu.crypto.SECP256K1;
import org.hyperledger.besu.crypto.SECP256R1;
import org.hyperledger.besu.evm.precompile.AbstractAltBnPrecompiledContract;
import org.hyperledger.besu.evm.precompile.AbstractBLS12PrecompiledContract;
import org.hyperledger.besu.evm.precompile.BigIntegerModularExponentiationPrecompiledContract;

@Singleton
public final class NativeLibVerifier {
    private static final Logger LOGGER = LogManager.getLogger(NativeLibVerifier.class);
    private final Supplier<ContractsConfig> contractsConfigSupplier;

    public NativeLibVerifier(Supplier<ContractsConfig> contractsConfigSupplier) {
        this.contractsConfigSupplier = contractsConfigSupplier;
    }

    public static List<Library> getDefaultNativeLibs() {
        ArrayList<Library> libs = new ArrayList<Library>();
        libs.add(new Library("secp256k1", () -> new SECP256K1().isNative()));
        libs.add(new Library("secp256r1", () -> new SECP256R1().isNative()));
        libs.add(new Library("besu blake2bf", Blake2bfMessageDigest.Blake2bfDigest::isNative));
        libs.add(new Library("besu gnark", AbstractBLS12PrecompiledContract::isAvailable));
        libs.add(new Library("altbn128 gnark196", AbstractAltBnPrecompiledContract::maybeEnableNative));
        libs.add(new Library("besu lib arithmetic", BigIntegerModularExponentiationPrecompiledContract::maybeEnableNative));
        return libs;
    }

    public void verifyNativeLibs() {
        boolean nodeHaltEnabled = this.contractsConfigSupplier.get().nativeLibVerificationHaltEnabled();
        LOGGER.info("Native library verification Halt mode is {}", (Object)(nodeHaltEnabled ? "enabled" : "disabled"));
        NativeLibVerifier.getDefaultNativeLibs().stream().filter(lib -> lib.isNative().get() == false).peek(lib -> LOGGER.warn("Native library {} is not present", (Object)lib.name())).findAny().ifPresent(lib -> {
            if (nodeHaltEnabled) {
                LOGGER.error("Native library {} is not present with halt mode enabled! Shutting down node.", (Object)lib.name());
                throw new IllegalStateException("Native libraries are not present with halt mode enabled");
            }
        });
    }

    public record Library(String name, Supplier<Boolean> isNative) {
    }
}

