/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.concurrent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.hiero.base.concurrent.locks.internal.AcquiredResource;
import org.hiero.base.concurrent.locks.locked.LockedResource;

public class BlockingResourceProvider<T> {
    private final Semaphore providePermit = new Semaphore(1);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition resourceProvided = this.lock.newCondition();
    private final Condition resourceReleased = this.lock.newCondition();
    private final AtomicBoolean waitingForResource = new AtomicBoolean(false);
    private final LockedResource<T> resource = new AcquiredResource<Object>(this::consumerDone, null);

    public boolean acquireProvidePermit() {
        if (!this.waitingForResource.get()) {
            return false;
        }
        return this.providePermit.tryAcquire();
    }

    public boolean tryBlockProvidePermit() {
        return this.providePermit.tryAcquire();
    }

    public void releaseProvidePermit() {
        this.providePermit.release();
    }

    public void provide(T resource) throws InterruptedException {
        this.lock.lock();
        try {
            if (!this.isWaitingForResource()) {
                return;
            }
            this.resource.setResource(resource);
            this.resourceProvided.signalAll();
            while (this.resource.getResource() != null) {
                this.resourceReleased.await();
            }
        }
        finally {
            this.lock.unlock();
            this.providePermit.release();
        }
    }

    public LockedResource<T> waitForResource() throws InterruptedException {
        this.lock.lock();
        this.waitingForResource.set(true);
        try {
            while (this.resource.getResource() == null) {
                this.resourceProvided.await();
            }
            LockedResource<T> lockedResource = this.resource;
            return lockedResource;
        }
        catch (InterruptedException e) {
            this.resource.close();
            throw e;
        }
        finally {
            this.waitingForResource.set(false);
        }
    }

    public boolean isWaitingForResource() {
        return this.waitingForResource.get();
    }

    private void consumerDone() {
        this.resource.setResource(null);
        this.resourceReleased.signalAll();
        this.lock.unlock();
    }
}

