/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.Mappers;
import io.helidon.common.mapper.ValueBacked;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Value<T> {
    public static <T> Value<T> create(Mappers mapperManager, String name, T value, String ... qualifiers) {
        Objects.requireNonNull(name, "Name of the Value must not be null");
        Objects.requireNonNull(value, "Value content for Value " + name + " must not be null, use empty(String) instead");
        return new ValueBacked<T>(mapperManager, name, value, qualifiers);
    }

    public static <T> Value<T> create(Mappers mapperManager, String name, T value, GenericType<T> type, String ... qualifiers) {
        Objects.requireNonNull(name, "Name of the Value must not be null");
        Objects.requireNonNull(value, "Value content for Value " + name + " must not be null, use empty(String) instead");
        return new ValueBacked<T>(mapperManager, name, value, type, qualifiers);
    }

    public String name();

    public T get();

    default public <N> N get(Class<N> type) throws MapperException, NoSuchElementException {
        return this.as(type).get();
    }

    default public <N> N get(GenericType<N> type) throws MapperException, NoSuchElementException {
        return this.as(type).get();
    }

    public <N> Value<N> as(Class<N> var1) throws MapperException;

    public <N> Value<N> as(GenericType<N> var1) throws MapperException;

    public <N> Value<N> as(Function<? super T, ? extends N> var1);

    public Optional<T> asOptional() throws MapperException;

    default public Optional<T> filter(Predicate<? super T> predicate) {
        return this.asOptional().filter(predicate);
    }

    default public <U> Optional<U> flatMap(Function<? super T, Optional<? extends U>> mapper) {
        return this.asOptional().flatMap(mapper);
    }

    default public Stream<T> stream() {
        return this.asOptional().stream();
    }

    public Value<Boolean> asBoolean();

    default public boolean getBoolean() {
        return this.get(Boolean.class);
    }

    public Value<String> asString();

    default public String getString() {
        return this.get(String.class);
    }

    public Value<Integer> asInt();

    default public int getInt() {
        return this.get(Integer.class);
    }

    public Value<Long> asLong();

    default public long getLong() {
        return this.get(Long.class);
    }

    public Value<Double> asDouble();

    default public double getDouble() {
        return this.get(Double.class);
    }
}

