/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.components;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.eventhandling.StateWithHashComplexity;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.state.config.StateConfig;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;
import org.hiero.consensus.state.snapshot.StateToDiskReason;

public class DefaultSavedStateController
implements SavedStateController {
    private static final Logger logger = LogManager.getLogger(DefaultSavedStateController.class);
    private Instant previousSavedStateTimestamp;
    private final StateConfig stateConfig;

    public DefaultSavedStateController(@NonNull PlatformContext platformContext) {
        this.stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
    }

    @Override
    @NonNull
    public StateWithHashComplexity markSavedState(@NonNull StateWithHashComplexity stateWithHashComplexity) {
        ReservedSignedState reservedSignedState = stateWithHashComplexity.reservedSignedState();
        SignedState signedState = reservedSignedState.get();
        StateToDiskReason reason = this.shouldSaveToDisk(signedState, this.previousSavedStateTimestamp);
        if (reason != null) {
            this.markSavingToDisk(reservedSignedState, reason);
        }
        return stateWithHashComplexity;
    }

    @Override
    public void reconnectStateReceived(@NonNull ReservedSignedState reservedSignedState) {
        try (ReservedSignedState reservedSignedState2 = reservedSignedState;){
            this.markSavingToDisk(reservedSignedState, StateToDiskReason.RECONNECT);
        }
    }

    @Override
    public void registerSignedStateFromDisk(@NonNull SignedState signedState) {
        this.previousSavedStateTimestamp = signedState.getConsensusTimestamp();
    }

    private void markSavingToDisk(@NonNull ReservedSignedState state, @NonNull StateToDiskReason reason) {
        SignedState signedState = state.get();
        logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Signed state from round {} created, will eventually be written to disk, for reason: {}", (Object)signedState.getRound(), (Object)reason);
        this.previousSavedStateTimestamp = signedState.getConsensusTimestamp();
        signedState.markAsStateToSave(reason);
    }

    @Nullable
    private StateToDiskReason shouldSaveToDisk(@NonNull SignedState signedState, @Nullable Instant previousTimestamp) {
        if (signedState.isFreezeState()) {
            return StateToDiskReason.FREEZE_STATE;
        }
        int saveStatePeriod = this.stateConfig.saveStatePeriod();
        if (saveStatePeriod <= 0) {
            return null;
        }
        if (previousTimestamp == null) {
            return StateToDiskReason.FIRST_ROUND_AFTER_GENESIS;
        }
        if (signedState.getConsensusTimestamp().getEpochSecond() / (long)saveStatePeriod > previousTimestamp.getEpochSecond() / (long)saveStatePeriod) {
            return StateToDiskReason.PERIODIC_SNAPSHOT;
        }
        return null;
    }
}

